/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.inputDevice;

import kinugasa.game.PlayerConstants;
import kinugasa.object.FourDirection;

/**
 * ̓foCX̏Ԃi[܂.
 * <br>
 * ̃NX́AvC[gpłfoCX̏ԂꌳǗ܂B<br>
 * ̃NXgp邱ƂŁA͏ԂȒPɌł܂B<br>
 * <br>
 * ͏Ԃ̍XVɂ́AȂ̎ԓIRXg܂B<br>
 * getInstance̎gṕA1[v1ɂƂǂ߂ĂB<br>
 * <br>
 * <br>
 * Q[N̐ݒɂāAgpȂfoCXꍇA ̃foCX̏Ԃ͏nullłB<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:55:04<br>
 * @author Dra0211<br>
 */
public final class InputState extends InputDeviceState {

	private static final long serialVersionUID = 2349722781837661059L;
	/**
	 * ݂̃L[{[h̏.
	 */
	private KeyState keyState = null;
	/**
	 * ÕL[{[h̏.
	 */
	private KeyState prevKeyState = null;
	/**
	 * ݂̃}EX̏.
	 */
	private MouseState mouseState = null;
	/**
	 * Õ}EX̏.
	 */
	private MouseState prevMouseState = null;
	//
	/**
	 * B̃CX^Xł.
	 */
	private static final InputState INSTANCE = new InputState();

	/**
	 * VOgNXł. getInstancegpĂB<br>
	 */
	private InputState() {
		if (PlayerConstants.getInstance().isUsingKeyboard()) {
			keyState = KeyConnection.createClearState();
		}
		if (PlayerConstants.getInstance().isUsingMouse()) {
			mouseState = MouseConnection.createClearState();
		}
	}

	/**
	 * CX^X擾܂. ̃\bhĂяoƁA݂̓͏Ԃ܂B<br>
	 *
	 * @return InputStatẽCX^XԂ܂B<br>
	 */
	public static InputState getInstance() {
		INSTANCE.refresh();
		return INSTANCE;
	}

	/**
	 * ͏ԂXV܂.
	 */
	private void refresh() {
		if (PlayerConstants.getInstance().isUsingMouse()) {
			prevMouseState = mouseState;
			mouseState = MouseConnection.getState();
		}
		if (PlayerConstants.getInstance().isUsingKeyboard()) {
			prevKeyState = keyState;
			keyState = KeyConnection.getState();
		}
	}

	@Override
	public boolean isAnyInput() {
		boolean result = false;
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result |= mouseState.isAnyInput();
		}
		return result | keyState.isAnyInput();
	}

	@Override
	public boolean isAnyButtonInput() {
		boolean result = false;
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result |= mouseState.isAnyButtonInput();
		}
		return result | keyState.isAnyButtonInput();
	}

	@Override
	public boolean isEmptyInput() {
		boolean result = true;
		if (PlayerConstants.getInstance().isUsingMouse()) {
			result &= mouseState.isEmptyInput();
		}
		return result & keyState.isEmptyInput();
	}

	/**
	 * L[{[h̃L[Ă邩܂.
	 *
	 * @param key 肷L[w肵܂B<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽL[݉ĂꍇAtrueԂ܂B<br>
	 */
	public boolean isPressed(Keys key, InputType type) {
		return type == InputType.CONTINUE
				? keyState.isPressed(key)
				: keyState.isPressed(key) && !prevKeyState.isPressed(key);
	}

	public boolean isPressedOr(InputType type, Keys... keys) {
		boolean result = false;
		for (Keys key : keys) {
			result |= isPressed(key, type);
		}
		return result;
	}

	public boolean isPressedAnd(InputType type, Keys... keys) {
		for (Keys key : keys) {
			if (!isPressed(key, type)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * }EX̃{^Ă邩܂.
	 *
	 * @param button 肷{^w肵܂B<br>
	 * @param type O̓͏Ԃ邩肵܂B<br>
	 * @return w肳ꂽ{^݉ĂꍇAtrueԂ܂B<br>
	 */
	public boolean isPressed(MouseButtons button, InputType type) {
		if (!PlayerConstants.getInstance().isUsingMouse()) {
			return false;
		}
		return type == InputType.CONTINUE
				? mouseState.isPressed(button)
				: mouseState.isPressed(button) && !prevMouseState.isPressed(button);
	}

	/**
	 * ݂̃L[{[h̏Ԃ擾܂. L[{[hgpłȂꍇAnullԂ܂B<br>
	 *
	 * @return L[{[h̏ԂԂ܂B<br>
	 */
	public KeyState getKeyState() {
		return keyState;
	}

	/**
	 * ÕL[{[h̏Ԃ擾܂. L[{[hgpłȂꍇAnullԂ܂B<br>
	 *
	 * @return L[{[h̏ԂԂ܂B<br>
	 */
	public KeyState getPrevKeyState() {
		return prevKeyState;
	}

	/**
	 * ݂̃}EX̏Ԃ擾܂. }EXgpłȂꍇAnullԂ܂B<br>
	 *
	 * @return }EX̏ԂԂ܂B<br>
	 */
	public MouseState getPrevMouseState() {
		return prevMouseState;

	}

	/**
	 * Õ}EX̏Ԃ擾܂. }EXgpłȂꍇAnullԂ܂B<br>
	 *
	 * @return }EX̏ԂԂ܂B<br>
	 */
	public MouseState getMouseState() {
		return mouseState;
	}

	@Override
	public InputState clone() {
		InputState result = (InputState) super.clone();

		if (this.mouseState != null) {
			result.mouseState = this.mouseState.clone();
		}
		if (this.prevMouseState != null) {
			result.prevMouseState = this.prevMouseState.clone();
		}
		if (this.keyState != null) {
			result.keyState = this.keyState.clone();
		}
		if (this.prevKeyState != null) {
			result.prevKeyState = this.prevKeyState.clone();
		}
		return result;
	}

	@Override
	public String toString() {
		return "InputState{" + "keyState=" + keyState + ", prevKeyState=" + prevKeyState + ", mouseState=" + mouseState + ", prevMouseState=" + prevMouseState + '}';
	}

}
