/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import kinugasa.contents.graphics.Animation;

/**
 * 摜zAj[VƂĕ\邽߂
 * ImageSprite̊gł.
 * <br>
 * imageUpdatetOON̂ƂAdraw\bhŎIɃAj[VXV܂B<Br>
 * ̑삪svȏꍇ́AimageUpdatefalseɐݒ肵AAnimationSpriteupdate\bh
 * R[邱Ƃŕ\摜XVł܂B<br>
 * imageUpdate̓ftHgłtrueɐݒ肳Ă܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_20:49:20<br>
 * @author Dra0211<br>
 */
public class AnimationSprite extends ImageSprite {

	private static final long serialVersionUID = -7028519961109967679L;
	private Animation animation;
	private boolean imageUpdate = true;

	/**
	 * VAj[VXvCg쐬܂.
	 * ̃RXgN^ł́A摜nullɁA`惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 */
	public AnimationSprite() {
		super();
		//image is null
	}

	/**
	 * VAj[VXvCg쐬܂.
	 * ̃RXgN^ł́A摜nullɁA
	 * `惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 */
	public AnimationSprite(float x, float y, float w, float h) {
		super(x, y, w, h);
	}

	/**
	 * VAj[VXvCg쐬܂.
	 * ̃RXgN^ł́A
	 * `惂fIMAGE_BOUNDS_XYɐݒ肳܂B<br>
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param animation \Aj[Vw肵܂B<br>
	 */
	public AnimationSprite(float x, float y, float w, float h, Animation animation) {
		super(x, y, w, h, animation.getCurrentImage());
		this.animation = animation;
	}

	/**
	 * VAj[VXvCg쐬܂.
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param animation \摜w肵܂B<br>
	 * @param model `@w肵܂B<br>
	 */
	public AnimationSprite(float x, float y, float w, float h, Animation animation, ImagePainter model) {
		super(x, y, w, h, animation.getCurrentImage(), model);
		this.animation = animation;
	}

	/**
	 * VAj[VXvCg쐬܂.
	 *
	 * @param x XvCgXWw肵܂B<br>
	 * @param y XvCgYWw肵܂B<br>
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param vector
	 * @param animation
	 * @param mm ړfw肵܂B<br>
	 * @param dm `惂fw肵܂B<br>
	 */
	public AnimationSprite(float x, float y, float w, float h, VectorF vector,
			MovingModel mm, Animation animation, ImagePainter dm) {
		super(x, y, w, h, vector, mm, animation.getCurrentImage(), dm);
		this.animation = animation;
	}

	/**
	 * VAj[VXvCg쐬܂.
	 * ̃RXgN^̓N[jOp̃}X^f[^쐬ꍇɗLpłB<br>
	 *
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param vector
	 * @param animation
	 * @param mm ړfw肵܂B<br>
	 * @param dm `惂fw肵܂B<br>
	 */
	public AnimationSprite(float w, float h, VectorF vector,
			MovingModel mm, Animation animation, ImagePainter dm) {
		super(w, h, vector, mm, animation.getCurrentImage(), dm);
		this.animation = animation;
	}

	/**
	 * VAj[VXvCg쐬܂.
	 * ̃RXgN^̓N[jOp̃}X^f[^쐬ꍇɗLpłB<br>
	 * ɃbZ[WEChẼACRȂǍWォݒ肵Ǎړ邱Ƃ̂Ȃ
	 * XvCgɌʓIłB<br>
	 *
	 * @param w XvCg̕w肵܂B<br>
	 * @param h XvCg̍w肵܂B<br>
	 * @param animation
	 * @param dm `惂fw肵܂B<br>
	 */
	public AnimationSprite(float w, float h, Animation animation, ImagePainter dm) {
		super(0, 0, w, h, animation.getCurrentImage(), dm);
		this.animation = animation;
	}

	public Animation getAnimation() {
		return animation;
	}

	public void setAnimation(Animation animation) {
		this.animation = animation;
	}

	public void setImageUpdate(boolean imageUpdate) {
		this.imageUpdate = imageUpdate;
	}

	public boolean isImageUpdate() {
		return imageUpdate;
	}

	/**
	 * Aj[VXVAŐV̉摜Kp܂.
	 * ̃\bh́Adraw\bhɂ`̊AIɃR[܂B<br>
	 * ݒ肳ĂAj[Vnull̏ꍇ͉s܂B<br>
	 */
	@Override
	public void update() {
		if (animation == null) {
			return;
		}
		animation.update();
		setImage(animation.getCurrentImage());
	}

	@Override
	public void draw(Graphics2D g) {
		super.draw(g);
		if (imageUpdate & isVisible() & isExist()) {
			update();
		}
	}

	@Override
	public AnimationSprite clone() {
		AnimationSprite result = (AnimationSprite) super.clone();
		if (this.animation != null) {
			result.animation = this.animation.clone();
		}
		return result;
	}

	@Override
	public String toString() {
		return "ImageSprite location=[" + getX() + "," + getY() + "] size=["
				+ getWidth() + "," + getHeight() + "] " + "center=["
				+ getCenterX() + "," + getCenterY() + "] personalCenter=["
				+ getPersonalCenterX() + "," + getPersonalCenterY() + "] visible=["
				+ isVisible() + "] exist=[" + isExist() + "] speed=[" + getSpeed() + "] vector=["
				+ getVector() + "] z=[" + getZ() + "] image=[" + getImage() + "] drawingModel=["
				+ getPainter().getName() + "] animationImage=[" + animation + "]";
	}
}
