/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import kinugasa.object.movingModel.BasicMoving;
import kinugasa.object.movingModel.MovingEvent;

/**
 * {IȈړ@\ASprite̊gł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_17:03:44<br>
 * @author Dra0211<br>
 */
public abstract class BasicSprite extends Sprite implements Controllable {

	private static final long serialVersionUID = -6840053657197784234L;
	private VectorF vector;
	//
	/** ړASY. */
	private MovingModel moving;
	//

	public BasicSprite() {
		super();
		vector = new VectorF();
		moving = BasicMoving.getInstance();
	}

	public BasicSprite(float x, float y, float w, float h) {
		this(x, y, w, h, new VectorF());
	}

	public BasicSprite(float x, float y, float w, float h, VectorF vector) {
		super(x, y, w, h);
		this.vector = vector;
		this.moving = BasicMoving.getInstance();
	}

	public BasicSprite(float x, float y, float w, float h, VectorF vector, MovingModel model) {
		super(x, y, w, h);
		this.vector = vector;
		this.moving = model;
	}

	public BasicSprite(float w, float h, VectorF vector, MovingModel model) {
		super(0, 0, w, h);
		this.vector = vector;
		this.moving = model;
	}

	public float getAngle() {
		return vector.angle;
	}

	public void setAngle(float angle) {
		vector.angle = angle;
	}

	public float getSpeed() {
		return vector.speed;
	}

	public void setSpeed(float speed) {
		vector.speed = speed;
	}

	/**
	 * IuWFNgɐݒ肳Ăp[^уASYgpĈړ܂.
	 */
	public void move() {
		moving.move(this);
		updateCenter();
	}

	/**
	 * w̃ASYgpĈړ܂.
	 * 
	 * @param m ړ@.<br>
	 */
	public void move(MovingModel m) {
		m.move(this);
		updateCenter();
	}

	@Override
	public boolean move(float xValue, float yValue, Shape s) {
		float x = getX() + xValue * vector.speed;
		float y = getY() - yValue * vector.speed;
		if (s == null) {
			setX(x);
			setY(y);
			updateCenter();
			return true;
		}
		if (s.contains(new Point2D.Float(x + getPersonalCenterX(), y + getPersonalCenterY()))) {
			setX(x);
			setY(y);
			updateCenter();
			return true;
		}
		return false;
	}

	@Override
	public boolean move(Point2D.Float p, Shape s) {
		return move(p.x, p.y, s);
	}

	/**
	 * XvCg`悵܂.
	 * visible܂existfalsêƂA`悵Ă͂Ȃ܂.<br>
	 * 
	 * @param g OtBbNXReLXg.<br>
	 */
	@Override
	public abstract void draw(Graphics2D g);

	/**
	 * ̃XvCg݂̐ݒŎɈړ̒S̍WԂ܂.
	 * <br>
	 * ̃\bh́Aړfɂړil܂B<br>
	 * 
	 * @return ̒SW.<br>
	 */
	public Point2D.Float getNextCenter() {
		Point2D.Float p = (Point2D.Float) getCenter().clone();
		p.x += vector.getX();
		p.y += vector.getY();
		return p;
	}

	/**
	 * ̃XvCg݂̐ݒŎɈړ̍̍WԂ܂.
	 * <br>
	 * ̃\bh́Aړfɂړil܂B<br>
	 * 
	 * @return ̍W.<br>
	 */
	public Point2D.Float getNextLocation() {
		Point2D.Float p = getLocation();
		p.x += vector.getX();
		p.y += vector.getY();
		return p;
	}

	public VectorF getVector() {
		return vector;
	}

	public void setVector(VectorF vector) {
		this.vector = vector;
	}

	/**
	 * ړf擾܂.
	 * 
	 * @return ړf.<br>
	 */
	public MovingModel getMovingModel() {
		return moving;
	}

	/**
	 * ̃XvCg̈ړCxĝAw肵NX̃CxgԂ܂.
	 * ̃\bhł́ÃXvCg̈ړCxgMovingEventłꍇɂ
	 * ̓ĈړCxg̎Ԃ܂B<br>MovingEvent擾ɂ́A
	 * MovingEvent̃NXw肵܂B<br>
	 *
	 * @param model 郂f̃NXB<br>
	 *
	 * @return w肵NX̃Cxg܂܂Ăꍇɂ̃CX^XԂB݂ȂꍇnullԂB<br>
	 */
	public MovingModel getMovingModel(Class<? extends MovingModel> model) {
		if (moving instanceof MovingEvent) {
			MovingEvent me = (MovingEvent) moving;
			for (int i = 0; i < me.getModels().length; i++) {
				if (model.isInstance(me.getModels()[i])) {
					return me.getModels()[i];
				}
			}
			return null;
		}
		return (model.isInstance(moving)) ? moving : null;
	}

	/**
	 * ړfݒ肵܂.
	 * 
	 * @param movingModel ړf.<br>
	 */
	public void setMovingModel(MovingModel movingModel) {
		this.moving = movingModel;
	}

	/**
	 * ̃XvCg̕쐬܂.
	 * ̃\bhł́ASẴtB[hN[jO܂.<br>
	 * ̃\bh̓TuNXœK؂ɃI[o[ChĂ.<br>
	 * 
	 * @return ̃XvCgƓݒ̐VCX^X.<br>
	 */
	@Override
	public BasicSprite clone() {
		BasicSprite s = (BasicSprite) super.clone();
		s.vector = this.vector.clone();
		s.moving = this.moving.clone();
		return s;
	}

	/**
	 * XvCg̕\L擾܂.
	 * ɂ̓XvCg̃tB[h񂪊܂܂Ă܂.̒lׂ͂ăANZTʂĎ擾\ł.<br>
	 * 
	 * @return XvCg̏.<br>
	 */
	@Override
	public String toString() {
		return "BasicSprite location=[" + getX() + "," + getY() + "] size=["
				+ getWidth() + "," + getHeight() + "] " + "center=["
				+ getCenterX() + "," + getCenterY() + "] personalCenter=["
				+ getPersonalCenterX() + "," + getPersonalCenterY() + "] visible=["
				+ isVisible() + "] exist=[" + isExist() + "] vector=[" + getVector() + "] "
				+ "z=[" + getZ() + "]";
	}
}
