/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.game.GameLog;
import kinugasa.util.StopWatch;

/**
 * `bvi[Xg[Wł.
 * <br>
 * `bvXMĹAkinugasaChipAttribute.dtdgp܂B<br>
 * `bvXML烍[hۂ̃tH[}bgDTDmFĂB<br>
 * <br>
 * ̃Xg[Wɂ́A2̃`bvŒǉ܂B<br>
 * <li>"VOID"</li>
 * <br>
 * ̑́Aړiړ\łB
 * <br>
 * <li>"CLOSE"</li>
 * <br>
 * ̑́Aړiňړł܂B
 * <br>
 * <br>
 * ͍̑폜ł܂B(폜Ɏǉ܂j<br>
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/04/28_21:59:44<br>
 * @author Dra0211<br>
 */
public final class ChipAttributeStorage extends Storage<ChipAttribute>
		implements Serializable, XMLFileSupport {

	private static final long serialVersionUID = -3407377075571254018L;
	/**
	 * B̃CX^Xł.
	 */
	private static final ChipAttributeStorage INSTANCE = new ChipAttributeStorage();

	/**
	 * VOgNXł. getInstancegpĂB<br>
	 */
	private ChipAttributeStorage() {
		putDefaultAttribute();
	}

	/**
	 * {@inheritDoc }
	 *
	 * @throws DuplicateNameException `bv̖Odꍇɓ܂B<br>
	 */
	@Override
	public void readFromXML(String filePath)
			throws IllegalXMLFormatException, ContentsFileNotFoundException,
			ContentsIOException, DuplicateNameException {
		StopWatch watch = new StopWatch().start();
		XMLReader reader = new XMLReader(filePath).load();
		XMLElement root = reader.getFirst();
		if (!"kinugasaChipAttribute".equals(root.getName())) {
			throw new IllegalXMLFormatException("illegal root node name : " + root);
		}
		List<XMLElement> attributeElements = root.getElement("attribute");
		for (int i = 0, size = attributeElements.size(); i < size; i++) {
			add(new ChipAttribute(attributeElements.get(i).getAttributes().get("name").getValue()));
		}
		reader.free();
		watch.stop();
		GameLog.printInfo("`bvɓǂݍ܂܂(" + watch.getTime() + " ms) : size=[" + size() + "]");
		List<ChipAttribute> list = new ArrayList<ChipAttribute>(getAll());
		Collections.sort(list);
		for (int i = 0, size = list.size(); i < size; i++) {
			GameLog.printInfo("- " + list.get(i).toString());
		}
	}

	/**
	 * 폜уNAۂɁAftHgŒǉĂ `bvݒ肵Ȃ܂.
	 */
	private void putDefaultAttribute() {
		put(new ChipAttribute("VOID"));
		put(new ChipAttribute("CLOSE"));
	}

	/**
	 * Ce[^Ԃ܂. ̎ł́ACe[^̍폜sƁA ɓ삵ȂȂ\܂B<br>
	 *
	 * @return Ce[^Ԃ܂B<br>
	 */
	@Override
	public Iterator<ChipAttribute> iterator() {
		return super.iterator();
	}

	/**
	 * CX^X擾܂.
	 *
	 * @return ChipAttributeStoragẽCX^XԂ܂B<br>
	 */
	public static ChipAttributeStorage getInstance() {
		return INSTANCE;
	}

	@Override
	public void remove(ChipAttribute val) {
		super.remove(val);
		putDefaultAttribute();
	}

	@Override
	public void remove(String key) {
		super.remove(key);
		putDefaultAttribute();
	}

	@Override
	public void removeAll(ChipAttribute... values) {
		super.removeAll(values);
		putDefaultAttribute();
	}

	@Override
	public void removeAll(Collection<? extends ChipAttribute> values) {
		super.removeAll(values);
		putDefaultAttribute();
	}

	@Override
	public void removeAll(String... keys) {
		super.removeAll(keys);
		putDefaultAttribute();
	}

	@Override
	public void clear() {
		super.clear();
		putDefaultAttribute();
	}
}
