/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import java.io.Serializable;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;

/**
 * tB[h}bv1̃CgpA}bv`bṽZbgł.
 * <br>
 * `bvZbg1XMLt@Cɒ`AChipSetStorageNX烍[h܂B<br>
 * 쐬ꂽ`bvZbǵAOȂChipSetStorageNXɎǉ܂B<br>
 * Õ`bvZbgo^ĂꍇAO𓊂܂B<Br>
 * <br>
 * `bvZbgɂ͖O"VOID"̃`bvǉ܂B̃`bv͋̉摜ijA "VOID"łB<br>
 * <br>
 *
 * @version 1.0.0 - 2013/04/28_23:26:33<br>
 * @author Dra0211<br>
 */
public class ChipSet extends Storage<MapChip> implements Nameable, Serializable, Comparable<ChipSet> {

	private static final long serialVersionUID = 7240169495094793450L;
	/**
	 * ̃`bvZbg̖Oł.
	 */
	private String name;
	/**
	 * `bvZbg摜̐؂oTCY̕ł.
	 */
	private int cutWidth;
	/**
	 * `bvZbg摜̐؂oTCY̍ł.
	 */
	private int cutHeight;

	/**
	 * V`bvZbg쐬܂. 쐬ꂽ`bvZbg͎IChipSetStorageɒǉ܂B<br>
	 *
	 * @param name `bvZbg̖Ow肵܂B<br>
	 * @param cutWidth `bvZbg摜̐؂oTCY̕łB<br>
	 * @param cutHeight `bvZbg摜̐؂oTCY̍łB<br>
	 * @throws DuplicateNameException OłɎgpĂƂɓ܂B<br>
	 */
	public ChipSet(String name, int cutWidth, int cutHeight) throws DuplicateNameException {
		this.name = name;
		this.cutWidth = cutWidth;
		this.cutHeight = cutHeight;
		addThis();
	}

	/**
	 * ChipSetStoragethisCX^Xǉ܂.
	 *
	 * @throws DuplicateNameException OłɎgpĂƂɓ܂B<br>
	 */
	private void addThis() throws DuplicateNameException {
		ChipSetStorage.getInstance().add(this);
		put(new MapChip("VOID", new SerializableImage(ImageUtil.newImage(cutWidth, cutHeight)),
				ChipAttributeStorage.getInstance().get("VOID")));
	}

	@Override
	public String getName() {
		return name;
	}

	public int getCutWidth() {
		return cutWidth;
	}

	public int getCutHeight() {
		return cutHeight;
	}

	@Override
	public int compareTo(ChipSet o) {
		return this.name.compareTo(o.getName());
	}
}
