/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Loadable;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.contents.sound.SoundMap;

/**
 * tB[h}bvƂ̊֘Af[^[hA\z@\`܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/05/05_0:09:15<br>
 * @author Dra0211<br>
 */
public interface FieldMapBuilder extends Freeable, Nameable, Loadable, Comparable<FieldMapBuilder> {

	@Override
	public String getName();

	//̌ʂnew߂Ă͂ȂȂ
	public FieldMap getFieldMap() throws NotYetLoadedException;

	public int getChipHeight();

	public int getChipWidth();

	public NodeMap getNodeMap();

	public SoundMap getSoundMap();

	@Override
	public XMLFieldMapBuilder load() throws IllegalXMLFormatException, NumberFormatException, NameNotFoundException;

	@Override
	public XMLFieldMapBuilder free();

	public XMLFieldMapBuilder freeSound();

	@Override
	public boolean isLoaded();

	public TextStorage getTextStorage();

	public MessageWindowSprite getMessageWindowSprite();
}
