/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.sound.LoopPoint;
import kinugasa.contents.sound.SoundBuilder;
import kinugasa.contents.sound.SoundMap;
import kinugasa.contents.text.XMLAttributeStorage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.game.GameLog;
import kinugasa.object.FourDirection;
import kinugasa.util.StopWatch;
import kinugasa.util.StringUtil;

/**
 * SẴtB[h}bvr_i[Xg[Wł.
 * <br>
 * tB[h}bvr_XMĹAkinugasaFieldMapBuilder.dtdgp܂B<br>
 * tB[h}bvr_XML烍[hۂ̃tH[}bgDTDmFĂB<br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/04/29_15:52:24<br>
 * @author Dra0211<br>
 */
public final class FieldMapBuilderStorage extends Storage<FieldMapBuilder>
		implements XMLFileSupport {

	/**
	 * B̃CX^Xł.
	 */
	private static final FieldMapBuilderStorage INSTANCE = new FieldMapBuilderStorage();
	//}bvzuʒuiMapData.xml->root.attr
	private int x;
	private int y;
	private int width;
	private int height;

	/**
	 * VOgNXł. getInstancegpĂB<br>
	 */
	private FieldMapBuilderStorage() {
	}

	/**
	 * CX^X擾܂.
	 *
	 * @return FieldMapBuilderStoragẽCX^XԂ܂B<br>
	 */
	public static FieldMapBuilderStorage getInstance() {
		return INSTANCE;
	}

	/**
	 * {@inheritDoc }
	 *
	 * @param filePath
	 * @throws IllegalXMLFormatException
	 * @throws ContentsFileNotFoundException
	 * @throws ContentsIOException
	 * @throws DuplicateNameException
	 * @throws NumberFormatException
	 */
	@Override
	public void readFromXML(String filePath)
			throws IllegalXMLFormatException, ContentsFileNotFoundException,
			ContentsIOException, DuplicateNameException, NumberFormatException {
		StopWatch watch = new StopWatch().start();
		XMLReader reader = new XMLReader(filePath).load();
		XMLElement root = reader.getFirst();
		if (!"kinugasaFieldMapBuilder".equals(root.getName())) {
			throw new IllegalXMLFormatException("illegal root node name :" + root);
		}

		x = root.getAttributes().get("x").getIntValue();
		y = root.getAttributes().get("y").getIntValue();
		width = root.getAttributes().get("width").getIntValue();
		height = root.getAttributes().get("height").getIntValue();
		List<XMLElement> fieldMapList = root.getElement("fieldMap");
		for (int i = 0, size = fieldMapList.size(); i < size; i++) {
			XMLElement fieldMapElement = fieldMapList.get(i);
			String fieldMapName = fieldMapElement.getAttributes().get("name").getValue();
			XMLReader dataFileReader = new XMLReader(fieldMapElement.getAttributes().get("data").getValue());
			SoundMap bgmMap = createSoundMap(fieldMapName, fieldMapElement.getElement("bgm"));
			NodeMap nodeMap = createNodeMap(fieldMapElement.getElement("node"));
			String textDataPath = null;
			if (fieldMapElement.hasElement("textData")) {
				textDataPath = fieldMapElement.getElement("textData").get(0).getAttributes().get("data").getValue();
			}
			new XMLFieldMapBuilder(fieldMapName, bgmMap, nodeMap, dataFileReader, textDataPath, x, y);
		}
		reader.free();
		watch.stop();
		GameLog.printInfo("tB[h}bvr_[ɓǂݍ܂܂(" + watch.getTime() + " ms) : size=[" + size() + "]");
		List<FieldMapBuilder> list = new ArrayList<FieldMapBuilder>(getAll());
		Collections.sort(list);
		for (int i = 0, size = list.size(); i < size; i++) {
			GameLog.printInfo("- " + list.get(i).toString());
		}
	}

	/**
	 * SoundMap쐬܂.
	 *
	 * @param fieldMapName TEh}bv̖OƂȂtB[h}bv̖O𑗐M܂B<br>
	 * @param element BGMGgłB<br>
	 * @return BGMGgTEh}bv\zĕԂ܂Belementnull̏ꍇ ̃TEh}bvԂ܂B<br>
	 */
	private SoundMap createSoundMap(String fieldMapName, List<XMLElement> element) {
		SoundMap soundMap = new SoundMap(fieldMapName);
		if (element == null) {
			return soundMap;
		}
		for (int i = 0, size = element.size(); i < size; i++) {
			XMLAttributeStorage attr = element.get(i).getAttributes();

			String fileName = attr.get("file").getValue();
			SoundBuilder builder = new SoundBuilder(fileName);
			builder.setName(attr.contains("name")
					? attr.get("name").getValue()
					: StringUtil.fileName(fileName));
			if (attr.contains("loopFrom") && attr.contains("loopTo")) {
				int from = LoopPoint.valueOf(attr.get("loopFrom").getValue());
				int to = LoopPoint.valueOf(attr.get("loopTo").getValue());
				builder.setLoopPoint(from, to);
			}
			if (attr.contains("volume")) {
				builder.setMasterGain(attr.get("volume").getFloatValue());
			}
			soundMap.add(builder.builde());
		}
		return soundMap;
	}

	/**
	 * NodeMap쐬܂.
	 *
	 * @param element NODEGgłB<br>
	 * @return NODEGgm[h}bv\zĕԂ܂Belementnull̏ꍇ ̃m[h}bvԂ܂B<br>
	 */
	private NodeMap createNodeMap(List<XMLElement> element) {
		NodeMap nodeMap = new NodeMap();
		if (element == null) {
			return nodeMap;
		}
		for (int i = 0, size = element.size(); i < size; i++) {
			XMLAttributeStorage attr = element.get(i).getAttributes();

			String nodeName = attr.get("name").getValue();
			int x = Integer.parseInt(attr.get("x").getValue());
			int y = Integer.parseInt(attr.get("y").getValue());
			String mapName = attr.get("map").getValue();
			String exitNode = attr.get("exitNode").getValue();
			FourDirection face = FourDirection.valueOf(attr.get("face").getValue());
			String tooltip = attr.getIfContains("tooltip").getValue();
			NodeAccepter accepter = attr.contains("accepter")
					? NodeAccepterStorage.getInstance().get(attr.get("accepter").getValue())
					: null;
			Node node = new Node(nodeName, new Point(x, y), mapName, exitNode, tooltip, face, accepter);
			nodeMap.put(node.getLocation(), node);
		}
		return nodeMap;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	@Override
	public String toString() {
		return "FieldMapBuilderStorage{" + "x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + '}';
	}
}
