/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import java.awt.Point;
import kinugasa.contents.resource.Nameable;
import kinugasa.object.FourDirection;

/**
 * tB[h}bvԂړA}bvJڂs߂̏oł.
 * <br>
 * m[h̓tB[h}bṽ}bvJڃCxgŵʒuɐݒ肳܂B
 * LN^m[h̏ɈړƁAm[hɐݒ肳ꂽ
 * hohɈړ܂Bm[hmĂ玩IɈړ邩ǂ
 * Q[fUCɂĈقȂ܂B<br>
 * <br>
 * vC[̃m[hgp\ł邩́ANodeAcceptergpČ܂B<br>
 * ANodeAccepternull܂Bnull̏ꍇ͕Kgp\ƂȂ܂B<br>
 * <br>
 * m[hgp}bvJڂ̓t@C[h邽߁A
 * }bvJڒ͉ʂÓ]Ȃǂ̃GtFNggp܂B<br>
 * <br>
 * <br>
 * m[hʂĎ̃}bvɑJڂɂ́Aړ}bvƂ̃}bv
 * m[hw肵܂B<br>
 * <br>
 * @version 1.0.0 - 2013/04/29_12:26:43<br>
 * @author Dra0211<br>
 */
public class Node implements Nameable {

	/** m[ḧӓIȖOł.
	 * ÖӐ͓tB[h}bvłB<br>
	 */
	private final String name;
	/** ̃m[hݒuʒuł.
	 * ʒu̓}bv`bvx[XłB<br>
	 */
	private final Point location;
	/** ̃m[hɂđJڂ̃}bv̖Oł. */
	private final String exitMapName;
	/** ̃m[hɂđJڂɂ̃m[h̖Oł. */
	private final String exitNodeName;
	/** m[hoƂɁALN^Ăł. */
	private final FourDirection face;
	/** ̃m[h̐ł.
	 * null܂B<br>
	 */
	private String tooltip;
	/** ̃m[hNodeAccepterł. */
	private NodeAccepter accepter;

	/**
	 * Vm[h쐬܂.
	 * @param name }bvňӓIȖOw肵܂B<br>
	 * @param location ̃m[h̐ݒuʒułB<br>
	 * @param exitMapName ô}bvw肵܂B<br>
	 * @param exitNodeName õm[hw肵܂B<br>
	 * @param face oł̃LN^̌w肵܂B<br>
	 */
	public Node(String name, Point location, String exitMapName, String exitNodeName, FourDirection face) {
		this(name, location, exitMapName, exitNodeName, "", face);
	}

	/**
	 * Vm[h쐬܂.
	 * @param name }bvňӓIȖOw肵܂B<br>
	 * @param location ̃m[h̐ݒuʒułB<br>
	 * @param exitMapName ô}bvw肵܂B<br>
	 * @param exitNodeName õm[hw肵܂B<br>
	 * @param tooltip m[h̐łB<br>
	 * @param face oł̃LN^̌w肵܂B<br>
	 */
	public Node(String name, Point location, String exitMapName, String exitNodeName, String tooltip, FourDirection face) {
		this(name, location, exitMapName, exitNodeName, tooltip, face, null);
	}

	/**
	 * Vm[h쐬܂.
	 * @param name }bvňӓIȖOw肵܂B<br>
	 * @param location ̃m[h̐ݒuʒułB<br>
	 * @param exitMapName ô}bvw肵܂B<br>
	 * @param exitNodeName õm[hw肵܂B<br>
	 * @param tooltip m[h̐łB<br>
	 * @param face oł̃LN^̌w肵܂B<br>
	 * @param accepter NodeAccepterw肵܂B<br>
	 */
	public Node(String name, Point location, String exitMapName, String exitNodeName, String tooltip, FourDirection face, NodeAccepter accepter) {
		this.name = name;
		this.location = location;
		this.exitMapName = exitMapName;
		this.exitNodeName = exitNodeName;
		this.tooltip = tooltip;
		this.face = face;
		this.accepter = accepter;
	}

	/**
	 * m[h̐擾܂.
	 * @param tooltip m[hɐݒ肳łB<br>
	 */
	public void setTooltip(String tooltip) {
		this.tooltip = tooltip;
	}

	/**
	 * ̃m[hݒuꂽWԂ܂.
	 * @return XWԂ܂Bʒu̓}bv`bvx[XłB<br>
	 */
	public int getX() {
		return location.x;
	}

	/**
	 * ̃m[hݒuꂽWԂ܂.
	 * @return YWԂ܂Bʒu̓}bv`bvx[XłB<br>
	 */
	public int getY() {
		return location.y;
	}

	/**
	 * NodeAccepterݒ肵܂.
	 * @param accepter VNodeAccepter𑗐M܂Bnull܂B<br>
	 */
	public void setAccepter(NodeAccepter accepter) {
		this.accepter = accepter;
	}

	/**
	 * oƂȂ}bv̖OԂ܂.
	 * @return õ}bvłB<br>
	 */
	public String getExitMapName() {
		return exitMapName;
	}

	/**
	 * oƂȂm[h̖OԂ܂.
	 * @return õm[hłB<br>
	 */
	public String getExitNodeName() {
		return exitNodeName;
	}

	/**
	 * m[h̐擾܂.
	 * @return m[hɐݒ肳ꂽԂ܂B<br>
	 */
	public String getTooltip() {
		return tooltip;
	}

	/**
	 * oł̃LN^̌Ԃ܂.
	 * @return oł̃LN^̌łB<br>
	 */
	public FourDirection getFace() {
		return face;
	}

	/**
	 * ̃m[hɐݒ肳ꂽNodeAccepterԂ܂.
	 * @return NodeAccepterԂ܂B<br>
	 */
	public NodeAccepter getAccepter() {
		return accepter;
	}

	/**
	 * ̃m[hNodeAccepterĂ邩𒲂ׂ܂.
	 * @return getAccepter() != nullԂ܂B<br>
	 */
	public boolean hasAccepter() {
		return accepter != null;
	}

	/**
	 * ̃m[hL܂.
	 * @return m[hNodeAccepterݒ肳Ăꍇ́Aaccepter.accept()Ԃ܂B<Br>
	 * NodeAccepternull̏ꍇ͕KtrueԂ܂B<br>
	 */
	public boolean accept() {
		return hasAccepter() ? accepter.accept() : true;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * ̃m[ḧʒu擾܂.
	 * QƂԂ܂B<Br>
	 * @return m[hʒuԂ܂B<br>
	 */
	public Point getLocation() {
		return location;
	}

	@Override
	public String toString() {
		return "Node{" + "name=" + name + ", location=" + location + ", exitMapName="
				+ exitMapName + ", exitNodeName=" + exitNodeName + ", face=" + face
				+ ", tooltip=" + tooltip + ", accepter=" + accepter + '}';
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Node other = (Node) obj;
		if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
			return false;
		}
		return true;
	}
}
