/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.rpgui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.game.GameLog;
import kinugasa.util.StopWatch;

/**
 * SĂ̈ړiۊǂXg[Wł.
 * <br>
 * ړiXMĹAkinugasaVehicle.dtdgp܂B<br>
 * ړiXML烍[hۂ̃tH[}bgDTDmFĂB<br>
 *
 * <br>
 * ̃NX́hݎgp̈ړih̕ۊǏꏊ˂܂B<br>
 * A̕ۊǏꏊgp邩ǂ͊J҂ɔC܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/04/28_22:25:48<br>
 * @author Dra0211<br>
 */
public class VehicleStorage extends Storage<Vehicle>
		implements Serializable, XMLFileSupport {

	private static final long serialVersionUID = -8199049449459770547L;
	/**
	 * B̃CX^Xł.
	 */
	private static final VehicleStorage INSTANCE = new VehicleStorage();

	/**
	 * VOgNXł. getInstancegpĂB<br>
	 */
	private VehicleStorage() {
	}

	/**
	 * CX^X擾܂.
	 *
	 * @return VehicleStoragẽCX^XԂ܂B<br>
	 */
	public static VehicleStorage getInstance() {
		return INSTANCE;
	}
	/**
	 * ݎgp̈ړił.
	 */
	private Vehicle currentVehicle;

	/**
	 * ݎgpĂړi擾܂. ݒ肳ĂȂ́AnullԂ܂B<br>
	 *
	 * @return ݎgpĂړiłB<br>
	 */
	public Vehicle getCurrentVehicle() {
		return currentVehicle;
	}

	/**
	 * ݎgp̈ړiύX܂.
	 *
	 * @param currentVehicle Vړi𑗐M܂B<br>
	 */
	public void setCurrentVehicle(Vehicle currentVehicle) {
		this.currentVehicle = currentVehicle;
	}

	/**
	 * {@inheritDoc }
	 *
	 * @throws NameNotFoundException w肳ꂽO`bv ChipAttributeStorageɓo^ĂȂꍇɓ܂B<br>
	 */
	@Override
	public void readFromXML(String filePath)
			throws IllegalXMLFormatException, ContentsFileNotFoundException,
			ContentsIOException, NameNotFoundException {
		StopWatch watch = new StopWatch().start();
		XMLReader reader = new XMLReader(filePath).load();

		XMLElement root = reader.getFirst();
		if (!"kinugasaVehicle".equals(root.getName())) {
			throw new IllegalXMLFormatException("illegal root node name : " + root);
		}

		List<XMLElement> vehiclesElement = root.getElement("vehicle");

		for (int i = 0, size = vehiclesElement.size(); i < size; i++) {
			XMLElement vehicle = vehiclesElement.get(i);
			String name = vehicle.getAttributes().get("name").getValue();
			float speed = vehicle.getAttributes().get("speed").getFloatValue();
			List<XMLElement> chipAttribute = vehicle.getElement("stepOn");
			List<ChipAttribute> stepOnAttributes = new ArrayList<ChipAttribute>(chipAttribute.size());
			ChipAttributeStorage storage = ChipAttributeStorage.getInstance();
			for (int j = 0, attributeSize = chipAttribute.size(); j < attributeSize; j++) {
				stepOnAttributes.add(storage.get(chipAttribute.get(j).getAttributes().get("attribute").getValue()));
			}
			new Vehicle(name, speed, stepOnAttributes);//addThis
		}
		reader.free();
		watch.stop();
		GameLog.printInfo("r[Nɓǂݍ܂܂(" + watch.getTime() + " ms) : size=[" + size() + "]");
		List<Vehicle> list = new ArrayList<Vehicle>(getAll());
		Collections.sort(list);
		for (int i = 0, size = list.size(); i < size; i++) {
			GameLog.printInfo("- " + list.get(i).getName());
			List<ChipAttribute> st = list.get(i).getAttributeStorage().asList();
			for (int j = 0, vSize = st.size(); j < vSize; j++) {
				GameLog.printInfo("-- " + st.get(j));
			}
		}
	}
}
