/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.util;

/**
 * w[eBeBł.
 * <br>
 * <br>
 * Op֐̒l0.5x݂ŌvZ܂B̒l
 * ŏ̌ĂяoɃLbV܂B<br>
 * WFl[^kinugasa.util.RandomNXgpĂB<br>
 * <br>
 *
 * @version 3.0.0 - 2011/09/16_20:58<br>
 * @version 3.1.2 - 2011/11/03_17:04<br>
 * @version 4.0.0 - 2013/1/03_06:18<br>
 * @version 5.0.0 - 2013/01/11_17:25:19<br>
 * @version 5.1.0 - 2013/02/07_09:17<br>
 * @author Dra0211<br>
 */
public final class MathUtil {

	/**
	 * CX^Xł܂.<br>
	 */
	private MathUtil() {
	}
	/** sin̒lLbVzł. */
	private static final float[] sinTable = new float[720];
	/** cos̒lLbVzł. */
	private static final float[] cosTable = new float[720];

	static {
		for (int i = 0; i < sinTable.length; i++) {
			sinTable[i] = (float) Math.sin(Math.toRadians((float) i / 2f));
		}
		for (int i = 0; i < cosTable.length; i++) {
			cosTable[i] = (float) Math.cos(Math.toRadians((float) i / 2f));
		}
	}

	/**
	 * TCgi[Pxz쐬܂.
	 * 
	 * @param fq  TCg̎g.<br>
	 * @param mag g{.<br>
	 * @param max Ƃ̍ől.<br>
	 *
	 * @return w肵̈̃TCg\złli[ꂽz.<br>
	 */
	public static float[] createSinWaveArray(float fq, float mag, float max) {
		float[] reAry = new float[(int) (max / fq)];
		for (int i = 0; i < reAry.length; i++) {
			reAry[i] = (float) Math.sin(Math.toRadians(i * fq)) * mag;
		}
		return reAry;
	}

	/**
	 * TCgi[Pxz쐬܂.
	 * 
	 * @param fq      TCg̎g.<br>
	 * @param mag     g{.<br>
	 * @param max     Ƃ̍ől.<br>
	 * @param reverse truew肷Ɣg`tɃ\[g܂.<br>
	 *
	 * @return w肵̈̃TCg\złli[ꂽz.<br>
	 */
	public static float[] createSinWaveArray(float fq, float mag, float max, boolean reverse) {
		float[] reAry = new float[(int) (max / fq)];
		for (int i = 0; i < reAry.length; i++) {
			reAry[i] = (float) Math.sin(Math.toRadians(i * fq)) * mag;
			if (reverse) {
				reAry[i] = -reAry[i];
			}
		}
		return reAry;
	}

	/**
	 * TC擾܂.<br>
	 * 
	 * @param angle x@̊px𑗐M܂B<br>
	 *
	 * @return TC̒lԂ܂B<br>
	 */
	public static float sin(float angle) {
		int index = (int) (angle + angle);
		if (index < sinTable.length && index >= 0) {
			return sinTable[index];
		}
		return sin(angle < 0 ? angle + 360 : angle - 360);
	}

	/**
	 * RTC擾܂.
	 * 
	 * @param angle x@̊px𑗐M܂B<br>
	 *
	 * @return RTC̒lԂ܂B<br>
	 */
	public static float cos(float angle) {
		int index = (int) (angle + angle);
		if (index < cosTable.length && index >= 0) {
			return cosTable[index];
		}
		return cos(angle < 0 ? angle + 360 : angle - 360);
	}
}
