/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.util;

import java.io.Serializable;

/**
 * ƃ_CX̃G~[g񋟂܂.
 * <br>
 * WFl[^𗘗p@2܂B<br>
 * 1́AV[hw肵ĂA@\gp@łB<br>
 * V[h̓vC̕ۑȂǂɎgp邽߁Â悤ȃQ[fUC̏ꍇɂ́A
 * K؂ȃ^C~OŃV[h擾Kv܂B<br>
 * 2߂̕@́AV[hw肵Ȃŗ@\gp邱ƂłB<br>
 * ̏ꍇɂ́Aŏɗ@\(V[h̎擾(getSeed)܂)gp_ŁAKȃV[hKp܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/11_17:26:09<br>
 * @author Dra0211<br>
 */
public final class Random implements Serializable {

	private static final long serialVersionUID = 4919268115768305696L;

	/**
	 * CX^Xł܂.
	 */
	private Random() {
	}
	/** ݎgp̃V[hł. */
	private static long seed;
	/** WFl[^ł. */
	private static java.util.Random random;

	/**
	 * V[hKȐlŏ܂.
	 *
	 * @return KpꂽV[hԂ܂B<br>
	 */
	public static long initSeed() {
		return initSeed(System.nanoTime());
	}

	/**
	 * w肳ꂽV[hgpăWFl[^܂.
	 *
	 * @param seed ݒ肷V[hw肵܂B<br>
	 *
	 * @return KpꂽV[hԂ܂B<br>
	 */
	public static long initSeed(long seed) {
		random = new java.util.Random(Random.seed = seed);
		return seed;
	}

	/**
	 * gp̃V[hԂ܂.
	 *
	 * WFl[^ĂȂꍇ́AKȃV[hgpď܂B<br>
	 *
	 * @return gp̃V[hԂ܂B<br>
	 */
	public static long getSeed() {
		if (random == null) {
			initSeed();
		}
		return seed;
	}

	/**
	 * 01܂ł̃_floatlԂ܂.
	 *
	 * ʂɂ́A0͊܂܂܂A1͊܂܂܂B<br>
	 *
	 * @return 01܂ł̃_floatԂ܂B<br>
	 */
	public static float randomFloat() {
		if (random == null) {
			initSeed();
		}
		return random.nextFloat();
	}

	/**
	 * 0maxValue܂ł̃_floatlԂ܂.
	 *
	 * ʂɂ́A0͊܂܂܂AmaxValue͊܂܂܂B<br>
	 *
	 * @param maxValue ̍őlw肵܂B<br>
	 *
	 * @return 0maxValue܂ł̃_floatԂ܂B<br>
	 */
	public static float randomFloat(float maxValue) {
		if (random == null) {
			initSeed();
		}
		return randomFloat() * maxValue;
	}

	/**
	 * _intlԂ܂B
	 *
	 * @return Int̑SĂ͈̔͂̃_ȒlԂ܂B<br>
	 */
	public static int randomInt() {
		if (random == null) {
			initSeed();
		}
		return random.nextInt();
	}

	/**
	 * 0maxValue܂ł̃_intlԂ܂.
	 *
	 * ʂɂ́A0͊܂܂܂AmaxValue͊܂܂܂B<br>
	 *
	 * @param maxValue ̍őlw肵܂B0ȉ̏ꍇɂ0ɐ؂l߂܂B<br>
	 *
	 * @return 0maxValue܂ł̃_intԂ܂B<br>
	 */
	public static int randomAbsInt(int maxValue) {
		if (random == null) {
			initSeed();
		}
		return random.nextInt(maxValue < 0 ? 0 : maxValue);
	}

	/**
	 * _ȐintlԂ܂.
	 *
	 * @return Int̃_ȒlԂ܂B0܂݂܂B<br>
	 */
	public static int randomAbsInt() {
		return Math.abs(randomInt());
	}

	/**
	 * _booleanԂ܂.
	 *
	 * @return truefalseԂ܂B<br>
	 */
	public static boolean randomBool() {
		if (random == null) {
			initSeed();
		}
		return random.nextBoolean();
	}

	/**
	 * mp𔻒肵܂.
	 *
	 * @param p m01floatƂĎw肵܂B<br>
	 *
	 * @return p*100(%)̊mtrueԂ܂B]
	 * p0ȉ̏ꍇfalseAp1ȏ̏ꍇtrueԂ܂B<br>
	 */
	public static boolean percent(float p) {
		if (p <= 0f) {
			return false;
		}
		if (p >= 1f) {
			return true;
		}
		return randomFloat() < p;
	}

	/**
	 * KV[ȃ_CX[G~[g郁\bhł.
	 *
	 * @param num   _CXU񐔂w肵܂B̈0̏ꍇA0Ԃ܂B<br>
	 * @param sided _CX̖ʐw肵܂B<br>
	 *
	 * @return [num D sided] Ԃ܂B<br>
	 */
	public static int dice(int num, int sided) {
		return randomAbsInt(sided * num - num + 1) + (num);
	}

	/**
	 * 3ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 3]Ԃ܂B<br>
	 */
	public static int d3(int num) {
		return dice(num, 3);
	}

	/**
	 * 4ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 4]Ԃ܂B<br>
	 */
	public static int d4(int num) {
		return dice(num, 4);
	}

	/**
	 * 6ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 6]Ԃ܂B<br>
	 */
	public static int d6(int num) {
		return dice(num, 6);
	}

	/**
	 * 8ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 8]Ԃ܂B<br>
	 */
	public static int d8(int num) {
		return dice(num, 8);
	}

	/**
	 * 10ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 10]Ԃ܂B<br>
	 */
	public static int d10(int num) {
		return dice(num, 10);
	}

	/**
	 * 12ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 12]Ԃ܂B<br>
	 */
	public static int d12(int num) {
		return dice(num, 12);
	}

	/**
	 * 20ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 20]Ԃ܂B<br>
	 */
	public static int d20(int num) {
		return dice(num, 20);
	}

	/**
	 * 24ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 24]Ԃ܂B<br>
	 */
	public static int d24(int num) {
		return dice(num, 24);
	}

	/**
	 * 30ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 30]Ԃ܂B<br>
	 */
	public static int d30(int num) {
		return dice(num, 30);
	}

	/**
	 * 50ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 50]Ԃ܂B<br>
	 */
	public static int d50(int num) {
		return dice(num, 50);
	}

	/**
	 * 100ʃ_CXnumUvlԂ܂.
	 *
	 * @param num _CXU񐔂w肵܂B<br>
	 *
	 * @return [num D 100]Ԃ܂B<br>
	 */
	public static int d100(int num) {
		return dice(num, 100);
	}
}
