"""Cateogry -- a group of boards"""

from utils import *
from board import Board


class Category(object):
    """Category, a group of boards

    This class contains its title and boards inside.
    """
    
    def __init__(self, title):
        assert isinstance(title, (str,unicode))
        self._boards = []
        self._title = j(title)

    def title(self):
        return self._title
    
    def boards(self):
        """Return board iterator"""
        return iter(self._boards)

    def append(self, board):
        """Append a board to this category"""
        assert isinstance(board, Board)
        self._boards.append(board)
