"""Summary of topics in board"""

import marshal
import os.path
import config

class Summary(object):
    """Summary database of topics in a board

    This class contains provides access to summary information.  Every
    key is topic id and the correspondig value is dictionary.  It
    looks like this; {"000001":{"size":134}, "000002":{"size":12}}

    Example:
    >>> topic = Topic("foo","bar","123")
    >>> s = Summary(topic)
    >>> s.set(topic, "size":5)
    >>> s.get(topic, "size")
    5

    """
    
    def __init__(self, item):
        """Constructor

        item must have host() and path() methods, i.e. it must be a
        Board or Topic instance.
        """
        self._filepath = os.path.join(config.CACHEDIR,
                                      item.host(),
                                      item.path(),
                                      "summary")

    def set(self, topic, key, value):
        data = self._load()
        partial_data = data.get(topic.id(),{})
        partial_data.update({key:value})
        data[topic.id()] = partial_data
        self._save(data)

    def get(self, topic, key):
        d = self._load()
        if d.has_key(topic.id()):
            return d.get(topic.id()).get(key,None)
        else:
            return None

    def _save(self, data):
        dirname = os.path.dirname(self._filepath)
        if not os.path.exists(dirname):
            os.makedirs(dirname)
        marshal.dump(data, file(self._filepath,"w"))

    def _load(self):
        if os.path.exists(self._filepath):
            return marshal.load(file(self._filepath))
        else:
            return {}

