import unittest
import sys
sys.path.append((sys.path[0] or ".") + "/../")

from bbs.category import *
from bbs.board import Board


class CategoryTestCase(unittest.TestCase):
    def test_boards(self):
        boards = ["board1", "board2"]
        c = Category("title")
        c._boards = ["board1", "board2"]
        self.assertEqual([b for b in c.boards()], boards)

    def test_append(self):
        b1 = Board("kittywalk.sourceforge.jp","test1")
        b2 = Board("kittywalk.sourceforge.jp","test2")
        c = Category("title")
        c.append(b1)
        c.append(b2)
        self.assertEqual([b for b in c.boards()], [b1, b2])


if __name__ == "__main__":
    unittest.main()
