import unittest
import os.path
import sys
import marshal
import bbs.topic as topic
sys.path.append((sys.path[0] or ".") + "/../")

from config import *
from bbs.summary import *
import config


class SummaryTestCase(unittest.TestCase):
    def setUp(self):
        host = "kittywalk.sourceforge.jp"
        path = "test"
        id = "0000000001"
        self.topic = topic.Topic(host, path, id)
        self.filepath = os.path.join(config.CACHEDIR,host,path,"summary")
        if os.path.exists(self.filepath):
            os.remove(self.filepath)
        
    def test_set(self):
        """Summary.set()"""
        key,val = "key","val"
        s = Summary(self.topic)
        s.set(self.topic, key, val)
        self.assertEqual(marshal.load(file(self.filepath)),
                         {self.topic.id():{key:val}})

    def test_get(self):
        """Summary.get()"""
        key,val = "key","val"
        s = Summary(self.topic)
        s.set(self.topic, key, val)
        self.assertEqual(s.get(self.topic, key), val)

    def test_get_invalid_key(self):
        """Summary.get() when key is not available"""
        s = Summary(self.topic)
        marshal.dump({self.topic.id():{"anotherKey":"foo"}},
                     file(self.topic._info_file_path,"w"))
        self.assertEqual(s.get(self.topic, "key"), None)

    def test_get_invalid_topic(self):
        """Summary.get() when topic is not available"""
        s = Summary(self.topic)
        marshal.dump({"anotherTopic":{"key":"foo"}},
                     file(self.topic._info_file_path,"w"))
        self.assertEqual(s.get(self.topic, "key"), None)
   
if __name__ == "__main__":
    unittest.main()
