"""Widgets inheriting from Qt widgets"""

from qt import *

from utils import *


class KittyTabWidget(QTabWidget):
    def __init__(self, parent=None):
        QTabWidget.__init__(self, parent)
        self.setTabBar(KittyTabBar(self))
        self._tab_menu = self._TabMenu(self)

    class _TabMenu(QPopupMenu):
        def __init__(self, parent):
            QPopupMenu.__init__(self, parent)
            self._taget_widget = None
            self.insertItem(u("更新"), self._reload)
            self.insertSeparator()
            self.insertItem(u("閉じる"), self._close)

        def popup(self, widget, position):
            self._target_widget = widget
            QPopupMenu.popup(self, position)

        def _reload(self):
            self.emit(PYSIGNAL("requestReload"), (self._target_widget,))

        def _close(self):
            self.emit(PYSIGNAL("requestClose"), (self._target_widget,))


class KittyTabBar(QTabBar):
    """TabBar subclass

    KittyTabBar is subclass of QTabBar with few extensions.  This class 
    provides tabRightPressed() and similar PYSIGNAL's.  This wheel was 
    invented to use Qt2.3, while you don't need this class with Qt3.
    """

    def __init__(self, parent):
        QTabBar.__init__(self, parent)
        self._parent = parent

    def mousePressEvent(self, event):
        if event.button()==Qt.LeftButton:
            QTabBar.mousePressEvent(self, event)
        elif event.button()==Qt.RightButton:
            self._parent.emit(PYSIGNAL("tabRightPressed"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.MidButton:
            self._parent.emit(PYSIGNAL("tabMidPressed"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))

    def mouseDoubleClickEvent(self, event):
        if event.button()==Qt.LeftButton:
            self._parent.emit(PYSIGNAL("tabLeftDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.RightButton:
            self._parent.emit(PYSIGNAL("tabRightDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.MidButton:
            self._parent.emit(PYSIGNAL("tabMidDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))

    def pointedPage(self, event):
        current_id = self.currentTab()
        tab = self.selectTab(event.pos())
        self.setCurrentTab(tab)
        page = self._parent.currentPage()
        self.setCurrentTab(current_id)
        return page

