# -*- coding: utf8 -*-
"""Kittywalk application"""

from utils import *
from bbs import *
import Logger


class Application(object):
    """KittyWalk application

    This class handles critical works except user interface tasks.
    """

    def __init__(self, UserInterfaceClass):
        self._ui = UserInterfaceClass(self)
        self._bbs = BBS()
        self._bookmark = Bookmark()

    def start(self):
        """Start KittyWalk application"""
        Logger.log("Application started.")
        self._ui.start()
        Logger.log("Application quit.")

    def bbs(self, update=False):
        """Return BBS instance"""
        if update:
            try:
                self._echo(u("掲示板一覧のダウンロード中..."))
                self._bbs.update()
            except:
                self._echo(u("掲示板一覧のダウンロードに失敗"))
            else:
                self._echo(u("掲示板一覧のダウンロード完了"))
        return self._bbs

    def bookmark(self):
        """Return Bookmark"""
        return self._bookmark

    def topic_list(self, board, update=False):
        """Return list of Topic instances in board"""
        assert isinstance(board, Board)
        if update or board.is_empty():
            try:
                self._echo(u("ダウンロード開始: %s") % board.title())
                board.update()
            except:
                self._echo(u("ダウンロード失敗: %s") % board.title())
            else:
                self._echo(u("ダウンロード完了: %s") % board.title())
        return [t for t in board.topics()]

    def messages(self, topic, update=False):
        """Return list of message instances belonging to topic"""
        assert isinstance(topic, Topic)
        if update or topic.is_empty():
            try:
                self._echo(u("ダウンロード開始: %s") % topic.title())
                topic.update()
            except:
                self._echo(u("ダウンロード失敗: %s") % topic.title())
            else:
                self._echo(u("ダウンロード完了: %s") % topic.title())
        return [m for m in topic.messages()]

    def append_bookmark(self, item):
        self._bookmark.append(item)

    def remove_bookmark(self, item):
        self._bookmark.remove(item)

    def _echo(self, text):
        """Send text to the user interface to show"""
        self._ui.echo(text)

