"""Bookmark-containing Board"""

from __future__ import generators
import os
import xml.dom.minidom as minidom

from topic import Topic
from utils import *
import config


class Bookmark:
    """Bookmark"""

    def __init__(self):
        self._data_file_path = os.path.join(config.RCDIR, "bookmark.xml")

    def items(self):
        """Iterate over topics in bookmark

        This method read the data file, parse the data and yield every 
        Topic instances.

        """
        if os.path.exists(self._data_file_path):
            doc = minidom.parse(self._data_file_path)
            bm = doc.getElementsByTagName("bookmark")[0]
            doc, bm = self._read()
            for e in bm.getElementsByTagName("topic"):
                attr = e.getAttribute
                yield Topic(str(attr("host")),
                            str(attr("path")),
                            str(attr("id")),
                            attr("title"))

    def append(self, topic):
        assert isinstance(topic, Topic)
        doc, bm = self._read()
        # If topic is alread in self, return.
        if topic in [t for t in self.items()]:
            return
        # Append topic element
        new_node = minidom.Element("topic")
        new_node.setAttribute("host",topic.host())
        new_node.setAttribute("path",topic.path())
        new_node.setAttribute("id",topic.id())
        new_node.setAttribute("title",topic.title())
        bm.appendChild(new_node)
        self._write(doc)

    def remove(self, topic):
        assert isinstance(topic, Topic)
        doc, bm = self._read()
        # Remove topic element
        for e in bm.getElementsByTagName("topic"):
            attr = e.getAttribute
            if (str(attr("host")) == topic.host() and
                str(attr("path")) == topic.path() and
                str(attr("id")) == topic.id()):
                bm.removeChild(e)
        self._write(doc)

    def _read(self):
        """Return DOM and bookmark node as (dom, bookmark_node)"""
        if os.path.exists(self._data_file_path):
            dom = minidom.parse(self._data_file_path)
        else:
            dom = minidom.parseString("""<bookmark></bookmark>""")
        return dom, dom.getElementsByTagName("bookmark")[0]

    def _write(self, dom):
        """Write bookmark DOM on file"""
        file(self._data_file_path,"w").write(dom.toxml().encode("utf8"))

