"""HTTP method"""

import urlparse
import httplib
import urllib
import gzip
from cStringIO import StringIO 

_USER_AGENT = "Monazilla/1.00 (KittyWalk/0.3)"
OK = 200
NOT_MODIFIED = 304
PARTIAL_CONTENT = 206

def get(host, path, headers={}):
    """GET content at host+path using headers and return response in
    dictionary
    """
    isinstance(host, str)
    isinstance(path, str)
    isinstance(headers, dict)
    # Set up
    headers.update({"User-Agent":_USER_AGENT})
    # GET
    c = httplib.HTTPConnection(host)
    c.request("GET", path, "", headers)
    r = c.getresponse()
    # Read content
    content = r.read()
    if r.getheader("Content-Encoding","") == "gzip":
        content = gunzip(content)
    # Return response in dictionary
    return {"status":r.status,
            "last-modified":r.getheader("last-modified"),
            "content":content}

def gunzip(data):
    return gzip.GzipFile(fileobj=StringIO(data)).read()

