import unittest
import os
import sys

sys.path.append((sys.path[0] or ".") + "/../")
from bbs.Bookmark import Bookmark
import config
from bbs import Topic


class BookmarkTestCase(unittest.TestCase):
    def setUp(self):
        self.bookmark_board = Bookmark()
        self.bookmark_board._data_file_path = ".test"
        self.host = "kittywalk.sourceforge.jp"
        self.path = "test"
        self.id1 = "0000000001"
        self.id2 = "0000000002"
        file(self.bookmark_board._data_file_path,"w").write(
            """<bookmark>
            <topic host="%s" path="%s" id="%s" title="" />
            <topic host="%s" path="%s" id="%s" title="" />
            </bookmark>""" % (self.host, self.path, self.id1,
                              self.host, self.path, self.id2))

    def tearDown(self):
        if os.path.exists(self.bookmark_board._data_file_path):
            os.remove(self.bookmark_board._data_file_path)

    def test_topics(self):
        self.assertEqual([t for t in self.bookmark_board.items()],
                         [Topic(self.host,self.path,self.id1),
                          Topic(self.host,self.path,self.id2)])

    def test_append(self):
        id3= "0000000003"
        self.bookmark_board.append(Topic(self.host, self.path, id3))
        self.assertEqual([t for t in self.bookmark_board.items()],
                         [Topic(self.host,self.path,self.id1),
                          Topic(self.host,self.path,self.id2),
                          Topic(self.host,self.path,id3)])

    def test_append_when_not_existing(self):
        os.remove(self.bookmark_board._data_file_path)
        id= "0000000003"
        self.bookmark_board.append(Topic(self.host, self.path, id))
        self.assertEqual([t for t in self.bookmark_board.items()],
                         [Topic(self.host,self.path,id)])

    def test_remove(self):
        self.bookmark_board.remove(Topic(self.host,self.path,self.id1))
        self.assertEqual([t for t in self.bookmark_board.items()],
                         [Topic(self.host,self.path,self.id2)])

if __name__ == "__main__":
    unittest.main()
