import unittest
import os
import sys
sys.path.append((sys.path[0] or ".") + "/../")

import Logger
import config


class LoggerTestCase(unittest.TestCase):
    def tearDown(self):
        if os.path.exists(config.LOGPATH):
            os.remove(config.LOGPATH)

    def test_single_output(self):
        Logger.log("1")
        self.assertEqual(file(config.LOGPATH).read().strip()[-1], "1")

    def test_double_output(self):
        Logger.log("1")
        Logger.log("2")
        self.assertEqual(
          [l.strip()[-1] for l in file(config.LOGPATH).readlines()],
          ["1","2"])

if __name__ == "__main__":
    unittest.main()
