# -*- coding: utf8 -*-

from qt import *

from utils import *
from bbs import Topic


class BookmarkListWidget(QListView):
    def __init__(self, *args):
        QListView.__init__(self, *args)
        self.addColumn(u("スレッド"))
        self.setSorting(-1)  # sort disabled
        self.header().setClickEnabled(False)
        self._context_menu = self._ContextMenu(self)
        self._newtab = True

        self.connect(self,
                     SIGNAL("doubleClicked(QListViewItem *)"),
                     self._request_open)
        self.connect(self,
                     SIGNAL("returnPressed(QListViewItem *)"),
                     self._request_open)
        self.connect(
          self,
          SIGNAL("rightButtonClicked(QListViewItem *,const QPoint &, int)"),
          self._popup_context_menu)
        self.connect(self._context_menu, PYSIGNAL("requestRemove"),
                     self._remove_selected_item)
        self.connect(self._context_menu, PYSIGNAL("requestOpenInNewTab"),
                     self._request_open_in_new_tab)
        self.connect(self._context_menu, PYSIGNAL("requestOpenInCurrentTab"),
                     self._request_open_in_current_tab)

    def display(self, bookmark):
        """Display bookmark items"""
        self.clear()
        last_item = None
        for topic in bookmark.items():
            last_item = self._ListViewItem(self, last_item, topic)
            last_item.setText(0, topic.title())

    def _popup_context_menu(self, item, position, column):
        self._context_menu.popup(item, position)

    def _request_open_in_new_tab(self, item):
        self._request_open(item, True)

    def _request_open_in_current_tab(self, item):
        self._request_open(item, False)

    def _request_open(self, item, newtab=None):
        if newtab is None:
            newtab = self._newtab
        topic = item.topic()
        self.emit(PYSIGNAL("requestOpenMessages"), (topic, newtab))

    def _remove_selected_item(self, item):
        self.emit(PYSIGNAL("requestRemoveBookmark"), (item.topic(),))

    class _ListViewItem(QListViewItem):
        def __init__(self, parent, after, topic):
            QListViewItem.__init__(self, parent, after)
            assert isinstance(topic, Topic)
            self._topic = topic
            self.setText(0, topic.title())

        def topic(self):
            return self._topic

    class _ContextMenu(QPopupMenu):
        def __init__(self, *args):
            QPopupMenu.__init__(self, *args)
            self._signal = {}
            for text, signal in [(u("新しいタブで開く"),
                                  "requestOpenInNewTab"),
                                 (u("今のタブで開く"),
                                  "requestOpenInCurrentTab"),
                                 (u("削除"),
                                  "requestRemove")]:
                item_id = self.insertItem(text)
                self._signal[item_id] = signal
            self._item = None
            self.connect(self, SIGNAL("activated(int)"), self._activated)

        def _activated(self, item_id):
            self.emit(PYSIGNAL(self._signal[item_id]), (self._item,))

        def popup(self, item, position):
            self._item = item
            QPopupMenu.popup(self, position)
        
