"""UserInterface"""
from thread import start_new_thread

from qt import *

from ui.mainwindow import MainWindow


class UserInterface(QApplication):
    """User interface controller"""
    def __init__(self, app):
        QApplication.__init__(self, [])
        self._app = app
        self._main_window = MainWindow()
        self.setMainWidget(self._main_window)
        self.connect(self._main_window,
                     PYSIGNAL("requestOpenTopicList"),
                     self._open_topic_list)
        self.connect(self._main_window,
                     PYSIGNAL("requestReloadTopicList"),
                     self._reload_topic_list)
        self.connect(self._main_window,
                     PYSIGNAL("requestOpenMessages"),
                     self._open_messages)
        self.connect(self._main_window,
                     PYSIGNAL("requestReloadMessages"),
                     self._reload_messages)
        self.connect(self._main_window,
                     PYSIGNAL("requestChangeFont"),
                     self._change_font)
        self.connect(self._main_window,
                     PYSIGNAL("requestReloadBoardTree"),
                     self._reload_board_tree)
        self.connect(self._main_window,
                     PYSIGNAL("requestAppendBookmark"),
                     self._append_bookmark)
        self.connect(self._main_window,
                     PYSIGNAL("requestRemoveBookmark"),
                     self._remove_bookmark)

    def start(self):
        """Starts user interface

        This method 
        """
        self._main_window.show()
        self._main_window.display_board_tree(self._app.bbs())
        self._main_window.display_bookmark_list(self._app.bookmark())
        self.exec_loop()

    def echo(self, text):
        self._main_window.echo(text)

    def _open_topic_list(self, board, newtab):
        def proc(board, newtab):
            topics = self._app.topic_list(board)
            self._main_window.display_topic_list(board, topics, newtab)
        start_new_thread(proc, (board, newtab))

    def _reload_topic_list(self, board):

        def proc(board):
            topics = self._app.topic_list(board, update=True)
            self._main_window.display_topic_list(board, topics, False)
        start_new_thread(proc, (board,))

    def _open_messages(self, topic, newtab=None):
        def proc(topic, newtab):
            messages = self._app.messages(topic)
            self._main_window.display_messages(topic, messages, newtab)
        start_new_thread(proc, (topic, newtab))

    def _reload_messages(self, topic):
        def proc(topic):
            messages = self._app.messages(topic, True)
            self._main_window.display_messages(topic, messages, False)
        start_new_thread(proc, (topic,))

    def _reload_board_tree(self):
        def proc():
            bbs = self._app.bbs(update=True)
            self._main_window.display_board_tree(bbs)
        start_new_thread(proc, ())

    def _change_font(self, font):
        font, ok = QFontDialog.getFont(font, None)
        if ok:
            self._main_window.set_message_font(font)

    def _append_bookmark(self, item):
        self._app.append_bookmark(item)
        self._main_window.display_bookmark_list(self._app.bookmark())

    def _remove_bookmark(self, item):
        self._app.remove_bookmark(item)
        self._main_window.display_bookmark_list(self._app.bookmark())

