#ifndef _HASHTAB_H
#define _HASHTAB_H

struct bucket {
	unsigned long next;
	unsigned long value;
};

struct hashtab {
	unsigned long * table;
	unsigned long table_size;
	struct bucket * bucket;
	unsigned long bucket_size;
	unsigned long bucket_head;
};

extern int hashtab_init (struct hashtab * hashtab, unsigned long size);
extern void hashtab_destroy (struct hashtab * hashtab);
extern struct bucket * hashtab_entry(struct hashtab * hashtab, unsigned long h);
extern struct bucket * hashtab_next(struct hashtab * hashtab, struct bucket * b);
extern struct bucket * hashtab_chain(struct hashtab * hashtab, unsigned long h);
extern struct bucket * hashtab_null_bucket(struct hashtab * hashtab);

extern void hashtab_set_value(struct hashtab * hashtab,
			struct bucket * bucket, unsigned long value);

extern unsigned long hashtab_get_value(struct hashtab * hashtab,
						struct bucket * bucket);

#endif /* _HASHTAB_H */
