/*
 * linux/mm/kmemprof.c
 */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/notifier.h>
#include <linux/kmemprof.h>

static struct notifier_block * kmemprof_notifier;

void kmemprof_notifier_call_chain (enum kmemprof_event_type type,
					struct kmemprof_event * event)
{
	notifier_call_chain (&kmemprof_notifier, type, event);
}

int kmemprof_notifier_chain_register(struct notifier_block * nb)
{
	int err;
	err = notifier_chain_register (&kmemprof_notifier, nb);
	return err;
}

int kmemprof_notifier_chain_unregister(struct notifier_block * nb)
{
	int err;
	err = notifier_chain_unregister (&kmemprof_notifier, nb);
	return err;
}

EXPORT_SYMBOL(kmemprof_notifier_call_chain);
EXPORT_SYMBOL(kmemprof_notifier_chain_register);
EXPORT_SYMBOL(kmemprof_notifier_chain_unregister);

