
class NM_Sym
  attr_accessor :name, :type, :value

  def initialize(name, type, value)
    @name = name
    @type = type
    @value = value
  end

  def == (other)
    return (@name == other.name && @type == other.type &&
            @value == other.value)
  end
end

class NM_Reader
  def NM_Reader.All_Syms_Obj(obj)
    nm_comm = "nm " + obj
    NM_Reader.All_Syms(IO.popen(nm_comm))
  end

  def NM_Reader.All_Syms_File(file)
    NM_Reader.All_Syms(File.open(file))
  end

  def NM_Reader.All_Syms(io)
    nmsyms = []
    io.each_line do |line|
      tok = line.split
      nmsyms.push(NM_Sym.new(tok[2], tok[1], tok[0].hex)) if tok.length == 3
      nmsyms.push(NM_Sym.new(tok[1], tok[0], nil)) if tok.length == 2
    end
    return nmsyms
  end
end

