/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */


#include "base/clause.h"
#include "base/message.h"

using namespace std;

/*
 *   \̈߂NX
 */

    //w肵OԂ̐߃}bv擾
Clause::map_type * Clause::getClauseMap(string name) throw()
{
    map_type * result = NULL;
    Namespace::iterator scope;

    Namespace * const ns = Singleton<Namespace>::getInstance(nothrow);
    if(ns!= 0) {
        scope = ns->find(name);
        if(scope != ns->end())
            result = &(scope->second);
    }

    return result;
}

    //߂̓o^
void Clause::addClause(string _namespace, string _identifier) throw()
{
    if(isValid()) {
        Namespace * const ns = Singleton<Namespace>::getInstance(nothrow);
        if(ns != 0)
            (*ns)[_namespace][_identifier] = this;
//          ns->operator [](_namespace).insert(map_type::value_type(_identifier, this));        //㏑Ȃꍇ
    }
}

    //g[Nɑ΂Đߎʖ𐶐
string Clause::getClauseIdentifier(Token token) throw()
{
    string result;

    switch(token.getType()) {
        case Token::IDENTIFIER:
        case Token::PUNCTUATOR:
            result = token.getLiteral();    
            break;
        case Token::INTEGER:
            result.assign(INTEGER_CLAUSE_IDENTIFIER);
            break;
        case Token::LITERAL:
            result.assign(LITERAL_CLAUSE_IDENTIFIER);
            break;
        case Token::OPERATOR:
            result.assign(OPERATOR_CLAUSE_IDENTIFIER);
            break;
        default:
            result = string();
    }

    return result;
}

    //߂̉
bool Clause::parseClause(string ns, Parser & p)
{
    bool result = false;
    map_type::iterator scope;
    map_type * clause = getClauseMap(ns);

        //K[h
    if(clause == 0 || p.eof())
        return false;

        //g[N环ʖo
    Token  token;
    string identifier;

    token      = p.getToken();
    identifier = getClauseIdentifier(token);
    
        //ߏ̎s
    scope = clause->find(identifier);
    if(scope != clause->end()) {

            //fobOpbZ[Wo
        DebugMessage("Clause::parseClause(%) - %\n") << ns << identifier;

        try {
            scope->second->before(token, p);
            scope->second->body(token, p);  //qbĝs
            scope->second->after(token, p);
            result = true;
        }
        catch(...) {
            scope->second->onFail(token, p);    //sƂ̌n肢
            throw;
        }
    }
    else
        p.putback(token);   //ʎqɃ}b`̂o^ĂȂ

    return result;
}

    //firstŎn܂߂邩
bool Clause::hasClause(string ns, string first) throw()
{
    map_type * clause = getClauseMap(ns);
    if(clause == 0)
        return false;

    return clause->find(first) != clause->end();
}

    //p[XO
void Clause::before(const Token &, Parser &)
{}

    //p[X㏈
void Clause::after(const Token &, Parser &)
{}

    //W̗Ǒn[`
void Clause::onFail(const Token &, Parser & p) throw()
{
    Token token;

        //Ō܂œǂ݂
    while(!p.eof())
        token = p.getToken();
}

    //߂𕡐̎ʖɑΉt
void Clause::addMultipleClauses(string ns, string id_list) throw()
{
    string            id;
    string::size_type pos;
    string::size_type prev;

        //J}ŋ؂ꂽvfaddClause𔭍s
    if(isValid()) {
        prev = 0;
        do {
            pos = id_list.find_first_of(',', prev);
            id  = id_list.substr(prev, pos - prev);

            addClause(ns, id);

            prev = pos + 1;
        } while(pos != string::npos);
    }
}

    //[wvp] o^Ă߂̈ꗗ쐬
std::string Clause::makeClauseList(string ns, int width) throw()
{
    string result;
    map_type::iterator scope;
    map_type * clause = getClauseMap(ns);
    size_t max_length = 0;

        //ő̕񒷂߂
    scope = clause->begin();
    while(scope != clause->end()) {
        size_t i = scope->first.size();
        if(i > max_length)
            max_length = i;
        ++ scope;
    }

        //ꗗ쐬
    size_t max_column = width/(max_length+1);
    size_t column = 0;
    scope = clause->begin();
    while(scope != clause->end()) {
        size_t i = scope->first.size();

        result += scope->first;

        ++ column;
        ++ scope;

            //
        if(column == max_column || scope == clause->end())
            result += '\n';
        else {
            result += ',';
            result += string(max_length - i, ' ');
        }
    }

    return result;
}


    /*
     *   ÓIAPI
     */

    //p[XO
void StaticAPI::before(const Token & first, Parser & p)
{
    Token token = p.getToken();
    if(token != Token::LPAREN) {
        ExceptionMessage("StaticAPI [%] lacks left-parenthesis '('.","ÓIAPI[%]ɂ͊'('Ă") << first.getLiteral() << throwException;
    }
}

    //p[X㏈
void StaticAPI::after(const Token & first, Parser & p)
{
    Token token = p.getToken();
    if(token != Token::RPAREN) {
        ExceptionMessage("StaticAPI [%] lacks right-parenthesis ')'.","ÓIAPI[%]ɂ͊')'Ă") << first.getLiteral() << throwException;
    }
    else {
        token = p.getToken();
        if(token != ";")
            ExceptionMessage("StaticAPI [%] lacks ';' at the end of declaration.","ÓIAPI[%]̖';'Ă") << first.getLiteral() << throwException;
    }
}

    //s̉񕜏
void StaticAPI::onFail(const Token & , Parser & p) throw()
{   skip(p, false);   }


    //XLbv
    //   invalid_api : ɍŏɓǂݏoAPI͖
void StaticAPI::skip(Parser & p, bool invalid_api) throw()
{
        //Z~R or ̐ÓIAPȈo܂
    Token token;
    bool  condition; //A΍

    if(invalid_api)
        token = p.getToken();   //API͓ǂݔ΂

    do {
        token = p.getToken(true);

        condition = (!token.isValid()) ||                                                   //ȃg[N
                    (token == Token::PUNCTUATOR && token == ";") ||                         //Z~R
                    (token == Token::IDENTIFIER && hasStaticAPI(token.getLiteral()));       //ÓIAPI

    } while(!condition);

    if(token == Token::IDENTIFIER)
        p.putback(token);
}

    /*
     *   vvZXfBNeBu
     */

    //p[X㏈
void Directives::after(const Token & first, Parser & p) throw(Exception)
{
    Token token = p.getToken(true);
    if(!token.isValid() || !p.isLocatedonHeadofLine())
        ExceptionMessage("Directive [%] has a wrong parameter or misses a new-line.","fBNeBu[%]ɕsȈ邩AsȂ") << first.getLiteral() << throwException;
}

    //p[Xs̉񕜏
void Directives::onFail(const Token & , Parser & p) throw()
{
        //̉s܂œǂݔ΂
    Token token;

    do {
        token = p.getToken(true);
    } while(token.isValid() && !p.isLocatedonHeadofLine());
}

/************************************************* eXgXB[g *************************************************/

#ifdef TESTSUITE

#include "coverage_undefs.h"
#include <sstream>

namespace {
    class Clause_test : public Clause
    {
    public:
        Token        first;
        Token        second;
        bool         throw_exception;

        Clause_test(void) throw() : first(Token::ERROR), throw_exception(false) {}

        void body(const Token & _first, Parser & _p)
        {
            TestSuite::check("Clause_test::body");
            first = _first;
            second = _p.getToken();
            if(throw_exception)
                throw 0;
        }

        void before(const Token & , Parser & )
        {
            TestSuite::check("Clause_test::before");
        }

        void after(const Token &, Parser &)
        {
            TestSuite::check("Clause_test::after");
        }

        void onFail(const Token & _first, Parser & p) throw()
        {
            TestSuite::check("Clause_test::onFail");
            first = _first;
        }

        void onFail_super(const Token & _first, Parser & p) throw()
        {   Clause::onFail(_first, p);   }
    };
}

TESTSUITE(main, Clause)
{
    SingletonBase::ContextChain chain;
    chain.saveContext<Namespace>();

    BEGIN_CASE("getClauseIdentifier","getClauseIdentifier") {
        BEGIN_CASE("1","ʂ̎ʎq͂̂܂܂gɂȂ") {
            Token token(Token::IDENTIFIER, "test");

            if(getClauseIdentifier(token).compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","l͒gɊ֌WȂ" INTEGER_CLAUSE_IDENTIFIER "Ԃ") {
            Token token(Token::INTEGER, "", "", 0);

            if(getClauseIdentifier(token).compare(INTEGER_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","e͒gɊ֌WȂ" LITERAL_CLAUSE_IDENTIFIER "Ԃ") {
            Token token(Token::LITERAL, "");

            if(getClauseIdentifier(token).compare(LITERAL_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","Zq͒gɊ֌WȂ" OPERATOR_CLAUSE_IDENTIFIER "Ԃ") {
            Token token(Token::OPERATOR);

            if(getClauseIdentifier(token).compare(OPERATOR_CLAUSE_IDENTIFIER) != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("5","󔒂̃g[Nɂ͋󕶎(==)Ԃ") {
            Token token(Token::SPACE);

            if(!getClauseIdentifier(token).empty())
                TEST_FAIL;
        } END_CASE;

        TEST_CASE("6","G[g[Nɂ͋󕶎(==)Ԃ", getClauseIdentifier(Token(Token::ERROR)).empty());
        TEST_CASE("7","EOSg[Nɂ͋󕶎(==)Ԃ",   getClauseIdentifier(Token(Token::END_OF_STREAM)).empty());

    } END_CASE;

    BEGIN_CASE("getClauseMap","getClauseMap") {
        BEGIN_CASE("1","o^ĂȂԂɂNULLԂ") {
            chain.renewInstance();
            if(Clause::getClauseMap("unknown") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","vfΔ0Ԃ") {
            chain.renewInstance();
            Singleton<Namespace>::getInstance()->operator []("test");

            if(Clause::getClauseMap("test") == 0)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("addClause","addClause") {
        BEGIN_CASE("1","IuWFNgo^ł") {
            chain.renewInstance();
            Clause_test ct;
            Clause_test ct2;

            BEGIN_CASE("1","ʂɓo^") {
                ct.addClause("test","first_literal");

                TEST_CASE("1","OԂĂ", Singleton<Namespace>::getInstance()->size() == 1);
                TEST_CASE("2","\"test\"ƂԂ", Singleton<Namespace>::getInstance()->find("test") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","getClauseŃAhX", Clause::getClauseMap("test") != 0); 
                TEST_CASE("4","OԂ̐߂̐1",  Clause::getClauseMap("test")->size() == 1);
                TEST_CASE("5","\"first_literal\"̃m[h", Clause::getClauseMap("test")->find("first_literal") != Clause::getClauseMap("test")->end());
                TEST_CASE("6","֘Atꂽl", (*Clause::getClauseMap("test"))["first_literal"] == &ct);
            } END_CASE;

            BEGIN_CASE("2","2ڂo^") {
                ct2.addClause("test","second_literal");

                TEST_CASE("1","OԂĂȂ", Singleton<Namespace>::getInstance()->size() == 1);
                TEST_CASE("2","\"test\"ƂԂ", Singleton<Namespace>::getInstance()->find("test") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","OԂ̐߂̐2",  Clause::getClauseMap("test")->size() == 2);
                TEST_CASE("4","\"second_literal\"̃m[h", Clause::getClauseMap("test")->find("second_literal") != Clause::getClauseMap("test")->end());
                TEST_CASE("5","֘Atꂽl", (*Clause::getClauseMap("test"))["second_literal"] == &ct2);
            } END_CASE;

            BEGIN_CASE("3","2ڂ1ڂŏ㏑o^") {
                ct.addClause("test","second_literal");
                TEST_CASE("1","㏑Ă", (*Clause::getClauseMap("test"))["second_literal"] == &ct);
            } END_CASE;

            BEGIN_CASE("4","ႤOԂɓo^") {
                ct.addClause("TEST","first_literal");

                TEST_CASE("1","OԂĂ", Singleton<Namespace>::getInstance()->size() == 2);
                TEST_CASE("2","\"TEST\"ƂԂ", Singleton<Namespace>::getInstance()->find("TEST") != Singleton<Namespace>::getInstance()->end());
                TEST_CASE("3","getClauseŃAhX", Clause::getClauseMap("TEST") != 0); 
                TEST_CASE("4","OԂ̐߂̐1",  Clause::getClauseMap("TEST")->size() == 1);
                TEST_CASE("5","\"first_literal\"̃m[h", Clause::getClauseMap("TEST")->find("first_literal") != Clause::getClauseMap("TEST")->end());
                TEST_CASE("6","֘Atꂽl", (*Clause::getClauseMap("TEST"))["first_literal"] == &ct);
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("2","ȃIuWFNg͓o^Ȃ") {
            chain.renewInstance();

            ((Clause_test *)0)->addClause("test","first_literal");

            TEST_CASE("1","OԂĂȂ", Singleton<Namespace>::getInstance()->size() == 0);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("hasClause","hasClause") {
        Clause_test ct;
        chain.renewInstance();

        TEST_CASE("1","vfȂƂɂɓ삷", !Clause::hasClause("dummy","null"));

        ct.addClause("test","first_literal");

        TEST_CASE("2","o^vfTAtrueԂ", Clause::hasClause("test","first_literal"));
        TEST_CASE("3","݂ȂvffalseԂ", !Clause::hasClause("dummy","null"));
    } END_CASE;

    BEGIN_CASE("addMultipleClauses","addMultipleClauses") {
        BEGIN_CASE("1","P̐߂o^ł") {
            chain.renewInstance();
            Clause_test ct;

            ct.addMultipleClauses("test","first");

            TEST_CASE("1","o^߂", Clause::hasClause("test","first"));
        } END_CASE;

        BEGIN_CASE("2","̐߂o^") {
            chain.renewInstance();
            Clause_test ct;

            ct.addMultipleClauses("test","first,second,third");

            TEST_CASE("1","o^߂", Clause::hasClause("test","first"));
            TEST_CASE("2","o^߂", Clause::hasClause("test","second"));
            TEST_CASE("3","o^߂", Clause::hasClause("test","third"));
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("Clause::onFail","Clause::onFail") {
        stringstream buf;
        Parser p(&buf, "test");
        Token token;
        Clause_test ct;

        buf.str("first second third 4 5 6 siebt acht neunt 0xa");

        ct.onFail_super(token, p);
        TEST_CASE("1","Xg[͍Ō܂Őił", p.eof());
    } END_CASE;

    BEGIN_CASE("parseClause","parseClause") {
        chain.renewInstance();
        Clause_test ct;

        ct.addClause("test","first");

        BEGIN_CASE("1","OԂIĐ߂sł") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            TestSuite::clearCheckpoints();
            TEST_CASE("1","֐͐", Clause::parseClause("test", p));
            TEST_CASE("2","Clause::beforesĂ", TestSuite::isReached("Clause_test::before"));
            TEST_CASE("3","Clause::bodysĂ", TestSuite::isReached("Clause_test::body"));
            TEST_CASE("4","bodyfirst", ct.first == "first");
            TEST_CASE("5","bodyœǂݏog[N", ct.second == "second");
            TEST_CASE("6","Clause::aftersĂ", TestSuite::isReached("Clause_test::after"));
        } END_CASE;

        BEGIN_CASE("2","߂̏ɗONonFailĂ΂") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            ct.throw_exception = true;
            TestSuite::clearCheckpoints();

            bool result = false;
            try { Clause::parseClause("test", p); }
            catch(...){ result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","Clause::bodysĂ", TestSuite::isReached("Clause_test::body"));
            TEST_CASE("3","Clause::onFailsĂ", TestSuite::isReached("Clause_test::onFail"));
        } END_CASE;

        BEGIN_CASE("3","݂ȂOԂw肷") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("first second");

            TEST_CASE("1","֐͎s", !Clause::parseClause("unknown", p));
        } END_CASE;

        BEGIN_CASE("4","EOFɒBXg[w肷") {
            stringstream buf;
            Parser p(&buf, "test");
            buf.str("");
            buf.get();

            TEST_CASE("0","[O]Xg[͏I[ɒBĂ", buf.eof());
            TEST_CASE("1","֐͎s", !Clause::parseClause("unknown", p));
        } END_CASE;
    } END_CASE;

    chain.restoreContext();
}




namespace {
    class StaticAPI_test : public StaticAPI
    {
    public:
        StaticAPI_test(void) throw() : StaticAPI() {}
        StaticAPI_test(string src) throw() : StaticAPI(src) {}

        void body(const Token & , Parser &) { TestSuite::check("StaticAPI::body"); }
        void onFail_super(const Token & first, Parser & p) throw() { StaticAPI::onFail(first, p); }
    };
}

TESTSUITE(main, StaticAPI)
{
    Singleton<Namespace>::Context context;
    Singleton<Namespace>::saveContext(context);

    Exception::setThrowControl(true);

    BEGIN_CASE("regist","regist") {
        BEGIN_CASE("1","P̖Ow肵ēo^ł") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;

            api.regist("VTST_API");

            TEST_CASE("1","API͐o^łĂ",StaticAPI::hasStaticAPI("VTST_API"));
        } END_CASE;

        BEGIN_CASE("2","̖Ow肵ēo^") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;

            api.regist("API_1,API_2,API_3");

            TEST_CASE("1","API͐o^łĂ",StaticAPI::hasStaticAPI("API_1"));
            TEST_CASE("2","API͐o^łĂ",StaticAPI::hasStaticAPI("API_2"));
            TEST_CASE("3","API͐o^łĂ",StaticAPI::hasStaticAPI("API_3"));
        } END_CASE;

        BEGIN_CASE("3","㏑") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api;
            StaticAPI_test api2;
            StaticAPI_test api3;

            api.regist("test");
            TEST_CASE("1","API͐o^łĂ",StaticAPI::hasStaticAPI("test"));
            TEST_CASE("2","APInh", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api);

            api2.regist("test");
            TEST_CASE("3","APInh㏑Ă", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api2);

            api3.regist("test");
            TEST_CASE("4","APInh㏑Ă", (*StaticAPI::getClauseMap(NAMESPACE_STATICAPI))["test"] == &api3);
        } END_CASE;

        BEGIN_CASE("4","RXgN^œo^") {
            Singleton<Namespace>::renewInstance();
            StaticAPI_test api("API1,API2,API3");

            TEST_CASE("1","API͐o^łĂ",StaticAPI::hasStaticAPI("API1"));
            TEST_CASE("2","API͐o^łĂ",StaticAPI::hasStaticAPI("API2"));
            TEST_CASE("3","API͐o^łĂ",StaticAPI::hasStaticAPI("API3"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("parseStaticAPI","parseStaticAPI") {
        BEGIN_CASE("1","ÓIAPI𐳂ł") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API();");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = true;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","ÓIAPI̖{̂Ă΂Ă", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("2","'('YŗO") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API);");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","ÓIAPI̖{̂Ă΂Ȃ", !TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("3","')'YŗO") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API(; NEXT");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","ÓIAPI̖{̂Ă΂Ă", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;

        BEGIN_CASE("4","';'YŗO") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            StaticAPI_test api("API");

            buf.str("API() NEXT");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { StaticAPI::parseStaticAPI(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","ÓIAPI̖{̂Ă΂Ă", TestSuite::isReached("StaticAPI::body"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("onFail","onFail") {
        BEGIN_CASE("1","Z~R܂œǂݔ΂") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api;
            Token token;
            buf.str("api parameter;next_api next_api_parameter;");

            api.onFail_super(Token(), p);

            TEST_CASE("1","Z~R̎ǂ߂", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("2","API܂œǂݔ΂") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("api parameter_1 parameter_2 next_api next_api_parameter;");

            api.onFail_super(p.getToken(), p);

            TEST_CASE("1","APIǂ߂", p.getToken() == "next_api");
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("skip","skip") {
        BEGIN_CASE("1","Z~R܂œǂݔ΂") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api;
            Token token;
            buf.str("api parameter;next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","Z~R̎ǂ߂", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("2","API܂œǂݔ΂") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("parameter_1 parameter_2 next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","APIǂ߂", p.getToken() == "next_api");
        } END_CASE;

        BEGIN_CASE("3","擪APIłǂݔ΂ł") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Parser p(&buf, "test");
            StaticAPI_test api("api,next_api");
            buf.str("api parameter_1 parameter_2 next_api next_api_parameter;");

            StaticAPI::skip(p);

            TEST_CASE("1","APIǂ߂", p.getToken() == "next_api");
        } END_CASE;
    } END_CASE;
    
    Singleton<Namespace>::restoreContext(context);
}


namespace {
    class Directives_test : public Directives
    {
    public:
        bool throws;

        Directives_test(void) throw() : Directives(), throws(false) {}
        Directives_test(string src) throw() : Directives(src), throws(false)  {}

        void body(const Token & , Parser & ) throw(int)
        {
            TestSuite::check("Directives::body");
            if(throws)
                throw 0;
        }
    };
}

TESTSUITE(main, Directives)
{
    Singleton<Namespace>::Context context;
    Singleton<Namespace>::saveContext(context);

    Exception::setThrowControl(true);

    BEGIN_CASE("regist","regist") {
        BEGIN_CASE("1","P̖Ow肵ēo^ł") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;

            api.regist("include");

            TEST_CASE("1","API͐o^łĂ",Directives::hasDirectives("include"));
        } END_CASE;

        BEGIN_CASE("2","̖Ow肵ēo^") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;

            api.regist("pragma,define,endif");

            TEST_CASE("1","fBNeBu͐o^łĂ",Directives::hasDirectives("pragma"));
            TEST_CASE("2","fBNeBu͐o^łĂ",Directives::hasDirectives("define"));
            TEST_CASE("3","fBNeBu͐o^łĂ",Directives::hasDirectives("endif"));
        } END_CASE;

        BEGIN_CASE("3","㏑") {
            Singleton<Namespace>::renewInstance();
            Directives_test api;
            Directives_test api2;
            Directives_test api3;

            api.regist("test");
            TEST_CASE("1","fBNeBu͐o^łĂ",Directives::hasDirectives("test"));
            TEST_CASE("2","fBNeBunh", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api);

            api2.regist("test");
            TEST_CASE("3","fBNeBunh㏑Ă", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api2);

            api3.regist("test");
            TEST_CASE("4","fBNeBunh㏑Ă", (*Directives::getClauseMap(NAMESPACE_DIRECTIVES))["test"] == &api3);
        } END_CASE;

        BEGIN_CASE("4","RXgN^œo^") {
            Singleton<Namespace>::renewInstance();
            Directives_test api("pragma,define,endif");

            TEST_CASE("1","fBNeBu͐o^łĂ",Directives::hasDirectives("pragma"));
            TEST_CASE("2","fBNeBu͐o^łĂ",Directives::hasDirectives("define"));
            TEST_CASE("3","fBNeBu͐o^łĂ",Directives::hasDirectives("endif"));
        } END_CASE;
    } END_CASE;
    
    BEGIN_CASE("parseDirectives","parseDirectives") {
        BEGIN_CASE("1","fBNeBu𐳂ł") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma\nnext\n");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = true;
            try { Directives::parseDirectives(p); }
            catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","fBNeBu̖{̂Ă΂Ă", TestSuite::isReached("Directives::body"));
        } END_CASE;

        BEGIN_CASE("2","sȂ(sp[^)ŗO") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma next\n");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","fBNeBu̖{̂Ă΂Ă", TestSuite::isReached("Directives::body"));
        } END_CASE;

        BEGIN_CASE("3","sȂ(EOF)ŗO") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");

            buf.str("pragma");
            Parser p(&buf, "test");

            TestSuite::clearCheckpoints();
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","fBNeBu̖{̂Ă΂Ă", TestSuite::isReached("Directives::body"));
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("onFail","onFail") {
        BEGIN_CASE("1","bodyŗONonFail̉s܂œǂݔ΂") {
            Singleton<Namespace>::renewInstance();
            stringstream buf;
            Directives_test api("pragma");
            buf.str("pragma parameter\nnext\n");
            Parser p(&buf, "test");

            api.throws = true;
            bool result = false;
            try { Directives::parseDirectives(p); }
            catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","ce", p.getToken() == "next");
            TEST_CASE("3","g[N͍s", p.isHeadofLine());
        } END_CASE;
    } END_CASE;
            
    Singleton<Namespace>::restoreContext(context);
}

#endif



