/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2002-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: singleton.cpp 1 2008-08-22 05:57:26Z koban $
 */

#include "base/singleton.h"
#include "base/testsuite.h"

using namespace std;

    //Singleton ÓIϐ
bool SingletonBase::initialize = false;     //ς݃tO
bool SingletonBase::is_valid   = true;      //CX^XtO

struct SingletonBase::chain * SingletonBase::top  = 0;  //fXgN^`F[̃gbv


/************************************* eXgXB[g *************************************/

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

    bool throw_DummyType;
    class DummyType {
    public:
        static int counter;
        int dummy_value;
        int order;
        SINGLETON_CONSTRUCTOR(DummyType) throw(bad_alloc) : dummy_value(0), order(++counter)
        {
            CHECKPOINT("DummyType::DummyType");
            if(throw_DummyType)
                throw bad_alloc();
        } 
        ~DummyType(void) throw(int)
        {
            CHECKPOINT("DummyType::~DummyType");
            if(throw_DummyType)
                throw 0;
            if(counter-- != order)
                CHECKPOINT("illegal order");
        }
    };

    SINGLETON_WRAPPER(DummyType2, DummyType)

    int DummyType::counter = 0;

    TESTSUITE(main, SingletonBase)
    {
        struct chain * old_top  = top;

        top  = 0;

        BEGIN_CASE("getInstance","getInstance") {
            BEGIN_CASE("1","P̃CX^X") {
                TestSuite::clearCheckpoints();
                DummyType * dummy = Singleton<DummyType>::getInstance();
                TEST_CASE("1","RXgN^NĂ", TestSuite::isReached("DummyType::DummyType"));

                TestSuite::clearCheckpoints();
                TEST_CASE("2","CX^X", Singleton<DummyType>::getInstance() == dummy);
                TEST_CASE("3","2ڈȍ~̓RXgN^NȂ", !TestSuite::isReached("DummyType::DummyType"));
                TEST_CASE("4","VOg̏IĂ", SingletonBase::initialize);
                TEST_CASE("5","fXgN^`F[\Ă", SingletonBase::top != 0);
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("final_release","final_release") {
            BEGIN_CASE("1","CX^X폜ł") {
                TEST_CASE("0","[O] 폜ׂvf", SingletonBase::top != 0);

                TestSuite::clearCheckpoints();
                SingletonBase::final_release();

                TEST_CASE("1","fXgN^NĂ", TestSuite::isReached("DummyType::~DummyType"));
                TEST_CASE("2","fXgN^`F[ȂȂĂ", SingletonBase::top == 0);
            } END_CASE;

            BEGIN_CASE("2","Ԃ") {
                DummyType::counter = 0;

                DummyType  * dummy  = Singleton<DummyType>::getInstance();
                DummyType2 * dummy2 = Singleton<DummyType2>::getInstance();

                TEST_CASE("0","[O] ", dummy->order == 1 && dummy2->order == 2);

                TestSuite::clearCheckpoints();
                SingletonBase::final_release();

                TEST_CASE("1","fXgN^NĂ", TestSuite::isReached("DummyType::~DummyType"));
                TEST_CASE("2","fXgN^`F[ȂȂĂ", SingletonBase::top == 0);
                TEST_CASE("3","j", !TestSuite::isReached("illegal order"));
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("getInstance","getInstance") {
            BEGIN_CASE("1","ɗO") {
                BEGIN_CASE("1","getInstance()") {
                    throw_DummyType = true;
                    bool result = false;
                    try { Singleton<DummyType>::getInstance(); }
                    catch(...) { result = true; }

                    TEST_CASE("1","O͋N",result);
                    TEST_CASE("2","fXgN^`F[ɂ͉ȂĂȂ", SingletonBase::top == 0);
                } END_CASE;

                SingletonBase::final_release();

                BEGIN_CASE("2","getInstance(nothrow)") {

                    DummyType * dummy;
                    throw_DummyType = true;
                    bool result = true;
                    try { dummy = Singleton<DummyType>::getInstance(nothrow); }
                    catch(...) { result = false; }

                    TEST_CASE("1","O͋NȂ",result);
                    TEST_CASE("2","NULLԂ", dummy == 0);
                    TEST_CASE("3","fXgN^`F[ɂ͉ȂĂȂ", SingletonBase::top == 0);
                } END_CASE;
            } END_CASE;
        } END_CASE;

        top  = old_top;
    }

#endif



