/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: testsuite.h 1 2008-08-22 05:57:26Z koban $
 */

/*
 *   eXgXB[gs⏕ NX/}NCu
 */


#ifdef TESTSUITE

    //ViII[}N(ExceptionNX̗LɂĒgւ̂łɂ)
#  undef END_CASE
#  ifdef EXCEPT_H
#    define END_CASE }catch(TestSuite::Fail & x) { _suite_control.fail_in_suite(x.getMessage()); } catch(Exception & exc) { _suite_control.fail_in_suite(string("sȗO : ") + exc.getDetails()); } catch(...) { _suite_control.fail_in_suite("eXgsɕsȗO󂯎ߒfꂽ"); } _suite_control.leave_case(); }
#  else
#    define END_CASE }catch(TestSuite::Fail & x) { _suite_control.fail_in_suite(x.getMessage()); } catch(...) { _suite_control.fail_in_suite("eXgsɕsȗO󂯎ߒfꂽ"); } _suite_control.leave_case(); }
#  endif

#endif


#ifndef TESTSUITE_H
#define TESTSUITE_H

    //eXgXB[g邩ǂ
//#define TESTSUITE


#if defined(TESTSUITE) //&& defined(_DEBUG)

    //Xg[̓eeXgŎĝœւ
#include <iostream>
#define cin  _cin
#define cout _cout
#define cerr _cerr

#include <sstream>

namespace std {
    extern stringstream _cin;
    extern stringstream _cout;
    extern stringstream _cerr;
}

#include <string>
#include <list>
#include <set>
#include <map>


    //W̃eXgXB[g֐̃vg^Cv錾p}N
#define TESTSUITE_PROTOTYPE(suite) \
    public: \
        static void test_suite_##suite(TestSuiteControl & _suite_control);


    //W̃eXgXB[g֐̒`p}N (킴ƃXB[gs̏RpCp̒`ƓOɂ)
#undef TESTSUITE
#define TESTSUITE(suite,cls) \
    TestSuite TestSuite_##cls##_##suite(#cls "(" #suite ")", cls::test_suite_##suite); \
    void cls::test_suite_##suite(TestSuiteControl & _suite_control)

#define TESTSUITE_(suite,cls,spr) \
    TestSuite TestSuite_##spr##_##cls##_##suite(#spr "::" #cls "(" #suite ")", spr::cls::test_suite_##suite); \
    void spr::cls::test_suite_##suite(TestSuiteControl & _suite_control)

    //dsh~p}N
#define PROCEED_ONCE static bool _proceed_once_flag_ = false; if(_proceed_once_flag_) return; else _proceed_once_flag_ = true;

    //ViIJn}N
#define BEGIN_CASE(x,y) if(_suite_control.enter_case(x,y,__FILE__,__LINE__)) { try {

    //ViIs}N
#define TEST_FAIL     throw TestSuite::Fail();
#define TEST_FAIL_(x) throw TestSuite::Fail(x);

    //ZViIp}N
#define TEST_CASE(x,y,z)   BEGIN_CASE(x,y) { if(!(z)) TEST_FAIL;    } END_CASE
#define TEST_CASE_(x,y,z,u) BEGIN_CASE(x,y) { if(!(z)) TEST_FAIL_(u); } END_CASE

    //B}N
#define CHECKPOINT(x) TestSuite::check(x);

    //VOgޔ
#define SINGLETON(x)    Singleton<x>::Context context;     Singleton<x>::saveContext(context);
#define SINGLETON_(x,y) Singleton<x>::Context context_##y; Singleton<x>::saveContext(context_##y);

/*
 *  eXgXB[g̎sNX
 */
class TestSuiteControl {
protected:
    std::list<std::string> session;         //݂̃ZbVX^bN

    std::string    target_session;          //ΏۃZbV
    std::string    current_session;         //݂̃XB[gViI
    std::string    current_description;     //݂̃XB[gViI̐
    std::ostream * out;                     //̏o͐
    bool           fail;                    //sViIǂ
    bool           verbose;                 //璷o͂邩ۂ

    unsigned int   case_count;              //P[X̑
    unsigned int   fail_count;              //sP[X̐

        //ViI̎擾
    std::string get_suitename(const char * name = "") const;


public:
        //RXgN^
    TestSuiteControl(std::ostream & _out, const char * _pattern = "");

        //eXgViI̕\ݒ (ԋpl : sKv邩ǂ)
    bool        _enter_case(const char * session, const char * description, const char * filename = "", long lineno = -1);
    inline void leave_case(void) { leave_session(); }

        //VOXebvsɒɔэ܂Ȃ߂̃bp
    inline bool enter_case(const char * session, const char * description, const char * filename = "", long lineno = -1)
    {   return _enter_case(session, description, filename, lineno);   }

        //eXgZbV (ViIvtBNX) ̐ݒ/
    void enter_session(const std::string & session);
    void leave_session(void);

        //eXgViI̎s
    void fail_in_suite(std::string msg="");                                           

        //sViI̗L̊mF
    inline bool is_failed(void) const
    {   return fail;   }

        //璷o͂̐ݒ
    inline void set_verbose(bool _verbose = true)
    {   verbose = _verbose;   }

        //seXgP[X̐
    inline unsigned int countCases(void) const
    {   return case_count;   }

        //seXgP[X̐
    inline unsigned int countFails(void) const
    {   return fail_count;   }
};

    //VOg̃eXgXB[ĝ߂ɂŃCN[h
#include "base/singleton.h"

/*
 *  eXgXB[gsNX
 */
class TestSuite {
public:
    class Fail  //eXgP[XsʒmɗpOpNX
    {
    protected:
        std::string msg;

    public:
            //RXgN^
        Fail(std::string src = "") throw() : msg(src) {}

            //Rs[RXgN^
        Fail(const Fail & src) throw() : msg(src.msg) {}
        
            //bZ[W擾
        inline const std::string & getMessage(void) const throw()
        {   return msg;   }
    };

    typedef void (*SuiteFunction)(TestSuiteControl &);

        /* NX̃eXgXB[gɊւێNX */
    class SuiteContainerNode
    {
    protected:
        std::string   session;
        SuiteFunction suite;
    
    public:
            //XB[gRXgN^
        SuiteContainerNode(const char * session, SuiteFunction suite);
        SuiteContainerNode(const SuiteContainerNode & src);

            //XB[g̎s
        bool invoke(TestSuiteControl & suite_control);

            //XB[g̎擾
        inline const std::string & getName(void) const throw()
        {   return session;   }
    };

        //sׂeXgXB[gCX^X̃Xǧ^
    class SuiteContainer : public std::list<SuiteContainerNode>
    {   public: SINGLETON_CONSTRUCTOR(SuiteContainer) {}   };

        /* sIvV */
    enum tagPerformOption {
        THROUGH = 1,    //ׂĒʂŎs (~߂Ȃ)
        VERBOSE = 2,    //璷o

        DEFAULT = THROUGH
    };

        /* `FbN|Cgi[NX */
    class Checkpoint : public std::set<std::string>
    { public: SINGLETON_CONSTRUCTOR(Checkpoint) throw() {} };

protected:
    bool            fail;       //ŌɎsXB[gsǂێϐ
    static bool     starvated;  //newɎs邩ǂ

public:
        //RXgN^
    TestSuite(const char * session, SuiteFunction suite);

        //fXgN^
    ~TestSuite(void);

        //eXgXB[g̎s  (ԋpl:XB[gsꂽǂ)
    static bool performTestSuite(int flags = THROUGH, const char * pattern = "");

        //eXgXB[g̎s (ϊ)
    inline static bool performTestSuite(const char * pattern)
    {   return performTestSuite(THROUGH, pattern);   }

        //o^ĂgbvxXB[g̈ꗗ\
    static void listTestSuite(void);

        /*
         *   `FbN|Cgp֐
         */

        //ʉ߂Ƃ
    inline static void check(std::string checkname)
    {   Singleton<Checkpoint>::getInstance()->insert(checkname);   }

        //܂łɎ󂯂񍐂폜
    inline static void clearCheckpoints(void)
    {   Singleton<Checkpoint>::getInstance()->clear();   }

        //̈ʒuɗ
    static bool isReached(std::string checkname);

        /*
         *   eXgpƊ֐
         */

        //t@C̒gJă`FbN
    static bool compareFileContents(const char * filename, const char * filecontents, bool remove = true);
};

/*
 *  XB[gspmain֐
 */
extern int main(int argc, char ** argv);

#define main pseudo_main    //ʏmain

    //ȈՃ\tgEFAg[X@\̃CN[h
#include "base/coverage_defs.h"

#else

/*********************************************************************************************/
/*
 *  eXgsȂƂ̃NX`
 */

#define TESTABLEOBJECT(x)
#define TESTABLEOBJECT_(x,y)
#define TESTSUITE_PROTOTYPE(x)
#define TESTSUITE_(x,y)
#define PROCEED_ONCE

#define BEGIN_CASE(x,y)
#define END_CASE
#define TEST_FAIL

#define CHECKPOINT(x)

/*
    *  eXgXB[gsNX
    */
class TestSuite {
public:
        //eXgXB[g̎s  (ԋpl:XB[g𐳂sǂ)
    inline static bool performTestSuite(void) { return true; };
};

#endif

#endif /* TESTSUITE_H */

