/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */


#include "base/defs.h"
#include "jsp/jsp_defs.h"
#include "base/message.h"
#include "base/component.h"
#include "base/filecontainer.h"

#include <fstream>
#include <iomanip>

class ConfigurationChecker : public Component
{
public:

    enum tagCheckLevel
    {
        UNKNOWN    = 0,
        LAZY       = 1,     /* vI (s߂h~p)  */
        STANDARD   = 2,     /* ITRONdl͈̔ (e) */
        TOPPERS    = 4,     /* TOPPERS/JSP͈͓̔          */
        RESTRICTED = 8,     /* Ђ[߂܂           */

        NORMAL     = 8
    };

protected:
    enum tagCheckLevel current_level;

    unsigned int error_count;
    std::string banner;

    void set_banner(Directory &, Formatter , const char *, int);
    void notify(enum tagCheckLevel, Formatter , bool = true);

    bool check_taskblock(Directory &, FileContainer *);
    bool check_semaphoreblock(Directory &, FileContainer *);
    bool check_eventflagblock(Directory &, FileContainer *);
    bool check_dataqueueblock(Directory &, FileContainer *);
    bool check_mailboxblock(Directory &, FileContainer *);
    bool check_fixed_memorypoolblock(Directory &, FileContainer *);
    bool check_cyclic_handlerblock(Directory &, FileContainer *);
    bool check_interrupt_handlerblock(Directory &, FileContainer *);
    bool check_exception_handlerblock(Directory &, FileContainer *);

    virtual void parseOption(Directory &);
    virtual void body(Directory &);

public:
    ConfigurationChecker(void) throw();
    ~ConfigurationChecker(void) throw() {}
};

//------------------------------------------------------
using namespace std;

static ConfigurationChecker  instance_of_ConfigurationChecker;

//------------------------------------------------------
    //^[Qbg̓̌^傫Ȍ^̒`
    // () lr, Z\Ȍ^ł邱

typedef          int  DT_INT;
typedef unsigned int  DT_UINT;
typedef unsigned long DT_FP;
typedef unsigned long DT_VP_INT;
typedef unsigned long DT_VP;
typedef          long DT_RELTIM;

//------------------------------------------------------

ConfigurationChecker::ConfigurationChecker(void) throw()
{
    setBanner("--- TOPPERS/JSP Configuration Checker (ver 2.4) ---");
}

void ConfigurationChecker::set_banner(Directory & container, Formatter object, const char * type, int id)
{
    Directory * node;
    char buffer[32];

    banner = string("    ") + object.str() + " : ";

    sprintf(buffer, "id = %d", id);

    node = container.findChild(OBJECTTREE, type, NULL)->getFirstChild();
    while(node != 0 && node->toInteger() != id)
        node = node->getNext();

    if( node != 0 ) {
        banner += node->getKey() + " (" + buffer + ") ";

        node = node->findChild("position");
        if(node != 0)
            banner += string("at ") + node->toString();
    }
    else
        banner += buffer;

    if(VerboseMessage::getVerbose())
    {
        cout << banner << endl;
        banner.erase();
    }
}

void ConfigurationChecker::notify(enum tagCheckLevel level, Formatter msg, bool error)
{
    if((level & current_level) != 0)
    {

        if(!banner.empty())
        {
            cout << banner << endl;
            banner.erase();
        }

        cout << "      ";

        if(error)
        {
            cout << Message("[ Error ] ","[G[] ");
            error_count ++;
        }else
            cout << Message("[Warning] ","[ x ] ");
        cout << msg << endl;
    }
}

    /*
     * ^XNIuWFNgɊւG[o
     */

bool ConfigurationChecker::check_taskblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int maxpri;
    unsigned int minpri;
    unsigned int old_error_count = error_count;

    TargetVariable<unsigned int> _kernel_tmax_tskid("_kernel_tmax_tskid");

    Message object("Task","^XN");

    if(!_kernel_tmax_tskid.isValid())
        ExceptionMessage(
            "Internal error: Unknown symbol (Probably, Symbol table was stripped)",
            "G[: sȃV{ (s`V{e[u܂łȂ\܂)").throwException();

    if(*_kernel_tmax_tskid < 1)
    {
        notify(RESTRICTED,
            Message("  [Task] : No tasks created\n","  [^XN] : ^XNIuWFNg܂\n"));
        return true;
    }

    TargetVariable<DT_UINT> tskatr("_kernel_tinib_table", "task_initialization_block::tskatr");
    TargetVariable<DT_FP>   task("_kernel_tinib_table", "task_initialization_block::task");
    TargetVariable<DT_INT>  ipriority("_kernel_tinib_table", "task_initialization_block::ipriority");
    TargetVariable<DT_UINT> texatr("_kernel_tinib_table", "task_initialization_block::texatr");
    TargetVariable<DT_UINT> stksz("_kernel_tinib_table", "task_initialization_block::stksz");

    maxpri = container->getVariableInfo("TMAX_TPRI").value;
    minpri = container->getVariableInfo("TMIN_TPRI").value;

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tmax_tskid;
    for(id = 1; id <= *_kernel_tmax_tskid; id++)
    {
        set_banner(parameter, object, TASK, id);

            /*
             *  `FbN
             */

            // l TA_HLNG|TA_ASM|TA_ACT ȊO̒lƂĂ
        if((*tskatr & ~0x3) != 0)
            notify( STANDARD,
                Message("Illegal task attribute (It should be ((TA_HLNG||TA_ASM)|TA_ACT))",
                        "sȃ^XN ((TA_HLNG||TA_ASM)|TA_ACT)ȊO"));

            // l TA_ASM ܂܂Ă
        if((*tskatr & 0x1) != 0)
            notify( RESTRICTED,
                Message("TA_ASM specified as task attribute takes no effect.",
                        "^XNTA_ASMw肳Ă"));

            /* NԒn0 */
        if(*task == 0)
            notify(RESTRICTED,
                Message("The address of task routine is equal to zero.",
                        "JnԒn0ݒ肳Ă܂"));

            /*
             *  Dx`FbN
             */

            // őDxƍŏDx̐ݒ肪
        if(maxpri < minpri)
            notify(LAZY,
                Message("Illegal Priority Settings found (TMAX_TPRI(%) < TMIN_TPRI).",
                        "DxŒDx(%)𒴂Ă") << minpri);

            // Dx͈̔͂[ŏDx, őDx]͈̔͂𒴂Ă
        if(*ipriority > (signed)(maxpri - minpri))
            notify(TOPPERS,
                Message("Initial priority is greater than maximum priority (%).",
                        "DxőDx(%)𒴂Ă") << maxpri);
        if(*ipriority < 0)
            notify(STANDARD,
                Message("Initial priority is less than the minimum priority (%).",
                        "DxŒDx(%)") << minpri);

            /*
             *   ^XNO`FbN
             */

            // lTA_HLNG or TA_ASMłȂ
        if((*texatr & ~0x3) != 0)
            notify(STANDARD,
                Message("Task exception routine has an illegal attribute specifier.",
                        "^XNOɖȑ(TA_HLNG,TA_ASMȊO) ݒ肳Ă܂"));

            // l TA_ASM ܂܂Ă
        if((*texatr & 0x1) != 0)
            notify( RESTRICTED,
                Message("TA_ASM, specified as texatr, does not always take effect.",
                        "^XNOTA_ASMw肳Ă܂"));

            /*
             *   X^bN`FbN
             */

            // X^bNTCY0
        if(*stksz == 0)
            notify(RESTRICTED,
                Message("Stack size is equal to zero.",
                        "X^bNTCY0ݒ肳Ă܂"));

            // X^bN̔Ԓn0
        if(*stksz == 0)
            notify(RESTRICTED,
                Message("The address of task stack is equal to zero.",
                        "X^bNJnԒn0ݒ肳Ă܂"));

        ++ tskatr, ++ task, ++ ipriority, ++ texatr, ++ stksz;
    }

    return old_error_count == error_count;
}

bool ConfigurationChecker::check_semaphoreblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Semaphore","Z}tH");

    TargetVariable<DT_UINT> _kernel_tmax_semid("_kernel_tmax_semid");
    if(*_kernel_tmax_semid < 1)
        return true;

    TargetVariable<DT_UINT> sematr("_kernel_seminib_table","semaphore_initialization_block::sematr");
    TargetVariable<DT_UINT> maxsem("_kernel_seminib_table","semaphore_initialization_block::maxsem");
    TargetVariable<DT_UINT> isemcnt("_kernel_seminib_table","semaphore_initialization_block::isemcnt");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n")
        << object << *_kernel_tmax_semid;

    for(id = 1; id <= *_kernel_tmax_semid; id++)
    {
        set_banner(parameter, object, SEMAPHORE, id);

            //attribute validation check
        if((*sematr & ~0x1) != 0)
            notify(STANDARD,
                Message("Illegal attribute (It should be (TA_TFIFO||TA_TPRI)).",
                        "(TA_TFIFO||TA_TPRI)ȊȎw肳Ă"));

            //maxcnt < isemcnt
        if(*maxsem < *isemcnt)
            notify(STANDARD,
                Message("Initial count[%] is greater than the maximum count[%] of this semaphore",
                        "l[%]ől[%]𒴂Ă") << *isemcnt << *maxsem);

        if(*maxsem == 0)
            notify(STANDARD,
                Message("Maximum count must be greater than zero.",
                        "Z}tH̍őJEg1ȏłȂ΂܂"));

        ++ sematr, ++ maxsem, ++ isemcnt;
    }

    return old_error_count == error_count;
}


bool ConfigurationChecker::check_eventflagblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Event flag","CxgtO");

    TargetVariable<DT_UINT> _kernel_tmax_flgid("_kernel_tmax_flgid");
    if(*_kernel_tmax_flgid < 1)
        return true;

    TargetVariable<DT_UINT> flgatr("_kernel_flginib_table","eventflag_initialization_block::flgatr");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n")
         << object << *_kernel_tmax_flgid;

    for(id = 1; id <= *_kernel_tmax_flgid; id++)
    {
        set_banner(parameter, object, EVENTFLAG, id);
            
            //attribute validation check
        if((*flgatr & ~0x7) != 0)
            notify(STANDARD,
                Message("Illegal attribute value [0x%]",
                        "ȑl [0x%]") << setbase(16) << (*flgatr & ~0x7));

        if((*flgatr & 0x2) != 0)
            notify(TOPPERS,     //ˑŒȂ̂RESTRICTEDɂȂ
                Message("Attribute TA_WMUL is not supported in current version.",
                        "TA_WMUL̓T|[gO"));
    
        ++ flgatr;
    }

    return old_error_count == error_count;
}


bool ConfigurationChecker::check_dataqueueblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Data queue","f[^L[");

    TargetVariable<DT_UINT> _kernel_tmax_dtqid("_kernel_tmax_dtqid");
    if(*_kernel_tmax_dtqid < 1)
        return true;

    TargetVariable<DT_UINT> dtqatr("_kernel_dtqinib_table", "dataqueue_initialization_block::dtqatr");
    TargetVariable<DT_UINT> dtqcnt("_kernel_dtqinib_table", "dataqueue_initialization_block::dtqcnt");
    TargetVariable<DT_VP_INT> dtq("_kernel_dtqinib_table", "dataqueue_initialization_block::dtq");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n")
        << object << *_kernel_tmax_dtqid;

    for(id = 1; id <= *_kernel_tmax_dtqid; id++)
    {
        set_banner(parameter, object, DATAQUEUE, id);

            //attribute validation check
        if((*dtqatr & ~0x1) != 0)
            notify(STANDARD,
                Message("Illegal attribute value [0x%]",
                        "ȑl [0x%]") << setbase(16) << (*dtqatr & ~0x1));

        if(*dtqcnt != 0 && *dtq == 0)
            notify(TOPPERS,
                Message("Dataqueue buffer should not be NULL", "f[^L[̃obt@NULLl"));

        ++ dtqatr, ++ dtqcnt, ++ dtq;
    }

    return old_error_count == error_count;
}


bool ConfigurationChecker::check_mailboxblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Mailbox","[{bNX");

    TargetVariable<DT_UINT> _kernel_tmax_mbxid("_kernel_tmax_mbxid");
    if(*_kernel_tmax_mbxid < 1)
        return true;
    
    TargetVariable<DT_UINT> mbxatr("_kernel_mbxinib_table","mailbox_initialization_block::mbxatr");
    TargetVariable<DT_INT>  maxmpri("_kernel_mbxinib_table","mailbox_initialization_block::maxmpri");

    DT_INT maxpri = container->getVariableInfo("TMAX_MPRI").value;
    DT_INT minpri = container->getVariableInfo("TMIN_MPRI").value;

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tmax_mbxid;
    for(id = 1; id <= *_kernel_tmax_mbxid; id++)
    {
        set_banner(parameter, object, MAILBOX, id);

            //attribute validation check
        if((*mbxatr & ~0x3) != 0)
            notify(STANDARD,
                Message("Illegal attribute value [0x%]",
                        "ȑl [0x%]") << setbase(16) << (*mbxatr & ~0x3));
    
            //mailbox message priority check
        if(*maxmpri < 0)
            notify(STANDARD,
                Message("Priority must not be a negative number.","Dxl"));

        if(*maxmpri < minpri)
            notify(STANDARD,
                Message("Message priority should be greater than or equal to %.",
                        "bZ[WDx%ȏłȂ΂܂") << minpri);

        if(*maxmpri > maxpri)
            notify(STANDARD,
                Message("Message priority should be less than or equal to %.",
                        "bZ[WDx%ȉłȂ΂܂") << maxpri);

        ++ mbxatr, ++ maxmpri;
    }

    return old_error_count == error_count;
}

bool ConfigurationChecker::check_fixed_memorypoolblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Fixed size memory pool","Œ蒷v[");

    TargetVariable<DT_UINT> _kernel_tmax_mpfid("_kernel_tmax_mpfid");
    if(*_kernel_tmax_mpfid < 1)
        return true;

    TargetVariable<DT_UINT> mpfatr("_kernel_mpfinib_table", "fixed_memorypool_initialization_block::mpfatr");
    TargetVariable<DT_UINT> limit ("_kernel_mpfinib_table", "fixed_memorypool_initialization_block::limit");
    TargetVariable<DT_VP>   mpf   ("_kernel_mpfinib_table", "fixed_memorypool_initialization_block::mpf");
    TargetVariable<DT_UINT> blksz ("_kernel_mpfinib_table", "fixed_memorypool_initialization_block::blksz");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tmax_mpfid;
    for(id = 1; id <= *_kernel_tmax_mpfid; id++)
    {
        set_banner(parameter, object, FIXEDSIZEMEMORYPOOL, id);

            //attribute validation check
        if((*mpfatr & ~0x1) != 0)
            notify(STANDARD,
                Message("Illegal attribute value [0x%]","ȑl [0x%]") << (*mpfatr & ~0x1));

            //ubN0
        if(*mpf == *limit)
            notify(STANDARD,
                Message("blkcnt should be a non-zero value.","ubN0ł"));

            //ubNTCY0
        if(*blksz == 0)
            notify(STANDARD,
                Message("blksz should be a non-zero value.","ubNTCY0ł"));

            //obt@AhX0
        if(*mpf == 0)
            notify(TOPPERS,
                Message("buffer address is a NULL pointer.","obt@AhXNULL|C^ɂȂĂ܂"));

        ++ mpfatr, ++ limit, ++ mpf, ++ blksz;
    }

    return old_error_count == error_count;
}


bool ConfigurationChecker::check_cyclic_handlerblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Cyclic handler","nh");

    TargetVariable<DT_UINT> _kernel_tmax_cycid("_kernel_tmax_cycid");
    if(*_kernel_tmax_cycid < 1)
        return true;

    DT_RELTIM maxreltim = container->getVariableInfo("TMAX_RELTIM").value;
    TargetVariable<DT_UINT> cycatr("_kernel_cycinib_table", "cyclic_handler_initialization_block::cycatr");
    TargetVariable<DT_RELTIM> cyctim("_kernel_cycinib_table", "cyclic_handler_initialization_block::cyctim");
    TargetVariable<DT_RELTIM> cycphs("_kernel_cycinib_table", "cyclic_handler_initialization_block::cycphs");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tmax_cycid;
    for(id = 1; id <= *_kernel_tmax_cycid; id++)
    {
        set_banner(parameter, object, CYCLICHANDLER, id);

            //attribute validation check
        if((*cycatr & ~0x7) != 0)
            notify(STANDARD,
                Message("Illegal attribute value [0x%]","ȑl [0x%]") << (*cycatr & ~0x1));

        if((*cycatr & 0x4) != 0)
            notify(TOPPERS,     //ˑȂ̂RESTRICTEDɂȂ
                Message("TA_PHS is not supported in this kernel.","TA_PHS̓T|[gO"));

            // l TA_ASM ܂܂Ă
        if((*cycatr & 0x1) != 0)
            notify( RESTRICTED,
                Message("TOPPERS/JSP Kernel never minds the flag 'TA_ASM'.",
                        "TOPPERS/JSPJ[l̑SĂ̋@ˑTA_ASMT|[gƂ͌Ȃ"));

            //RELTIMł̕\͈͓ɂ邩ǂ̃`FbN
        if(*cyctim > maxreltim)
            notify(STANDARD,
                Message("The cyclic object has a period (%) that exceeds the maximum period (%)",
                        "N(%)\\ȑΎԂ͈̔(%)𒴂Ă܂") << *cyctim << maxreltim);

            //N0łȂƂ̃`FbN
        if(*cyctim == 0)
            notify(STANDARD,
                Message("The cyclic object has a ZERO period.",
                        "N0ɂȂĂ܂"));

        if(*cycphs > maxreltim)
            notify(STANDARD,
                Message("The cyclic object has a initial delay (%) that exceeds the maximum period (%)",
                        "Nʑ(%)\\ȑΎԂ͈̔(%)𒴂Ă܂") << *cycphs << maxreltim);

        ++ cycatr, ++ cyctim, ++ cycphs;
    }

    return old_error_count == error_count;
}

bool ConfigurationChecker::check_interrupt_handlerblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Interrupt handler","݃nh");

    TargetVariable<DT_UINT> _kernel_tnum_inhno("_kernel_tnum_inhno");
    if(*_kernel_tnum_inhno == 0)
        return true;

    TargetVariable<DT_UINT> inhatr("_kernel_inhinib_table", "interrupt_handler_initialization_block::inhatr");
    TargetVariable<DT_FP>   inthdr("_kernel_inhinib_table", "interrupt_handler_initialization_block::inthdr");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tnum_inhno;
    for(id = 0; id < *_kernel_tnum_inhno; id++)
    {
        set_banner(parameter, object, INTERRUPTHANDLER, id);

            //attribute validation check
        if((*inhatr & 0x1) != 0)
            notify(STANDARD,
                Message("The attribute can take only TA_HLNG|TA_ASM",
                        "TA_HNLG|TA_ASMȊȎ͐ݒł܂"));

            // l TA_ASM ܂܂Ă
        if((*inhatr & 0x1) != 0)
            notify(RESTRICTED,
                Message("TOPPERS/JSP Kernel never minds the flag 'TA_ASM'.",
                        "TA_ASMgpĂ"));

            // NԒn`FbN
        if(*inthdr == 0)
            notify(RESTRICTED,
                Message("NULL pointer is specified as an inthdr address.",
                        "݃nh̔ԒnNULLł"));

        ++ inhatr, ++ inthdr;
    }

    return old_error_count == error_count;
}

bool ConfigurationChecker::check_exception_handlerblock(Directory & parameter, FileContainer * container)
{
    unsigned int id;
    unsigned int old_error_count = error_count;

    Message object("Exception handler","Onh");

    TargetVariable<DT_UINT> _kernel_tnum_excno("_kernel_tnum_excno");
    if(*_kernel_tnum_excno == 0)
        return true;

    TargetVariable<DT_UINT> excatr("_kernel_excinib_table", "cpu_exception_handler_initialization_block::excatr");
    TargetVariable<DT_FP>   exchdr("_kernel_excinib_table", "cpu_exception_handler_initialization_block::exchdr");

    VerboseMessage("% object : % items\n","%IuWFNg : % \n") << object << *_kernel_tnum_excno;
    for(id = 0; id < *_kernel_tnum_excno; id++)
    {
        set_banner(parameter, object, EXCEPTIONHANDLER, id);

            //attribute validation check
        if((*excatr & 0x1) != 0)
            notify(STANDARD,
                Message("The attribute can take only TA_HLNG|TA_ASM",
                        "TA_HNLG|TA_ASMȊȎ͐ݒł܂"));

            // l TA_ASM ܂܂Ă
        if((*excatr & 0x1) != 0)
            notify(RESTRICTED,
                Message("TOPPERS/JSP Kernel never minds the flag 'TA_ASM'.",
                        "TOPPERS/JSPJ[l̑SĂ̋@ˑTA_ASMT|[gƂ͌Ȃ"));

            // NԒn`FbN
        if(*exchdr == 0)
            notify(RESTRICTED,
                Message("NULL pointer is specified as an exchdr address.",
                        "Onh̔ԒnNULLł"));

        ++ excatr, ++ exchdr;
    }

    return old_error_count == error_count;
}

//------------------------------------------------------

void ConfigurationChecker::parseOption(Directory & parameter)
{
    string loadmodule;
    string work;

    if(findOption("h","help"))
    {
        cout << endl << Message(
            "Configuration checker - option\n"
            "  -m, --module=filename : Specify the load module (essential option)\n"
            "  -cs, --script=filename  : Specify the checker script file\n"
            "  -cl, --checklevel=level : Specify one of the check levels below \n"
            "    l(azy)       : Minimum check will be performed.\n"
            "    s(tandard)   : includes some ITRON Standard check items.\n"
            "    t(oppers)    : checks whether it meets TOPPERS/JSP restrictions\n"
            "    r(estricted) : All of check items will be performed.\n",
            "RtBM[V`FbJ - IvV\n"
            "  -m, --module=t@C : [hW[w肵܂ (K{)\n"
            "  -cs, --script=t@C  : `FbJXNvgw肵܂\n"
            "  -cl, --checklevel=level : Specify one of the check levels below \n"
            "    l(azy)       : ŏ̃`FbN݂̂s܂\n"
            "    s(tandard)   : ITRONdl͈̔͂Ń`FbNs܂\n"
            "    t(oppers)    : TOPPERS/JSPJ[l̐𖞂ƂmF܂\n"
            "    r(estricted) : @ˑ܂ߑSẴ`FbNڂ{܂\n");
        cout << endl 
             << Message("Supported architecture : ", "ΉA[LeN` : ")
             << FileContainer::getInstance()->getArchitecture()
             << endl;
        return;
    }

    if(findOption("m","module",&loadmodule) || findOption(DEFAULT_PARAMETER,NULL,&loadmodule))
    {
        if(findOption("s","source"))
            ExceptionMessage("Configuration checker can not execute while Configurator executes","RtBM[^ƃ`FbJ͓ɋNł܂").throwException();

        parameter["/file/loadmodule"] = loadmodule;
        activateComponent();
    }

    if(!findOption("cs","script",&work))
        work = loadmodule.substr(0,loadmodule.find_last_of('.')) + ".chk";
    parameter["/file/checkerscript"] = work;

    work.erase();
    if(findOption("obj","load-object",&work))
    {
        if(work.empty())
            work.assign("kernel_obj.dat");

        fstream f(work.c_str(), ios::in|ios::binary);
        if(f.is_open())
        {
            parameter["/object"].Load(&f);
            f.close();
        }else
            ExceptionMessage(" Failed to open the file '%' for storing object definitions"," IuWFNgi[邽߂̃t@C(%)J܂") << work << throwException;
    }

    if(findOption("cl","checklevel",&work))
    {
        current_level = UNKNOWN;

        if(work.compare("lazy") == 0 || work[0] == 'l')
            current_level = LAZY;
        if(work.compare("standard") == 0 || work[0] == 's')
            current_level = STANDARD;
        if(work.compare("toppers") == 0 || work[0] == 't')
            current_level = TOPPERS;
        if(work.compare("restricted") == 0 || work[0] == 'r')
            current_level = RESTRICTED;

        if(current_level == UNKNOWN)
            ExceptionMessage(" Unknown check level [%] specified"," ȃ`FbNxw [%]") << work << throwException;
    }else
        current_level = NORMAL;

    checkOption("cpu", "cpu");
    checkOption("system", "system");
}

void ConfigurationChecker::body(Directory & parameter)
{
    FileContainer * container;
    bool result = true;

        /* Dx̍G[Ώۂ */
    current_level = static_cast<enum tagCheckLevel>(static_cast<int>(current_level) * 2 - 1);

    container = FileContainer::getInstance();
    container->attachInfo(parameter["/file/checkerscript"].toString());
    container->attachModule(parameter["/file/loadmodule"].toString());

    if(VerboseMessage::getVerbose())
    {
        cout << Message("  Target architecture : ","  ^[QbgA[LeN` : ")
             << container->getArchitecture() << endl;
    }

    error_count = 0;
    result &= check_taskblock(parameter,container);
    result &= check_semaphoreblock(parameter,container);
    result &= check_eventflagblock(parameter,container);
    result &= check_dataqueueblock(parameter,container);
    result &= check_mailboxblock(parameter,container);
    result &= check_fixed_memorypoolblock(parameter,container);
    result &= check_cyclic_handlerblock(parameter,container);
    result &= check_interrupt_handlerblock(parameter,container);
    result &= check_exception_handlerblock(parameter,container);

    if(!result)
        ExceptionMessage("Total % errors found in current configuration.\n","S%̃G[o܂\n") << error_count << throwException;

    VerboseMessage("No error found in current configuration\n","\Ɉُ͂܂ł\n");
}

