/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: coverage_defs.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
    #ifdef֌W
    coverage_defśAundefsŉƂɓǂݍޏꍇ̂ŁA
        p[gɕĂ.
        - COVERAGE      : JobW@\gp邩ǂ
        - COVERAGE_H    : coverage.cppɊ֘A镔ŁAd`Ă͍
        - COVERAGE_DEFS : JobWɊ֘A镔ŁAcoverage_undefs.hundefłAxcoverage_defs.hǂłvȂ
*/


#ifdef COVERAGE

#include "base/singleton.h"

    /* wb_ */
#include <string>
#include <map>
#include <set>
#include <iostream>


#ifndef COVERAGE_H
#define COVERAGE_H
/*
 *   ȒPȃJobW`FbN
 */

class Coverage {
public:
        /* ꏊێNX */
    class Location {
    protected:
        const char *  filename;
        unsigned int  lineno;
        const char *  additional;

    public:
        Location(const char * _filename, unsigned int _lineno, const char * _additional = "") : filename(_filename), lineno(_lineno), additional(_additional) {}
        Location(const Location & src) : filename(src.filename), lineno(src.lineno), additional(src.additional) {}

        inline Location & operator = (const Location & right)
        {
            filename   = right.filename;
            lineno     = right.lineno;
            additional = right.additional;

            return *this;
        }

        inline bool operator == (const Location & right) const
        {   return lineno == right.lineno && std::string(filename).compare(right.filename) == 0 && std::string(additional).compare(right.additional) == 0;   }

        inline bool operator < (const Location & right) const
        {
            if(lineno < right.lineno)
                return true;
            if(std::string(filename).compare(right.filename) < 0)
                return true;

            return false;
        }

        inline std::string getFilename(void) const
        {   return std::string(filename);   }

        inline unsigned int getLineno(void) const
        {   return lineno;   }

        inline std::string getAdditional(void) const
        {   return std::string(additional);   }

            //tH[}bgς݃t@Cʒu̎擾 filename:lineno(additional)
        std::string getDetails(void) const;
    };

        //JobW̃x[XNX
    class BranchBase {
    protected:
        BranchBase(const Location & location) throw();   //vf̓o^
        static BranchBase * find(const Location & location) throw();     //locationɈvvf̎擾

    public:
        virtual ~BranchBase(void) throw() {}                        //fXgN^
        virtual bool checkValidity(void) const throw(...) = 0;      //
        virtual std::string getDetails(void) const throw(...) = 0;  //f[^\
    };

        //if-statementɈNX
    class If : public BranchBase {
    protected:
        bool true_case;
        bool false_case;

        If(const Location & location) throw(); //branchoRŖƐȂ

    public:
        virtual bool checkValidity(void) const throw();         //̔
        virtual std::string getDetails(void) const throw();     //f[^\

        static bool branch(const Location & location, bool expression) throw();
    };
    
        //while-statementɈNX
    class While : public BranchBase {
    protected:
        bool valid;

        While(const Location & location) throw();
    public:
        virtual bool checkValidity(void) const throw();         //̔
        virtual std::string getDetails(void) const throw();     //f[^\

        static bool branch(const Location & location, bool expression) throw();
    };

        //switch-statementɈNX
    class Switch : public BranchBase {
    protected:
        std::set<int> checkpoint;

        Switch(const Location & location) throw();
        static void _branch(const Location & location, int expression) throw();

    public:
        virtual bool checkValidity(void) const throw();         //̔
        virtual std::string getDetails(void) const throw();     //f[^\

        template<class T>
        static T branch(const Location & location, T expression) throw()
        {
            _branch(location, (int)expression);
            return expression;
        }
    };


protected:
    class BranchMap : public std::map<Location, BranchBase *> {
    public:
        SINGLETON_CONSTRUCTOR(BranchMap) {}
        ~BranchMap(void) throw();
    
    };
    class NewBranchList : public std::list<BranchBase *>
    {   public: SINGLETON_CONSTRUCTOR(NewBranchList) {}   };

        //ڂ̕\
    static std::string getBranchName(BranchBase * node);

public:
        //SĒʉ߂ǂ̃`FbN
    static bool checkValidity(void);

        //SĂ̍ڂ\
    static void printCoverage(std::ostream & out);

};

#endif /* COVERAGE_H */


#ifndef COVERAGE_DEFS
#define COVERAGE_DEFS

#define if(x)    i##f(Coverage::If::branch(Coverage::Location(__FILE__, __LINE__, "if"), (x) ? true : false))
#define while(x) w##hile(Coverage::While::branch(Coverage::Location(__FILE__, __LINE__, "while"), (x) ? true : false))
#define switch(x) s##witch(Coverage::Switch::branch(Coverage::Location(__FILE__, __LINE__, "switch"), (x)))

#endif  /* COVERAGE_DEFS */

#else

#include <iostream>

#ifndef COVERAGE_H
#define COVERAGE_H
class Coverage {
public:
    static bool checkValidity(void) { return true; }
    static void printCoverage(std::ostream &) {}
};
#endif /* COVERAGE_H */

#endif

