/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef EVENT_H
#define EVENT_H

#include "base/testsuite.h"
#include "base/singleton.h"

#include <list>

    //CxgtbN̎܂Ƃߖ
template<typename T>
class Event
{
public:
    typedef void (*handler_type)(T &);

    class handler_list_type : public std::list<handler_type>
    {   public: SINGLETON_CONSTRUCTOR(handler_list_type) throw() {}   };

    /*
     *   NX̒̃nhp
     */

    class Handler
    {
    friend class Event;
    public:
        class instance_list_type : public std::list<Handler *>
        {   public: SINGLETON_CONSTRUCTOR(instance_list_type) throw() {}   };

        virtual void handler(T & ev) = 0;

    protected:
            //o^
        Handler(void) throw()
        {   Singleton<instance_list_type>::getInstance()->push_back(this);   }
        
            //o^
        virtual ~Handler(void) throw()
        {
            typename Event<T>::Handler::instance_list_type * list = Singleton<instance_list_type>::getInstance(std::nothrow);
            typename Event<T>::Handler::instance_list_type::iterator scope;

            if(list != 0) {
                scope = list->begin();
                while(scope != list->end()) {
                    if(*scope == this) {
                        typename Event<T>::Handler::instance_list_type::iterator target = scope;
                        ++ scope;
                        list->erase(target);
                    }
                    else
                        ++ scope;
                }
            }
        }
    };

public:
    typedef T value_type;

    Event(void) {}
    virtual ~Event(void) {}

    /*
     *  X^eBbNȃnhp
     */

        //CxgɃnhǉ
    inline static void add(handler_type func) throw(std::bad_alloc)
    {   Singleton<handler_list_type>::getInstance()->push_back(func);   }

        //Cxgnh폜
    static void remove(handler_type func) throw()
    {
        typename Event<T>::handler_list_type * list;
        typename Event<T>::handler_list_type::iterator scope;

        list = Singleton<handler_list_type>::getInstance(std::nothrow);
        if(list != 0) {
            scope = list->begin();
            while(scope != list->end()) {
                if(*scope == func) {
                    typename handler_list_type::iterator target = scope;
                    ++ scope;
                    list->erase(target);
                }
                else
                    ++ scope;
            }
        }
    }

    /*
     *  ʑ
     */
        //Cxg̔
    static void raise(T & ev)
    {
            typedef typename Event<T>::handler_list_type handler_list_type_t; 
            typedef typename Event<T>::Handler::instance_list_type instance_list_type_t;

        /* o^ꂽÓIȊ֐ɃCxg𔭍s */ {
           handler_list_type_t * list;
            typename handler_list_type_t::iterator scope;

            list = Singleton<handler_list_type_t>::getInstance();   //throw(bad_cast)

            scope = list->begin();
            while(scope != list->end()) {
                (**scope)(ev);
                ++ scope;
            }
        }

        /* o^ꂽNXCX^XɃCxg𔭍s */ {
            instance_list_type_t * list;
            typename instance_list_type_t::iterator scope;

            list = Singleton<instance_list_type_t>::getInstance();  //throw(bad_cast)

            scope = list->begin();
            while(scope != list->end()) {
                (*scope)->handler(ev);
                ++ scope;
            }
        }
    }

        //Cxg̔ (Ȃ)
    inline static void raise(void)
    {
        T ev;
        raise(ev);
    }
};


    /*
     *  ėpCxg
     */

    //RXgN^NIƁA^ɋNCxg
class StartupEvent {};


    //s킸AvOIƂɋNCxg
struct ShutdownEvent
{
    int exit_code;
};

#endif



