/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: except.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/except.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef EXCEPT_H
#define EXCEPT_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B
#endif

//#include "testsuite.h"

#include <string>
#include <typeinfo>

    //ONX
class Exception
{
private:
    static bool is_throwable;

protected:
    int         code;       //OR[h
    std::string classname;  //̗O𐶐NX̖O (ʗp)
    std::string details;    //O̐

        //RXgN^
    Exception(std::string classname = "Exception", int code = 0, std::string details = "") throw();
    Exception(std::string classname, std::string details) throw();

        //fXgN^
public:
    Exception(const Exception & src) throw();

    virtual ~Exception(void) throw();

        //is-an-instance-of֌W̕]
    inline bool isInstanceOf(const char * _classname) const throw()
    {   return classname.compare(_classname) == 0;   }

        //OR[h擾
    inline int getCode(void) const throw()
    {   return code;   }

        //O̐擾
    inline std::string getDetails(void) const throw()
    {   return details;   }

        //݂̗OtȌԂɏ]ėO𔭍s
    inline bool throwException(void)
    {
        if(is_throwable)
            throw *this;
        return is_throwable;
    }

        //is_throwablẽANZT
    static void setThrowControl(bool _throwable) throw()
    {   is_throwable = _throwable;   }

    static bool getThrowControl(void) throw()
    {   return is_throwable;   }


//  TESTSUITE_PROTOTYPE(main)
};


#define EXCEPTION(x)       class x : public Exception { public: x(void) throw() : Exception(#x)       {} };
#define EXCEPTION_(x,y)    class x : public Exception { public: x(void) throw() : Exception(#x, y)    {} };
#define EXCEPTION__(x,y,z) class x : public Exception { public: x(void) throw() : Exception(#x, y, z) {} };

#endif



