/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: garbage.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/garbage.h,v 1.1 2009/01/31 05:27:37 suikan Exp $


#ifndef GARBAGE_H
#define GARBAGE_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B
#  pragma warning(disable:4786) //fobOŎʎq255ɐ؂̂Ă܂B
#endif

#include "base/testsuite.h"
#include <list>


    //IɐIuWFNgƔj邽߂̃S~[`
class TrashBox
{
public:
    typedef std::list<class Garbage *>::iterator Cookie;

protected:
    static TrashBox *    current_box;   //ݎgpĂS~
    TrashBox *           previous_box;  //̃S~̐e
    
    std::list<class Garbage *> garbage; //

public:
        //q  Ŏq
    TrashBox(void)  throw();
    ~TrashBox(void) throw();

    inline bool isValid(void) const throw()
    {   return (this != 0);   }

        //S~ɓĂS~j
    void cleanup(void);

        //gĂS~擾
    inline static TrashBox * getCurrentTrashBox(void) throw()
    {   return current_box;   }

        //S~
    inline Cookie addGarbage(class Garbage * _garbage) throw()
    {   return garbage.insert(garbage.begin(), _garbage);   }

        //S~
    void recoverGarbage(Cookie cookie) throw();


        //IɊmۂȂ
    void * operator new (size_t) throw(std::bad_alloc)
    {   throw std::bad_alloc();   }
    void * operator new (size_t, std::nothrow_t) throw()
    {   return 0;   }

    TESTSUITE_PROTOTYPE(main)
};


    //S~ɓS~IuWFNg̊
class Garbage
{
private:
    class TrashBox *  assigned_box;
    TrashBox::Cookie  cookie;

public:
        //q  Ŏq
    Garbage(void)  throw();
    virtual ~Garbage(void) throw();

        //S~Eグ
    void rescue(void) throw();
};


#endif


