/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  VAI/OfoCXiSIOjhCoiBlackfin UARTpj
 *
 *   ̃t@ĆATOPPERS/JSP 1.4.2 config/sh3/ms7727cp01/hw_serial.h
 *   l[A̎ʎqύX̂łB
 *
 *   ̃t@C͉ʂ̃foCXEANZXE[`𑩂˂ďʂ̑wɓn
 *   ߂̂̂łBBlackfin̊OɂVATOPPERS/JSPŊǗȂ
 *   ̂ȂAύXKv͂ȂB
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#include "uart.h"



/*
 *  SIOhCȍ[`
 */
#define sio_initialize  uart_initialize

#ifndef _MACRO_ONLY
/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;

    /*
     *  foCXˑ̃I[vD
     */
    siopcb = uart_opn_por(siopid, exinf);

	/*
	* Enable Corrensponding Interrupt at IMASK
	* Note that, this implementation has only 1 SIO in a system
	*/
	ena_int( INTNO_UART_TX );
	ena_int( INTNO_UART_RX );

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{

	/*
	 * łSIC_IMASK̑ΉrbgNAȂBSIC_IMASK̃NA
	 * 댯łBUART̊荞݂ uart_cls_porŋ֎~̂
	 * [łB
	 */

    /*
     *  foCXˑ̃N[YD
     */
    uart_cls_por(siopcb);
}


/*
 *  SIO̊݃nh
 */
#define sio0_rx_handler uart0_rx_isr
#define sio0_tx_handler uart0_tx_isr

/*
 *  VAI/O|[gւ̕M
 */
#define sio_snd_chr uart_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define sio_ierdy_rcv   uart_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
