/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: dve68k.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	DVE68K/40 CPU{[h̃n[hEFA̒`
 */

#ifndef _DVE68K_H_
#define _DVE68K_H_

/*
 *  ݃xNg̒`
 */
#define	TVEC_G0I	0x40u		/* O[v0 ݃xNg */
#define TVEC_SQR	0x42u		/* SQR ݃xNg */
#define TVEC_ABT	0x46u		/* A{[g݃xNg */

#define	TVEC_G1I	0x48u		/* O[v1 ݃xNg */
#define	TVEC_GP0	0x48u		/* VAI/O ݃xNg */
#define	TVEC_TT0	0x4cu		/* ^C}0 ݃xNg */

#define	TVEC_SWI	0X50u		/* \tgEFA݃xNg */
#define	TVEC_SPRI	0x40u		/* XvAX݃xNg */

/*
 *  CPU{[h̃WX^
 */
#define TADR_BOARD_REG0		0xfff48000
#define TADR_BOARD_REG1		0xfff48004
#define TADR_BOARD_REG2		0xfff48008

/*
 *  DGA-001̃WX^̃AhX
 */
#define TADR_DGA_CSR0		0xfff44000
#define TADR_DGA_CSR1		0xfff44004
#define TADR_DGA_CSR3		0xfff4400c
#define TADR_DGA_CSR4		0xfff44010
#define TADR_DGA_CSR5		0xfff44014
#define TADR_DGA_CSR12		0xfff44030
#define TADR_DGA_CSR13		0xfff44034
#define	TADR_DGA_CSR19		0xfff4404c
#define	TADR_DGA_CSR20		0xfff44050
#define	TADR_DGA_CSR21		0xfff44054
#define TADR_DGA_CSR23		0xfff4405c
#define TADR_DGA_CSR24		0xfff44060
#define	TADR_DGA_CSR25		0xfff44064
#define	TADR_DGA_IFR0		0xfff44070
#define TADR_DGA_IFR3		0xfff4407c

/*
 *  DGAւ̃ANZX֐
 */
#define	dga_rew_reg(addr)		sil_rew_mem(addr)
#define dga_wrw_reg(addr, val)		sil_wrw_mem(addr, val)

/*
 *  PD72001iMPSCj̃WX^̃AhX
 */
#define	TADR_UPD72001_DATAA	0xfff45003
#define	TADR_UPD72001_CTRLA	0xfff45007
#define	TADR_UPD72001_DATAB	0xfff4500b
#define	TADR_UPD72001_CTRLB	0xfff4500f

/*
 *  PD72001ւ̃ANZX֐
 */
#define	upd72001_reb_reg(addr)		sil_reb_mem(addr)
#define upd72001_wrb_reg(addr, val)	sil_wrb_mem(addr, val)

/*
 *  GDB STUBďo[`
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

Inline void
dve68k_exit()
{
	Asm("trap #2");
}

Inline void
dve68k_putc(char c)
{
	Asm("move.l %0, %%d1; trap #3"
	  : /* no output */
	  : "g"((INT) c)
	  : "d0", "d1", "d2", "d6", "d7");
}

/*
 *  j^ďo[`
 */
#else /* GDB_STUB */

Inline void
dve68k_exit()
{
	Asm("clr.l %%d0; trap #3"
	  : /* no output */
	  : /* no input */
	  : "d0", "d1", "d2", "d6", "d7");
}

Inline char
dve68k_getc()
{
	INT	c;

	Asm("moveq.l #3, %%d0; trap #3; move.l %%d0, %0"
	  : "=g"(c)
	  : /* no input */
	  : "d0", "d1", "d2", "d6", "d7");
	  return((char) c);
}

Inline void
dve68k_putc(char c)
{
	Asm("moveq.l #5, %%d0; move.l %0, %%d1; trap #3"
	  : /* no output */
	  : "g"((INT) c)
	  : "d0", "d1", "d2", "d6", "d7");
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _DVE68K_H_ */
