/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sil.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	VXeC^tF[XCi^[Qbgʕj
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̃CN[ht@ĆCWCN[ht@Cis_services.hj
 *  ŃCN[hD܂CJ[lĂ΂foCXhCo
 *  CN[ht@CŁCCC֐ȂǂŃVXeC^tF[X
 *  CpĂꍇɂC̃t@CCN[hD
 *  OāC̃t@C璼ڃCN[h邱Ƃ͂ȂD
 *
 *  ̒ŃCN[hĂt@CāC̃CN[ht@
 *  CɈˑĂȂD
 */

#ifndef _SIL_H_
#define _SIL_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  J[lEAvP[V ʃCN[ht@C
 */
#include <t_stddef.h>

/*
 *  ITRONdlʋK̃f[^^E萔E}N
 */
#include <itron.h>

/*
 *  VXevZbTɈˑ`
 */
#include <sys_defs.h>
#include <cpu_defs.h>

/*
 *  VXeOT[rX̂߂̒`
 */
#include <t_syslog.h>

/*
 *  GfBA萔̒`
 */
#define	SIL_ENDIAN_LITTLE	0	/* gGfBA */
#define	SIL_ENDIAN_BIG		1	/* rbOGfBA */

#ifndef _MACRO_ONLY

/*
 *  ݃bNԂ̐
 */
#ifndef SIL_PRE_LOC
#include <kernel.h>
#define	SIL_PRE_LOC	BOOL _sil_loc_ = sns_loc()
#define	SIL_LOC_INT()	((void)(!(_sil_loc_) \
				&& (sns_ctx() ? iloc_cpu() : loc_cpu())))
#define	SIL_UNL_INT()	((void)(!(_sil_loc_) \
				&& (sns_ctx() ? iunl_cpu() : unl_cpu())))
#endif /* SIL_PRE_LOC */

/*
 *  ԑ҂
 */
extern void	sil_dly_nse(UINT dlytim) throw();

/*
 *  GfBA̔]
 */
#ifndef SIL_REV_ENDIAN_H
#define	SIL_REV_ENDIAN_H(data) \
	((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */

#ifndef SIL_REV_ENDIAN_W
#define	SIL_REV_ENDIAN_W(data) \
	((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) \
		| (((UW)(data)>> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */

/*
 *  ԃANZX֐
 */
#ifndef OMIT_SIL_ACCESS

/*
 *  8rbgPʂ̓Ǐo^
 */
#ifdef _int8_

Inline VB
sil_reb_mem(VP mem)
{
	VB	data;

	data = *((volatile VB *) mem);
	return(data);
}

Inline void
sil_wrb_mem(VP mem, VB data)
{
	*((volatile VB *) mem) = data;
}

#endif /* _int8_ */

/*
 *  16rbgPʂ̓Ǐo^
 */
#ifdef _int16_

Inline VH
sil_reh_mem(VP mem)
{
	VH	data;

	data = *((volatile VH *) mem);
	return(data);
}

Inline void
sil_wrh_mem(VP mem, VH data)
{
	*((volatile VH *) mem) = data;
}

#if SIL_ENDIAN == SIL_ENDIAN_BIG	/* rbOGfBAvZbT */

#define	sil_reh_bem(mem)	sil_reh_mem(mem)
#define	sil_wrh_bem(mem, data)	sil_wrh_mem(mem, data)

#ifndef OMIT_SIL_REH_LEM

Inline VH
sil_reh_lem(VP mem)
{
	VH	data;

	data = *((volatile VH *) mem);
	return(SIL_REV_ENDIAN_H(data));
}

#endif /* OMIT_SIL_REH_LEM */
#ifndef OMIT_SIL_WRH_LEM

Inline void
sil_wrh_lem(VP mem, VH data)
{
	*((volatile VH *) mem) = SIL_REV_ENDIAN_H(data);
}

#endif /* OMIT_SIL_WRH_LEM */
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG *//* gGfBAvZbT */

#define	sil_reh_lem(mem)	sil_reh_mem(mem)
#define	sil_wrh_lem(mem, data)	sil_wrh_mem(mem, data)

#ifndef OMIT_SIL_REH_BEM

Inline VH
sil_reh_bem(VP mem)
{
	VH	data;

	data = *((volatile VH *) mem);
	return(SIL_REV_ENDIAN_H(data));
}

#endif /* OMIT_SIL_REH_BEM */
#ifndef OMIT_SIL_WRH_BEM

Inline void
sil_wrh_bem(VP mem, VH data)
{
	*((volatile VH *) mem) = SIL_REV_ENDIAN_H(data);
}

#endif /* OMIT_SIL_WRH_BEM */
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */
#endif /* _int16_ */

/*
 *  32rbgPʂ̓Ǐo^
 */

Inline VW
sil_rew_mem(VP mem)
{
	VW	data;

	data = *((volatile VW *) mem);
	return(data);
}

Inline void
sil_wrw_mem(VP mem, VW data)
{
	*((volatile VW *) mem) = data;
}

#if SIL_ENDIAN == SIL_ENDIAN_BIG	/* rbOGfBAvZbT */

#define	sil_rew_bem(mem)	sil_rew_mem(mem)
#define	sil_wrw_bem(mem, data)	sil_wrw_mem(mem, data)

#ifndef OMIT_SIL_REW_LEM

Inline VW
sil_rew_lem(VP mem)
{
	VW	data;

	data = *((volatile VW *) mem);
	return(SIL_REV_ENDIAN_W(data));
}

#endif /* OMIT_SIL_REW_LEM */
#ifndef OMIT_SIL_WRW_LEM

Inline void
sil_wrw_lem(VP mem, VW data)
{
	*((volatile VW *) mem) = SIL_REV_ENDIAN_W(data);
}

#endif /* OMIT_SIL_WRW_LEM */
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG *//* gGfBAvZbT */

#define	sil_rew_lem(mem)	sil_rew_mem(mem)
#define	sil_wrw_lem(mem, data)	sil_wrw_mem(mem, data)

#ifndef OMIT_SIL_REW_BEM

Inline VW
sil_rew_bem(VP mem)
{
	VW	data;

	data = *((volatile VW *) mem);
	return(SIL_REV_ENDIAN_W(data));
}

#endif /* OMIT_SIL_REW_BEM */
#ifndef OMIT_SIL_WRW_BEM

Inline void
sil_wrw_bem(VP mem, VW data)
{
	*((volatile VW *) mem) = SIL_REV_ENDIAN_W(data);
}

#endif /* OMIT_SIL_WRW_BEM */
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */
#endif /* OMIT_SIL_ACCESS */

#endif /* _MACRO_ONLY */

#ifdef __cplusplus
}
#endif

#endif /* _SIL_H_ */
