/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: upd72001.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	PD72001p ȈSIOhCo
 */

#include <s_services.h>
#include <upd72001.h>

/*
 *  foCXWX^̃ANZXԊuԁinsecPʁj
 *
 *  200Ƃlɂ܂荪͂ȂD
 */
#define	UPD72001_DELAY	200

/*
 *  PD72001̃WX^̔ԍ
 */
#define	UPD72001_CR0	0x00u		/* Rg[WX^ */
#define	UPD72001_CR1	0x01u
#define	UPD72001_CR2	0x02u
#define	UPD72001_CR3	0x03u
#define	UPD72001_CR4	0x04u
#define	UPD72001_CR5	0x05u
#define	UPD72001_CR10	0x0au
#define	UPD72001_CR12	0x0cu
#define	UPD72001_CR14	0x0eu
#define	UPD72001_CR15	0x0fu

#define	UPD72001_SR0	0x00u		/* Xe[^XWX^ */

/*
 *  Rg[WX^̐ݒl
 */
#define CR_RESET	0x18u		/* |[gZbgR}h */

#define CR0_EOI		0x38u		/* EOIiEnd of Interruptj*/

#define CR1_DOWN	0x00u		/* S݂֎~ */
#define CR1_RECV	0x10u		/* M݋rbg */
#define CR1_SEND	0x02u		/* M݋rbg */

#define CR3_DEF		0xc1u		/* f[^ 8bitCMCl[u */
#define CR4_DEF		0x44u		/* Xgbvrbg 1bitCpeBȂ */
#define CR5_DEF		0xeau		/* f[^ 8bitCMCl[u */

#define CR10_DEF	0x00u		/* NRZ */
#define CR14_DEF	0x07u		/* {[[gWFl[^Cl[u */
#define CR15_DEF	0x56u		/* {[[gWFl[^gp */

#define SR0_RECV	0x01u		/* Mʒmrbg */
#define SR0_SEND	0x04u		/* M\rbg */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	VP	data;		/* f[^WX^̔Ԓn */
	VP	ctrl;		/* Rg[WX^̔Ԓn */

	UB	cr3_def;	/* CR3̐ݒliMrbgj*/
	UB	cr4_def;	/* CR4̐ݒliXgbvrbgCpeBj*/
	UB	cr5_def;	/* CR5̐ݒliMrbgj*/
	UB	brg1_def;	/* {[[gʂ̐ݒl */
	UB	brg2_def;	/* {[[gʂ̐ݒl */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
	UB		cr1;		/* CR1̐ݒli݋j*/
	BOOL		getready;	/* M */
	BOOL		putready;	/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 *
 *  ID = 1 |[gBCID = 2 |[gAɑΉĂD
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (VP) TADR_UPD72001_DATAB, (VP) TADR_UPD72001_CTRLB,
		CR3_DEF, CR4_DEF, CR5_DEF, BRG1_DEF, BRG2_DEF },
#if TNUM_SIOP >= 2
	{ (VP) TADR_UPD72001_DATAA, (VP) TADR_UPD72001_CTRLA,
		CR3_DEF, CR4_DEF, CR5_DEF, BRG1_DEF, BRG2_DEF },
#endif /* TNUM_SIOP >= 2 */
};

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  foCXWX^ւ̃ANZX֐
 */
Inline UB
upd72001_read_reg(VP addr)
{
	UB	val;

	val = (UB) upd72001_reb_reg(addr);
	sil_dly_nse(UPD72001_DELAY);
	return(val);
}

Inline void
upd72001_write_reg(VP addr, UB val)
{
	upd72001_wrb_reg(addr, (VB) val);
	sil_dly_nse(UPD72001_DELAY);
}

Inline UB
upd72001_read_ctrl(VP addr, UB reg)
{
	upd72001_write_reg(addr, reg);
	return(upd72001_read_reg(addr));
}

Inline void
upd72001_write_ctrl(VP addr, UB reg, UB val)
{
	upd72001_write_reg(addr, reg);
	upd72001_write_reg(addr, val);
}

Inline void
upd72001_write_brg(VP addr, UB reg, UB val, UB brg2, UB brg1)
{
	upd72001_write_reg(addr, reg);
	upd72001_write_reg(addr, val);
	upd72001_write_reg(addr, brg2);
	upd72001_write_reg(addr, brg1);
	(void) upd72001_read_reg(addr);		/* _~[[h */
}

/*
 *  Ԃ̓ǏoiSR0̓Ǐoj
 *
 *  PD72001́CԁiSR0jxǂނƎMʒmrbgĂ܂
 *  ߁CԂǂݏo֐݂CVAI/O|[gǗubN
 *  getready ɎMʒmԁCputready ɑM\ԂۑĂi
 *  M\Ԃ̕ۑ͕svȂjD
 *  ԃWX^ǂłMʒmrbgȂfoCXi炪
 *  ʂƎvjł́C̊֐͕KvȂD
 */
static void
upd72001_get_stat(SIOPCB *siopcb)
{
	UB	sr0;

	sr0 = upd72001_read_ctrl(siopcb->siopinib->ctrl, UPD72001_SR0);
	if ((sr0 & SR0_RECV) != 0) {
		siopcb->getready = TRUE;
	}
	if ((sr0 & SR0_SEND) != 0) {
		siopcb->putready = TRUE;
	}
}

/*
 *  Mł邩H
 */
Inline BOOL
upd72001_getready(SIOPCB *siopcb)
{
	upd72001_get_stat(siopcb);
	return(siopcb->getready);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
upd72001_putready(SIOPCB *siopcb)
{
	upd72001_get_stat(siopcb);
	return(siopcb->putready);
}

/*
 *  M̎o
 */
Inline char
upd72001_getchar(SIOPCB *siopcb)
{
	siopcb->getready = FALSE;
	return((char) upd72001_read_reg(siopcb->siopinib->data));
}

/*
 *  M镶̏
 */
Inline void
upd72001_putchar(SIOPCB *siopcb, char c)
{
	siopcb->putready = FALSE;
	upd72001_write_reg(siopcb->siopinib->data, (UB) c);
}

/*
 *  EOIiEnd Of Interruptjs
 */
Inline void
upd72001_eoi()
{
	upd72001_write_ctrl((VP) TADR_UPD72001_CTRLA, UPD72001_CR0, CR0_EOI);
}

/*
 *  SIOhCȍ[`
 */
void
upd72001_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
upd72001_openflag(void)
{
#if TNUM_SIOP < 2
	return(siopcb_table[0].openflag);
#else /* TNUM_SIOP < 2 */
	return(siopcb_table[0].openflag || siopcb_table[1].openflag);
#endif /* TNUM_SIOP < 2 */
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
upd72001_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;

	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	upd72001_write_reg(siopinib->ctrl, CR_RESET);
	if (!upd72001_openflag()) {
		upd72001_write_ctrl((VP) TADR_UPD72001_CTRLA,
						UPD72001_CR2, 0x18);
		upd72001_write_ctrl((VP) TADR_UPD72001_CTRLB,
						UPD72001_CR2, 0x00);
	}
	siopcb->cr1 = CR1_DOWN;
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR1, siopcb->cr1);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR4, siopinib->cr4_def);
	upd72001_write_brg(siopinib->ctrl, UPD72001_CR12, 
				0x01, siopinib->brg2_def, siopinib->brg1_def);
	upd72001_write_brg(siopinib->ctrl, UPD72001_CR12,
				0x02, siopinib->brg2_def, siopinib->brg1_def);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR15, CR15_DEF);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR14, CR14_DEF);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR10, CR10_DEF);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR3, siopinib->cr3_def);
	upd72001_write_ctrl(siopinib->ctrl, UPD72001_CR5, siopinib->cr5_def);
	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
upd72001_cls_por(SIOPCB *siopcb)
{
	upd72001_write_ctrl(siopcb->siopinib->ctrl, UPD72001_CR1, CR1_DOWN);
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
upd72001_snd_chr(SIOPCB *siopcb, char c)
{
	if (upd72001_putready(siopcb)) {
		upd72001_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
upd72001_rcv_chr(SIOPCB *siopcb)
{
	if (upd72001_getready(siopcb)) {
		return((INT)(UB) upd72001_getchar(siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
upd72001_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	cr1_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		cr1_bit = CR1_SEND;
		break;
	case SIO_ERDY_RCV:
		cr1_bit = CR1_RECV;
		break;
	}
	siopcb->cr1 |= cr1_bit;
	upd72001_write_ctrl(siopcb->siopinib->ctrl, UPD72001_CR1, siopcb->cr1);
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
upd72001_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	cr1_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		cr1_bit = CR1_SEND;
		break;
	case SIO_ERDY_RCV:
		cr1_bit = CR1_RECV;
		break;
	}
	siopcb->cr1 &= ~cr1_bit;
	upd72001_write_ctrl(siopcb->siopinib->ctrl, UPD72001_CR1, siopcb->cr1);
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
upd72001_isr_siop(SIOPCB *siopcb)
{
	if ((siopcb->cr1 & CR1_RECV) != 0 && upd72001_getready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		upd72001_ierdy_rcv(siopcb->exinf);
	}
	if ((siopcb->cr1 & CR1_SEND) != 0 && upd72001_putready(siopcb)) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		upd72001_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
upd72001_isr()
{
	if (siopcb_table[0].openflag) {
		upd72001_isr_siop(&(siopcb_table[0]));
	}
#if TNUM_SIOP >= 2
	if (siopcb_table[1].openflag) {
		upd72001_isr_siop(&(siopcb_table[1]));
	}
#endif /* TNUM_SIOP >= 2 */
	upd72001_eoi();
}
