;Komazou Installer
;Written by Junya Ishihara(jishiha@users.sourceforge.jp)

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;General

  ;Name and file

  !define VERSION "0.2"

  Name "R} ${VERSION}"
  OutFile "komazou_setup.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\komazou"

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "LICENSE"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES

  !define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\EXE_README.txt"
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "Japanese"

;--------------------------------
;Installer Sections

Section "R}" SecMain

  SetOutPath "$INSTDIR"
  WriteUninstaller "komazou_uninst.exe"

  ; Copy(Overwrite) files
  File install_files\komazou.exe
  File install_files\komazou_exe.bat
  File install_files\LICENSE
  File install_files\EXE_README.txt
  File install_files\config.org

SectionEnd

Section "uvj[ɒǉ()" SecSendTo

  CreateShortCut "$SENDTO\R}.lnk" "$INSTDIR\komazou_exe.bat"

SectionEnd

;--------------------------------
;Descriptions

  ;Language Strings
  LangString DESC_SecMain ${LANG_JAPANESE} "uR}vCXg[܂B"
  LangString DESC_SecSendTo ${LANG_JAPANESE} "uR}vuvj[ɒǉ܂B"

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecMain} $(DESC_SecMain)
    !insertmacro MUI_DESCRIPTION_TEXT ${SecSendto} $(DESC_SecSendTo)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; Delete directories
  RMDir /r "$INSTDIR"
  Delete "$SENDTO\R}.lnk"

SectionEnd