/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* @method Exception! Exception.new(String msg, Any bag) */

METHOD knh__Exception_new(Ctx *ctx, knh_sfp_t *sfp)
{
	Exception *o = sfp[0].e;
	DP(o)->eid  = EXPT_Exception;
	DP(o)->flag = knh_tExpt_flag(DP(o)->eid);

	knh_wbuf_t wbuf = knh_Context_wbuf(ctx);
	knh_write__s(ctx, wbuf.w, "Exception!!");
	if(IS_NOTNULL(sfp[1].o)) {
		knh_write__s(ctx, wbuf.w, ": ");
		knh_write(ctx, wbuf.w, knh_String_tobytes(sfp[1].s));
	}
	KNH_SETv(ctx, DP(o)->message, new_String__wbuf(ctx, wbuf));
	KNH_SETv(ctx, DP(o)->bag, sfp[2].o);
	KNH_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

int knh_Exception_isa(Ctx *ctx, Exception *o, String *msg)
{
	knh_expt_t eid = knh_texpt_forname(ctx, knh_String_tobytes(msg), EXPT_unknown);
	if(eid == EXPT_unknown) return 0;
	return knh_tExpt_isa(DP(o)->eid, eid);
}

/* ------------------------------------------------------------------------ */
/* @method Boolean! Exception.opIsa(String! m) */

METHOD knh__Exception_opIsa(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, knh_Exception_isa(ctx, sfp[0].e, sfp[1].s));
}


/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void Exception.%s(OutputStream w, String m) */

void knh_Exception__s(Ctx *ctx, Exception *o, OutputStream *w, String *m)
{
	KNH_ASSERT(IS_Exception(o));
	knh_write__s(ctx, w, EXPTN(DP(o)->eid));
	knh_write__s(ctx, w, "!!");
}

/* ------------------------------------------------------------------------ */
/* @method void Exception.%k(OutputStream w, String m) */

void knh_Exception__k(Ctx *ctx, Exception *o, OutputStream *w, String *m)
{
	KNH_ASSERT(IS_Exception(o));
	knh_putc(ctx, w, '\'');
	knh_write(ctx, w, knh_String_tobytes(DP(o)->message));
	knh_putc(ctx, w, '\'');
}

/* ------------------------------------------------------------------------ */
/* @method void Exception.%dump(OutputStream w, String m) */

void knh_Exception__dump(Ctx *ctx, Exception *o, OutputStream *w, String *m)
{
	KNH_ASSERT(IS_Exception(o));
	knh_write__s(ctx, w, "---- ---- 8< 8< ---- ---- >8 >8 ---- ----");
	knh_println(ctx, w, STEXT(""));
	if(DP(o)->line == 0) {
		knh_printf(ctx, w, "(%s:%d) ", DP(o)->file, DP(o)->line);
	}
	knh_write(ctx, w, knh_String_tobytes(DP(o)->message));
	knh_println(ctx, w, STEXT(""));
	if(IS_Array(DP(o)->traces)) {
		size_t i;
		for(i = 0; i < knh_Array_size(DP(o)->traces); i++) {
			knh_write(ctx, w, STEXT("  at "));
			knh_format(ctx, w, METHODN__s, knh_Array_n(DP(o)->traces, i), KNH_NULL);
			knh_println(ctx, w, STEXT(""));
		}
	}
	knh_write__s(ctx, w, "---- ---- 8< 8< ---- ---- >8 >8 ---- ----");
	knh_println(ctx, w, STEXT(""));
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
