/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [definition] */

#define _EXPT_unknown  ((knh_expt_t)-1)
#define _EXPT_newid    ((knh_expt_t)0)

#ifndef EXPT_Exception
#define EXPT_Exception 1
#endif


/* ------------------------------------------------------------------------ */

#ifndef KNH_TEXPT_SIZE
#define KNH_TEXPT_SIZE (KNH_TCLASS_SIZE/4)
#endif

typedef struct {
	knh_flag_t   flag;
	knh_expt_t   parent;
	struct knh_String_t     *name;
} knh_tExpt_t;

#define SIZEOF_TEXPT  (KNH_TEXPT_SIZE * sizeof(knh_tExpt_t))

static knh_tExpt_t  *knh_tExpt           = NULL;
static size_t    knh_tExptSize           = 0;
static DictSet  *texptNameDictSet        = NULL;

/* ======================================================================== */
/* [sync] */

#define KNH_SLOCK()
#define KNH_UNSLOCK()

/* ------------------------------------------------------------------------ */

void knh_tExpt_init0(void)
{
	KNH_ASSERT(knh_tExpt == NULL);
	size_t i;
	knh_tExpt = (knh_tExpt_t*)KNH_MALLOC(NULL, SIZEOF_TEXPT);
	knh_tExptSize = 0;
	for(i = 0; i < KNH_TEXPT_SIZE; i++) {
		knh_tExpt[i].flag     = 0;
		knh_tExpt[i].parent   = 1;
		knh_tExpt[i].name     = NULL;
	}
	KNH_INITv(texptNameDictSet, new_DictSet(NULL, KNH_TEXPT_SIZE));
}

/* ------------------------------------------------------------------------ */

void knh_tExpt_traverse(Ctx *ctx, f_traverse ftr)
{
	KNH_ASSERT(knh_tExpt != NULL);
	size_t i;
	/* tClass */
	ftr(ctx, UP(texptNameDictSet));
	for(i = 0; i < knh_tExptSize; i++) {
		if(knh_tExpt[i].name != NULL) {
			ftr(ctx, UP(knh_tExpt[i].name));
		}
	}

	if(IS_SWEEP(ftr)) {
		KNH_FREE(knh_tExpt, SIZEOF_TEXPT);
		texptNameDictSet = NULL;
		knh_tExpt = NULL;
	}
}

/* ======================================================================== */
/* [newid] */

knh_class_t knh_tExpt_newId(Ctx *ctx)
{
	knh_class_t newid;
	KNH_SLOCK();
	if(!(knh_tExptSize < KNH_TEXPT_SIZE)) {
		KNH_EXIT("Enlarge KNH_TEXPT_SIZE %d", KNH_TEXPT_SIZE);
		return 0;
	}
	newid = knh_tExptSize;
	knh_tExptSize++;
	KNH_UNSLOCK();
	return newid + 1;
}

/* ------------------------------------------------------------------------ */

int IS_eid(knh_expt_t eid)
{
	return ((eid - 1)< knh_tExptSize);
}

#define _DEBUG_ASSERT_eid(cid)    KNH_ASSERT(IS_eid(cid))

/* ------------------------------------------------------------------------ */

knh_flag_t knh_tExpt_flag(knh_expt_t eid)
{
	KNH_ASSERT(IS_eid(eid));
	return knh_tExpt[eid-1].flag;
}

/* ------------------------------------------------------------------------ */

knh_expt_t knh_tExpt_parent(knh_expt_t eid)
{
	KNH_ASSERT(IS_eid(eid));
	return knh_tExpt[eid-1].parent;
}

/* ------------------------------------------------------------------------ */

knh_bool_t knh_tExpt_isa(knh_expt_t eid, knh_expt_t parent)
{
	KNH_ASSERT(IS_eid(eid));
	KNH_ASSERT(parent < knh_tExptSize);
	if(eid == parent || parent == 1) return 1;
	if(eid == 1) return 0;
	while((eid = knh_tExpt[eid-1].parent) != 1) {
		if(eid == parent) return 1;
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

#define _EXPTN(eid)   knh_String_tochar(knh_tExpt_name(eid))

INLINE
String *knh_tExpt_name(knh_expt_t eid)
{
	KNH_ASSERT(IS_eid(eid));
	return knh_tExpt[eid-1].name;
}

/* ------------------------------------------------------------------------ */
/* [forname] */

knh_expt_t knh_texpt_forname(Ctx *ctx, knh_bytes_t msg, knh_expt_t def)
{
	knh_int_t loc = knh_bytes_index(msg, '!');
	if(loc != -1) {
		if(msg.buf[loc+1] != '!') {
			return EXPT_Exception;
		}
		msg = knh_bytes_first(msg, loc);
	}

	if(msg.len == 0) return EXPT_Exception; /* '!!' */

	knh_expt_t eid = (knh_expt_t)knh_DictSet_get__b(texptNameDictSet, msg);
	if(eid != 0) return eid;
	if(def == EXPT_newid) {
		return KNH_TEXPT(ctx, KNH_FLAG_EF_GENERATED, EXPT_newid, new_String(ctx, msg, NULL), NULL);
	}
	return def;
}

/* ------------------------------------------------------------------------ */
/* [TABLE] */

knh_expt_t KNH_TEXPT(Ctx *ctx, knh_flag_t flag, knh_class_t eid, String *name, char *pname)
{
	if(eid == EXPT_newid) {
		eid = knh_tExpt_newId(ctx);
	}else {
		knh_tExptSize++;
		KNH_ASSERT(eid == knh_tExptSize);
	}

	KNH_ASSERT(IS_eid(eid));

	knh_expt_t parent = EXPT_Exception;
	if(pname != NULL) {
		parent = knh_texpt_forname(ctx, B(pname), parent);
		if(parent == EXPT_Exception) {
			DBG2_P("NoSuchException!!: %s", pname);
		}
	}

	KNH_ASSERT(knh_tExpt[eid-1].name == NULL);
	knh_tExpt[eid-1].flag = flag;
	knh_tExpt[eid-1].parent = parent;
	KNH_INITv(knh_tExpt[eid-1].name, name);
	knh_DictSet_set(ctx, texptNameDictSet, name, eid);
	//DBG2_P("Generating new Exception eid=%d name='%s'", eid, knh_String_tochar(knh_tExpt[eid].name));
	return eid;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
