#!/usr/bin/python
import os, fnmatch
import itertools

file_object = open('../build/Makefile.am', 'w')

def all_files(root, patterns='*', single_level=False, yield_folders= False):
	patterns = patterns.split(";");
	for path, subdirs, files in os.walk(root):
		if yield_folders:
			files.extend(subdirs)
		files.sort()
		for name in files:
			for pattern in patterns:
				if fnmatch.fnmatch(name, pattern):
					yield os.path.join(path, name)
					break
		if single_level:
			break

def anyTrue(predicate, sequence):
	return True in itertools.imap(predicate, sequence)
def endsWith(s, *endings):
	return anyTrue(s.endswith, endings)

file_object.writelines("""# this Makefile is generated from ../pygen/gen_Makefile.py
# shinpei@ynu(c)2008

# make target for libtool.
lib_LTLIBRARIES = libkonoha.la

libkonoha_la_LDFLAGS = -no-undefined -release 1 -version-info 0:0:0
#if LDL
#libkonoha_la_LDFLAGS += -ldl
#endif

AM_CPPFLAGS = -I../include
#if MINGW
#AM_CPPFLAGS += -DKONOHA_OS__MINGW
#endif

libkonoha_la_SOURCES = 
""")
for path in all_files('../class', '*.c'):
	if endsWith(path, 'konoha.c'):
		print "skip konoha.c"
	else:
		file_object.writelines("libkonoha_la_SOURCES += " + path + "\n")

for path in all_files('../konoha', '*.c'):
	if endsWith(path, 'konoha.c'):
		print "skip konoha.c"
	else:
		file_object.writelines("libkonoha_la_SOURCES += " + path + "\n")

file_object.writelines("""bin_PROGRAMS = konoha

konoha_SOURCES = ../konoha/konoha.c
konoha_INCLUDES = ../include
konoha_LDADD = libkonoha.la""")

file_object.close()


