/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [Method] */

void knh_Class_addMethod(Ctx *ctx, knh_class_t cid, Method *mtd)
{
	KNH_ASSERT(IS_Method(mtd));
	KNH_ASSERT(cid == DP(mtd)->cid);
	KNH_ASSERT_cid(cid);
	ClassStruct *cs = ctx->tClass[cid].cstruct;;
	size_t i;
	for(i = 0; i < knh_Array_size(cs->methods); i++) {
		Method *mtd2 = (Method*)knh_Array_n(cs->methods, i);
		if(DP(mtd2)->mn == DP(mtd)->mn) {
			char buf[CLASSNAME_BUFSIZ];
			knh_format_cmethodn(ctx, buf, sizeof(buf), cid, DP(mtd)->mn);
			KNH_WARNING(ctx, "Duplicated method: %s", buf);
			return ;
		}
	}
	if(knh_class_isSingleton(cid)) {
		DP(mtd)->flag = DP(mtd)->flag | KNH_FLAG_MF_STATIC;
	}
	knh_Array_add(ctx, cs->methods, UP(mtd));
}

/* ------------------------------------------------------------------------ */
/* [tMethodField] */

#define _knh_tMethodField_size               knh_Array_size(DP(ctx->sys)->tMethodFields)

/* ------------------------------------------------------------------------ */

void knh_tMethodField_add(Ctx *ctx, MethodField *mf)
{
	knh_Array_add(ctx, DP(ctx->sys)->tMethodFields, UP(mf));
}

/* ------------------------------------------------------------------------ */

void knh_tMethodField_add0(Ctx *ctx, knh_flag_t flag, knh_type_t rtype)
{
	MethodField *mf = new_MethodField(ctx, 1);
	mf->params[0].type = rtype;
	mf->params[0].fn = FIELDN_return;
	knh_tMethodField_add(ctx, mf);
}

/* ------------------------------------------------------------------------ */

void knh_tMethodField_add1(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, knh_type_t t1, knh_fieldn_t fn1)
{
	MethodField *mf = new_MethodField(ctx, 2);
	mf->params[0].type = rtype;
	mf->params[0].fn = FIELDN_return;
	mf->params[1].type = t1;
	mf->params[1].fn = fn1;
	knh_tMethodField_add(ctx, mf);
}

///* ------------------------------------------------------------------------ */
//
//void knh_tMethodField_add2(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2)
//{
//	MethodField *mf = new_MethodField(ctx, 3);
//	mf->params[0].type = rtype;
//	mf->params[0].fn = FIELDN_return;
//	mf->params[1].type = t1;
//	mf->params[1].fn = fn1;
//	mf->params[2].type = t2;
//	mf->params[2].fn = fn2;
//	knh_tMethodField_add(ctx, mf);
//}
//
///* ------------------------------------------------------------------------ */
//
//void knh_tMethodField_add3(Ctx *ctx, knh_flag_t flag, knh_type_t rtype,
//		knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2, knh_type_t t3, knh_fieldn_t fn3)
//{
//	MethodField *mf = new_MethodField(ctx, 4);
//	mf->params[0].type = rtype;
//	mf->params[0].fn = FIELDN_return;
//	mf->params[1].type = t1;
//	mf->params[1].fn = fn1;
//	mf->params[2].type = t2;
//	mf->params[2].fn = fn2;
//	mf->params[3].type = t3;
//	mf->params[3].fn = fn3;
//	knh_tMethodField_add(ctx, mf);
//}
//
///* ------------------------------------------------------------------------ */
//
//void knh_tMethodField_add4(Ctx *ctx, knh_flag_t flag, knh_type_t rtype,
//		knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2,
//		knh_type_t t3, knh_fieldn_t fn3, knh_type_t t4, knh_fieldn_t fn4)
//{
//	MethodField *mf = new_MethodField(ctx, 5);
//	mf->params[0].type = rtype;
//	mf->params[0].fn = FIELDN_return;
//	mf->params[1].type = t1;
//	mf->params[1].fn = fn1;
//	mf->params[2].type = t2;
//	mf->params[2].fn = fn2;
//	mf->params[3].type = t3;
//	mf->params[3].fn = fn3;
//	mf->params[4].type = t4;
//	mf->params[4].fn = fn4;
//	knh_tMethodField_add(ctx, mf);
//}

/* ------------------------------------------------------------------------ */

MethodField *knh_tMethodField(Ctx *ctx, size_t n)
{
	return (MethodField*)knh_Array_n(DP(ctx->sys)->tMethodFields, n);
}

/* ------------------------------------------------------------------------ */

MethodField *knh_tMethodField_find0(Ctx *ctx, knh_type_t rtype)
{
	int i, size = knh_tMethodField_size;
	MethodField *mf = NULL;
	for(i = 0; i < size; i++) {
		mf = knh_tMethodField(ctx, i);
		if(mf->size != 0) continue;
		if(mf->params[0].type == rtype) return mf;
	}
	mf = new_MethodField(ctx, 1);
	mf->params[0].type = rtype;
	mf->params[0].fn = FIELDN_return;
	knh_tMethodField_add(ctx, mf);
	return mf;
}

/* ------------------------------------------------------------------------ */

static
MethodField *knh_tMethodField_find1(Ctx *ctx, knh_type_t rtype, knh_type_t p1, knh_fieldn_t fn1)
{
	int i, size = knh_tMethodField_size;
	MethodField *mf = NULL;
	for(i = 0; i < size; i++) {
		mf = knh_tMethodField(ctx, i);
		if(mf->size != 1) continue;
		if(mf->params[0].type != rtype) continue;
		if(mf->params[1].type != p1) continue;
		return mf;
	}
	mf = new_MethodField(ctx, 2);
	mf->params[0].type = rtype;
	mf->params[0].fn = FIELDN_return;
	mf->params[1].type = p1;
	mf->params[1].fn = fn1;
	return mf;
}

/* ------------------------------------------------------------------------ */
/* [field_method] */

static
METHOD knh_fmethod_getter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	KNH_RETURN(ctx, sfp, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta));
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_igetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Int *o = (Int*)KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta);
	KNH_RETURN_Int(ctx, sfp, o->n.ivalue);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_fgetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Float *o = (Float*)KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta);
	KNH_RETURN_Float(ctx, sfp, o->n.fvalue);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_bgetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Boolean *o = (Boolean*)KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta);
	KNH_RETURN_Boolean(ctx, sfp, o->n.bvalue);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_setter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), sfp[1].o);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_bsetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), new_Boolean(ctx, sfp[1].bvalue));
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_isetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Int *n = new_Int(ctx, sfp[1].ivalue);
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), n);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_insetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Int *n = IS_NULL(sfp[1].o) ? sfp[1].i : new_Int(ctx, sfp[1].ivalue);
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), n);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_fsetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Float *n = new_Float(ctx, sfp[1].fvalue);
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), n);
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */

static
METHOD knh_fmethod_fnsetter(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(IS_Method(sfp[-1].mtd));
	Float *n = IS_NULL(sfp[1].o) ? sfp[1].f : new_Float(ctx, sfp[1].fvalue);
	KNH_MOV(ctx, KNH_FIELDn(sfp[0].o, DP(sfp[-1].mtd)->delta), n);
	KNH_RETURN_void(ctx, sfp);
}


/* ------------------------------------------------------------------------ */

static
Method *new_Method_getter(Ctx *ctx, knh_class_t cid, knh_methodn_t mn, knh_type_t type, int idx)
{
	knh_fmethod f = knh_fmethod_getter;
	if(type == NNTYPE_Int) {
		f = knh_fmethod_igetter;
	}
	else if(type == NNTYPE_Float) {
		f = knh_fmethod_fgetter;
	}
	else if(type == NNTYPE_Boolean) {
		f = knh_fmethod_bgetter;
	}
	Method *mtd = new_Method(ctx, KNH_FLAG_MF_GENERATED, cid, mn, f);
	DP(mtd)->delta = idx;
	KNH_SETv(ctx, DP(mtd)->mf, knh_tMethodField_find0(ctx, type));
	return mtd;
}

/* ------------------------------------------------------------------------ */

static
Method *new_Method_setter(Ctx *ctx, knh_class_t cid, knh_methodn_t mn, knh_type_t type, int idx)
{
	knh_fmethod f = knh_fmethod_setter;
	if(type == NNTYPE_Int) {
		f = knh_fmethod_isetter;
	}
	else if(type == TYPE_Int) {
		f = knh_fmethod_insetter;
	}
	else if(type == NNTYPE_Float) {
		f = knh_fmethod_fsetter;
	}
	else if(type == TYPE_Float) {
		f = knh_fmethod_fnsetter;
	}
	else if(type == NNTYPE_Boolean) {
		f = knh_fmethod_bsetter;
	}
	Method *mtd = new_Method(ctx, KNH_FLAG_MF_GENERATED, cid, mn, f);
	DP(mtd)->delta = idx;
	KNH_SETv(ctx, DP(mtd)->mf, knh_tMethodField_find1(ctx, TYPE_void, type, FIELDN_v));
	return mtd;
}

/* ------------------------------------------------------------------------ */

Method*
knh_Class_getMethod__(Ctx *ctx, knh_class_t this_cid, knh_methodn_t mn, knh_bool_t gen)
{
	knh_class_t cid = this_cid;
	TAIL_RECURSION:;
	KNH_ASSERT_cid(cid);
	{
		ClassStruct *cs = ctx->tClass[cid].cstruct;;
		size_t i;
		for(i = 0; i < knh_Array_size(cs->methods); i++) {
			Method *mtd = (Method*)knh_Array_n(cs->methods, i);
			if(DP(mtd)->mn == mn) return mtd;
		}
		if(cid == CLASS_Object) {
			cid = this_cid;
			goto L_GenerateField;
		}
		cid = ctx->tClass[cid].supcid;
	}
	goto TAIL_RECURSION;

	L_GenerateField:;
	if(METHODN_IS_GETTER(mn)) {
		knh_index_t idx = knh_Class_indexOfField(ctx, this_cid, METHODN_TOFIELDN(mn));
		if(idx == -1) {
			goto L_NoSuchMethod;
		}
		else {
			knh_cfield_t *cf = knh_Class_fieldAt(ctx, this_cid, idx);
			if(!KNH_FLAG_IS(cf->flag, KNH_FLAG_CFF_GETTER)) {
				goto L_NoSuchMethod;
			}
			else {
				Method *mtd = new_Method_getter(ctx, this_cid, mn, cf->type, idx);
				ClassStruct *cs = ctx->tClass[this_cid].cstruct;;
				knh_Array_add(ctx, cs->methods, UP(mtd));
				return mtd;
			}
		}
	}

	if(METHODN_IS_SETTER(mn)) {
		knh_index_t idx = knh_Class_indexOfField(ctx, this_cid, METHODN_TOFIELDN(mn));
		if(idx == -1) {
			goto L_NoSuchMethod;
		}
		else {
			knh_cfield_t *cf = knh_Class_fieldAt(ctx, this_cid, idx);
			if(!KNH_FLAG_IS(cf->flag, KNH_FLAG_CFF_SETTER)) {
				goto L_NoSuchMethod;
			}
			else {
				Method *mtd = new_Method_setter(ctx, this_cid, mn, cf->type, idx);
				ClassStruct *cs = ctx->tClass[this_cid].cstruct;;
				knh_Array_add(ctx, cs->methods, UP(mtd));
				return mtd;
			}
		}
	}

	L_NoSuchMethod:;
	//DEBUG("Not Found: cid=%s, mn=%d,%s", CLASSN(this_cid), mn, METHODN(mn));
	if(gen) {
		if(METHODN_IS_MOVTEXT(mn)) {
			return knh_Class_getMethod(ctx, cid, METHODN__empty);
		}
		else {
			Method *mtd = new_Method__NoSuchMethod(ctx, cid, mn);
			ClassStruct *cs = ctx->tClass[this_cid].cstruct;;
			DBG2_({
				char bufcm[CLASSNAME_BUFSIZ];
				knh_format_cmethodn(ctx, bufcm, sizeof(bufcm), cid, mn);
				DBG2_P("GENERATE NoSuchMethod: %s", bufcm);
			})
			knh_Array_add(ctx, cs->methods, UP(mtd));
			return mtd;
		}
	}
	else {
		return (Method*)KNH_NULL;
	}
}

#define _knh_Class_getMethod(ctx, c, mn)    knh_Class_getMethod__(ctx, c, mn, 0)
#define _knh_Class_findMethod(ctx, c, mn)   knh_Class_getMethod__(ctx, c, mn, 1)

/* ======================================================================== */
/* [utils] */

Method *knh_Method_ufind(Ctx *ctx, knh_class_t cid, knh_methodn_t mn)
{
	KNH_ASSERT(!METHODN_IS_MOVTEXT(mn));
	DBG2_({
		char bufcm[CLASSNAME_BUFSIZ];
		knh_format_cmethodn(ctx, bufcm, sizeof(bufcm), cid, mn);
		DBG2_P("finding ..: %s", bufcm);
	})
	return knh_Class_findMethod(ctx, cid, mn);
}

/* ------------------------------------------------------------------------ */

Method *knh_tMethod_findMT(Ctx *ctx, knh_class_t cid, knh_methodn_t mn)
{
	KNH_ASSERT(METHODN_IS_MOVTEXT(mn));
//	DBG2_({
//		char bufcm[CLASSNAME_BUFSIZ];
//		knh_format_cmethodn(bufcm, sizeof(bufcm), cid, mn);
//		DBG2_P("finding ..: %s", bufcm);
//	})
	return knh_Class_findMethod(ctx, cid, mn);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
