#if defined(K_USING_SSA_OPT) 
#define USE_OPT_SIMPLE_CONSTANT_FOLDING
#define DEF_SIMPLE_CONSTANT_FOLDING {"Simple Constant Folding", opt_constant_fold}
struct cfold {
	knh_ndata_t data;
	knh_sfpidx_t from;
};

#define load_cfdata(a, i, cf) {\
	(cf).data = IArray_get(a, i + 0);\
	(cf).from = IArray_get(a, i + 1);\
}

#define opcode_ishift(opcode) (opcode + OPCODE_iADDn - OPCODE_iADD)
#define opcode_fshift(opcode) (opcode + OPCODE_fADDn - OPCODE_fADD)
static void __constant_fold(Ctx *ctx, knh_BasicBlock_t *bb, knh_Array_t *a)
{
	size_t i;
	for (i = 0; i < DP(bb)->size; i++) {
		knh_opline_t *op = DP(bb)->opbuf + i;
		if (op->opcode == OPCODE_NSET) {
			knh_sfpidx_t from = ((klr_NSET_t*) op)->a;
			knh_ndata_t  data = ((klr_NSET_t*) op)->n;
			IArray_add(ctx, a, (knh_int_t) data);
			IArray_add(ctx, a, (knh_int_t) from);
		}
		else {
			int j = 0, size = knh_Array_size(a);
			//dump_foldlist(a);
			for (j = 0; j < size; j+=2) {
				struct cfold cf;
				load_cfdata(a, j, cf);
				if (op->opcode == OPCODE_NMOV && ((klr_NMOV_t *)op)->b == cf.from) {
					klr_NSET_t *op_ = (klr_NSET_t*) op;
					op_->opcode = OPCODE_NSET;
					op_->n = cf.data;
				}
				if (OPCODE_iADDn <= op->opcode && op->opcode <= OPCODE_iGTEn) {
					if(((klr_iJEQn_t*)op)->a == cf.from) {
					}
				}
#ifdef USE_OPT_REMOVE_UNREACHABLE_BLOCK
				if (OPCODE_iJEQn <= op->opcode && op->opcode <= OPCODE_iJGTEn) {
					if(((klr_iJEQn_t*)op)->a == cf.from) {
						op->opcode = OPCODE_NOP;
						KNH_FINALv(ctx, bb->jumpNC);
						bb->jumpNC = NULL;
					}
				}
#endif
				if (OPCODE_iADD <= op->opcode && op->opcode <= OPCODE_iGTE) {
					if (((klr_iADD_t *)op)->b == cf.from) {
						/* TODO swap b <=> c & fix opcode. */
					}
					if (((klr_iADD_t *)op)->c == cf.from) {
						klr_iADDn_t *op_ = (klr_iADDn_t*) op;
						op_->opcode = opcode_ishift(op->opcode);
						op_->n = cf.data;
					}
				}
				/* TODO folding float operations */
				if (OPCODE_fADD <= op->opcode && op->opcode <= OPCODE_fGTE) {
				}
			}
		}
	}
}

static void opt_constant_fold(Ctx *ctx, knh_BasicBlock_t *bb, knh_Array_t *a, int mask)
{
	int org_size = knh_Array_size(a);
	knh_BasicBlock_setVisited(bb, mask);
	__constant_fold(ctx, bb, a);
	if (bb->nextNC && knh_BasicBlock_isVisited(bb->nextNC) != mask)
		opt_constant_fold(ctx, bb->nextNC, a, mask);
	if (bb->jumpNC && knh_BasicBlock_isVisited(bb->jumpNC) != mask)
		opt_constant_fold(ctx, bb->jumpNC, a, mask);
	knh_Array_clear(ctx, a, org_size);
}

//static void dump_foldlist(knh_Array_t *a)
//{
//	int i;
//	fprintf(stderr, "size=%d ", (int) knh_Array_size(a));
//	for (i = 0; i < knh_Array_size(a); i+=2) {
//		struct cfold cf;
//		cf.data = a->nlist[i + 0];
//		cf.from = a->ilist[i + 1];
//		fprintf(stderr, "cfold[%d]={data:%d, from:%d},", i, (int) cf.data, (int)cf.from);
//	}
//	fprintf(stderr, "\n");
//}

#endif /* K_USING_SSA_OPT */
