#if defined(K_USING_SSA_OPT)
#define USE_OPT_REMOVE_NOPCODE
#define USE_OPT_NULL

#define DEF_NULL {"NULL", opt_nop}
#define DEF_REMOVE_NOPCODE {"NOP", opt_remove_nopcode}

static void opt_nop(Ctx *ctx, knh_BasicBlock_t *bb, knh_Array_t *a, int mask)
{
	knh_BasicBlock_setVisited(bb, mask);
	if (bb->nextNC && knh_BasicBlock_isVisited(bb->nextNC) != mask)
		opt_nop(ctx, bb->nextNC, a, mask);
	if (bb->jumpNC && knh_BasicBlock_isVisited(bb->jumpNC) != mask)
		opt_nop(ctx, bb->jumpNC, a, mask);
}

static void opt_remove_nopcode(Ctx *ctx, knh_BasicBlock_t *bb, knh_Array_t *a, int mask)
{
	knh_BasicBlock_setVisited(bb, mask);
	int i, size = DP(bb)->size;
	knh_cwb_t cwbbuf, *cwb = knh_cwb_open(ctx, &cwbbuf);
	for (i = 0; i < size; i++) {
		knh_opline_t *op = DP(bb)->opbuf + i;
		if (op->opcode != OPCODE_NOP) {
			knh_Bytes_write(ctx, cwb->ba, new_bytes2((char *)op, sizeof(knh_opline_t)));
		}
	}
	DP(bb)->size = knh_cwb_size(cwb) / sizeof(knh_opline_t);
	knh_memcpy(DP(bb)->opbuf, knh_cwb_tochar(ctx, cwb), knh_cwb_size(cwb));
	knh_cwb_close(cwb);
	if (bb->nextNC && knh_BasicBlock_isVisited(bb->nextNC) != mask)
		opt_remove_nopcode(ctx, bb->nextNC, a, mask);
	if (bb->jumpNC && knh_BasicBlock_isVisited(bb->jumpNC) != mask)
		opt_remove_nopcode(ctx, bb->jumpNC, a, mask);
}

#endif /* K_USING_SSA_OPT */
