#include <konoha.h>
#include <graphviz/gvc.h>
#include <graphviz/graph.h>



#ifdef __cplusplus
extern "C" {
#endif
    

  /*--------------------Const Data------------------------*/

static
knh_IntData_t IntConstData[] = {
  {"Graphviz.AGDIGRAPH",AGDIGRAPH},
  {NULL}
};

/*--------------------Class Graphviz--------------------------*/
/*
METHOD Graphviz_setAttribute(Ctx *ctx,knh_sfp_t *sfp)
{
  void *obj = (void *)p_cptr(sfp[1]);
  char *name = String_to(sfp[2]);
  char *value = String_to(sfp[3]);
  agsafeset(obj,name,value,NULL);
  KNH_RETURN_void(ctx,sfp);
}
METHOD Graphviz_copyAttribute(Ctx *ctx,knh_sfp_t *sfp)
{
  void *oldobj = (void *)p_cptr(sfp[1]);
  void *newobj = (void *)p_cptr(sfp[2]);
  agcopyattr(oldobj,newobj);
  KNH_RETURN_void(ctx,sfp);
}
*/

/*---------------------Class GraphvizContext------------------------*/

/*
static void knh_gvc_gfree(Ctx *ctx, knh_Glue_t *g)
{
    GVC_t *gvc = (GVC_t *) g->ptr;
    gvFreeContext(gvc);
}
*/

METHOD GraphvizContext_new(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = gvContext();
  //  knh_Glue_init(ctx,sfp[0].glue,gvc,knh_gvc_gfree);
  knh_Glue_init(ctx,sfp[0].glue,gvc,NULL);
  KNH_RETURN(ctx,sfp,sfp[0].o);
}

METHOD GraphvizContext_free(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = (GVC_t *)p_cptr(sfp[0]);
  gvFreeContext(gvc);
  KNH_RETURN_void(ctx,sfp);
}
  
METHOD GraphvizContext_parseArgs(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = (GVC_t *)p_cptr(sfp[0]);
  char *format = String_to_(sfp[1]);
  char *filename = String_to_(sfp[2]);
  char **argv;
  int argc = 4;
  argv = (char **)alloca(argc * sizeof(char*));
  // knh_Array_t *a = (knh_Array_t *)sfp[1].o;
  //argc = knh_Array_size(a);
  //  for (i = 0; i < argc; i++) {
  //	argv[i] = knh_String_tochar((knh_String_t *)knh_Array_n(a, i));
  // }
  // fprintf(stderr,"argv[1] = [%s],argv[2] = [%s]\n",argv[1],argv[2]);
  // fprintf(stderr,"format = [%s]\n",format);
  // fprintf(stderr,"filename = [%s]\n",filename);
  char *buf = (char *)malloc(sizeof(char)*64);
  char *buf2 = (char *)malloc(sizeof(char)*64);
  snprintf(buf,sizeof(format)+16,"-T%s",format);
  snprintf(buf2,sizeof(filename)+16,"-o%s.%s",filename,format);
  argv[0] = "konoha";
  argv[1] = buf;
  argv[2] = buf2;
  argv[3] = "-q";
  gvParseArgs(gvc,argc,argv);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizContext_layoutJobs(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = (GVC_t *)p_cptr(sfp[0]);
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[1]);
  gvLayoutJobs(gvc,g);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizContext_renderJobs(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = (GVC_t *)p_cptr(sfp[0]);
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[1]);
  gvRenderJobs(gvc,g);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizContext_freeLayout(Ctx *ctx,knh_sfp_t *sfp)
{
  GVC_t *gvc = (GVC_t *)p_cptr(sfp[0]);
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[1]);
  gvFreeLayout(gvc,g);
  KNH_RETURN_void(ctx,sfp);
}

/*---------------------------Class GraphvizGraph-----------------------------*/
/*
static void knh_graph_gfree(Ctx *ctx, knh_Glue_t *g)
{
  Agraph_t *graph = (Agraph_t *)g->ptr;
  agclose(graph);
}
*/
METHOD GraphvizGraph_new(Ctx *ctx,knh_sfp_t *sfp)
{
  char *name = String_to_(sfp[1]);
  int kind = p_int(sfp[2]);
  Agraph_t *g = agopen(name,kind);
  //  knh_Glue_init(ctx,sfp[0].glue,g,knh_graph_gfree);
  knh_Glue_init(ctx,sfp[0].glue,g,NULL);
  KNH_RETURN(ctx,sfp,sfp[0].o);
}

METHOD GraphvizGraph_free(Ctx *ctx,knh_sfp_t *sfp)
{
  Agraph_t *graph = (Agraph_t *)p_cptr(sfp[0]);
  agclose(graph);
  KNH_RETURN_void(ctx,sfp);
}
  
METHOD GraphvizGraph_makeSubGraph(Ctx *ctx,knh_sfp_t *sfp)
{
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[0]);
  char* name = String_to_(sfp[1]);
  Agraph_t *ret = agsubg(g,name);
  KNH_RETURN(ctx,sfp,new_Glue(ctx,"graphviz.GraphvizGraph",ret,NULL));
}

METHOD GraphvizGraph_set(Ctx *ctx,knh_sfp_t *sfp)
{
  Agraph_t *graph = (Agraph_t *)p_cptr(sfp[0]);
  char *name = String_to_(sfp[1]);
  char *value = String_to_(sfp[2]);
  agsafeset(graph,name,value,NULL);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizGraph_newNode(Ctx *ctx,knh_sfp_t *sfp)
{
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[0]);
  char *name = String_to_(sfp[1]);
  Agnode_t *ret = agnode(g,name);
  KNH_RETURN(ctx,sfp,new_Glue(ctx,"graphviz.GraphvizNode",ret,NULL));
}

METHOD GraphvizGraph_newEdge(Ctx *ctx,knh_sfp_t *sfp)
{
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[0]);
  Agnode_t *start = (Agnode_t *)p_cptr(sfp[1]);
  Agnode_t *end = (Agnode_t *)p_cptr(sfp[2]);
  Agedge_t *ret = agedge(g,start,end);
  KNH_RETURN(ctx,sfp,new_Glue(ctx,"graphviz.GraphvizEdge",ret,NULL));
}

/*----------------------------Class GraphvizNode-----------------------------*/

METHOD GraphvizNode_delete(Ctx *ctx,knh_sfp_t *sfp)
{
  Agnode_t *this = (Agnode_t *)p_cptr(sfp[0]);
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[1]);
  agdelete(g,this);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizNode_set(Ctx *ctx,knh_sfp_t *sfp)
{
  Agnode_t *node = (Agnode_t *)p_cptr(sfp[0]);
  char *name = String_to_(sfp[1]);
  char *value = String_to_(sfp[2]);
  agsafeset(node,name,value,NULL);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizNode_copyAttributeTo(Ctx *ctx,knh_sfp_t *sfp)
{
  void *oldobj = (void *)p_cptr(sfp[0]);
  void *newobj = (void *)p_cptr(sfp[1]);
  agcopyattr(oldobj,newobj);
  KNH_RETURN_void(ctx,sfp);
}
/*---------------------------Class GraphvizEdge------------------------------*/

METHOD GraphvizEdge_delete(Ctx *ctx,knh_sfp_t *sfp)
{
  Agedge_t *this = (Agedge_t *)p_cptr(sfp[0]);
  Agraph_t *g = (Agraph_t *)p_cptr(sfp[1]);
  agdelete(g,(void*)this);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizEdge_set(Ctx *ctx,knh_sfp_t *sfp)
{
  Agedge_t *edge = (Agedge_t *)p_cptr(sfp[0]);
  char *name = String_to_(sfp[1]);
  char *value = String_to_(sfp[2]);
  agsafeset(edge,name,value,NULL);
  KNH_RETURN_void(ctx,sfp);
}

METHOD GraphvizEdge_copyAttributeTo(Ctx *ctx,knh_sfp_t *sfp)
{
  void *oldobj = (void *)p_cptr(sfp[0]);
  void *newobj = (void *)p_cptr(sfp[1]);
  agcopyattr(oldobj,newobj);
  KNH_RETURN_void(ctx,sfp);
}

/*----------------------------- init-------------------------------*/

KNH_EXPORTS(int) init(Ctx *ctx)
{
   KNH_NOTICE(ctx, "loading graphviz..");
   knh_loadIntConstData(ctx,IntConstData);
   return 1;
}

#ifdef __cplusplus
}
#endif
