#include <konoha.h>
#include <rasqal.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================= */
static
void knh_rasqal_world_gfree(Ctx *ctx, knh_Glue_t *g)
{
  rasqal_free_world((rasqal_world*)g->ptr);
}

/* ----------------------------------------------------------------------- */
/* @method This! *rasqal_new_world() */

METHOD Rasqal_new(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_world *world = rasqal_new_world();
  knh_Glue_init(ctx, sfp[0].glue, world, knh_rasqal_world_gfree);
  KNH_RETURN(ctx, sfp, sfp[0].o);
}

/* ======================================================================= */
static
void knh_rasqal_query_gfree(Ctx *ctx, knh_Glue_t *g)
{
  rasqal_free_query((rasqal_query*)g->ptr);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_new_query() */

METHOD Rasqal_createQuery(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_world *world = Glue_to(rasqal_world*, sfp[0]);
  char *query_lang   = String_to(char*, sfp[1]);

  rasqal_query* query = rasqal_new_query(world, query_lang, NULL);
  if (query == NULL) {
      KNH_WARNING(ctx, "rasqal_new_query");
  }
  else {
      knh_Glue_init(ctx, sfp[0].glue, query, knh_rasqal_query_gfree);
  }
  KNH_RETURN(ctx, sfp, sfp[0].o);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_prepare() */

METHOD RasqalQuery_prepare(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query *query = Glue_to(rasqal_query*, sfp[0]);
  char *query_string = String_to(char*, sfp[1]);
  rasqal_query_prepare(query, (const char*)query_string, NULL);
  KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================= */

static
void knh_rasqal_query_results_gfree(Ctx *ctx, knh_Glue_t *g)
{
  rasqal_free_query_results((rasqal_query_results*)g->ptr);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_execute() */

METHOD RasqalQuery_execute(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query *query = Glue_to(rasqal_query*, sfp[0]);
  rasqal_query_results *results = rasqal_query_execute(query);
  knh_Glue_init(ctx, sfp[0].glue, results, knh_rasqal_query_results_gfree);
  KNH_RETURN(ctx, sfp, sfp[0].o);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_results_get_count() */

METHOD RasqalQueryResults_getCount(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int count = rasqal_query_results_get_count(results);
  
  KNH_RETURN_Int(ctx, sfp, count);
}

/* ------------------------------------------------------------------------ */
/* @method This! Rasqal_query_results_next() */

METHOD RasqalQueryResults_next(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int ret = rasqal_query_results_next(results);
  int num = 0;
  if (ret == 0) {
    num = 1;
  }
  KNH_RETURN_Boolean(ctx, sfp, num);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_results_finished() */

METHOD RasqalQueryResults_finished(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int ret =  rasqal_query_results_finished(results);
  int num = 0;
  if (ret == 0) {
    num = 1;
  }
  KNH_RETURN_Boolean(ctx, sfp, num);
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_results_get_binding_value() */

METHOD RasqalQueryResults_getBindingValue(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int ofs = Int_to_(sfp[1]);
  rasqal_literal* value = rasqal_query_results_get_binding_value(results, ofs);
  char *val;
  if (value == NULL) {
      KNH_WARNING(ctx, "rasqal_query_results_get_binding_value");
      val = "";
  }
  else {
      val = rasqal_literal_as_string(value);
  }
  KNH_RETURN(ctx, sfp, new_String(ctx, B(val), NULL));
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_results_get_binding_name() */

METHOD RasqalQueryResults_getBindingName(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int ofs = Int_to_(sfp[1]);
  const unsigned char* name = rasqal_query_results_get_binding_name(results, ofs);
  KNH_RETURN(ctx, sfp, new_String(ctx, B(name), NULL));
}

/* ----------------------------------------------------------------------- */
/* @method This! Rasqal_query_results_get_bindings_count() */

METHOD RasqalQueryResults_getBindingsCount(Ctx *ctx, knh_sfp_t *sfp)
{
  rasqal_query_results *results = Glue_to(rasqal_query_results*, sfp[0]);
  int ret = rasqal_query_results_get_bindings_count(results);
  KNH_RETURN_Int(ctx, sfp, ret);
}

/* ======================================================================= */

#ifdef __cplusplus
}
#endif
