#include <mysql.h>

#define USE_bytes_last
#define USE_bytes_index
#define USE_bytes_subbytes
#define USE_bytes_slice
#define USE_bytes_parseint
#define USE_bytes_parsefloat
#define USE_new_bytes

#include <konoha.h>

#define MYSQL_USER_MAXLEN 16
#define MYSQL_PASS_MAXLEN 255
#define MYSQL_HOST_MAXLEN 255
#define MYSQL_DBNM_MAXLEN 64

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

static
void knh_mysql_perror(Ctx *ctx, MYSQL *db, int r)
{
	KNH_SYSLOG(ctx, LOG_WARNING, "MysqlError", "'%s'", mysql_error(db));
}

/* ------------------------------------------------------------------------ */
// url mysql://uname:passwd@host:port/dbname

static
knh_qconn_t *MYSQL_qopen(Ctx *ctx, knh_bytes_t url)
{
    char *puser, user[MYSQL_USER_MAXLEN+1] = {0};
    char *ppass, pass[MYSQL_PASS_MAXLEN+1] = {0}; // temporary defined
    char *phost, host[MYSQL_HOST_MAXLEN+1] = {0};
    unsigned int port = 0;
    char *pdbnm, dbnm[MYSQL_DBNM_MAXLEN+1] = {0};

	knh_bytes_t bt = knh_bytes_last(url, 8); // skip: mysql://
	const char *btstr = bt.text;
    sscanf(btstr, "%16[^ :\r\n\t]:%255[^ @\r\n\t]@%255[^ :\r\n\t]:%5d/%64[^ \r\n\t]",
		   (char*)&user, (char*)&pass, (char*)&host, &port, (char*)&dbnm); // consider to buffer over run

	puser = (user[0]) ? user : NULL;
	ppass = (pass[0]) ? pass : NULL;
	phost = (host[0]) ? host : NULL;
	pdbnm = (dbnm[0]) ? dbnm : NULL;
	
	MYSQL *db = mysql_init(NULL);
	if (!mysql_real_connect(db, phost, puser, ppass, pdbnm, port, NULL, 0)) {
		knh_mysql_perror(ctx, db, 0);
		mysql_close(db);
		db = NULL;
	}
	return (knh_qconn_t*)db;
}

/* ------------------------------------------------------------------------ */

static
int MYSQL_qnext(Ctx *ctx, knh_qcur_t *qcur, struct knh_ResultSet_t *rs)
{
	MYSQL_ROW row;
	if ((row = mysql_fetch_row((MYSQL_RES*) qcur))) {
		knh_ResultSet_initData(ctx, rs); /* DO NOT TOUCH */
		int i;
		knh_int_t ival;
		knh_float_t fval;
		for (i = 0; i < DP(rs)->column_size; i++) {
			if (row[i] == NULL) {
				knh_ResultSet_setNULL(ctx, rs, i);
				continue;
			}
			switch (DP(rs)->column[i].dbtype) {
			case MYSQL_TYPE_TINY:
			case MYSQL_TYPE_SHORT:
			case MYSQL_TYPE_INT24:
			case MYSQL_TYPE_LONG:
			case MYSQL_TYPE_LONGLONG:
			case MYSQL_TYPE_YEAR:
				knh_bytes_parseint(B(row[i]), &ival);
				knh_ResultSet_setInt(ctx, rs, i, ival);
				break;
			case MYSQL_TYPE_FLOAT:
			case MYSQL_TYPE_DOUBLE:
				knh_bytes_parsefloat(B(row[i]), &fval);
				knh_ResultSet_setFloat(ctx, rs, i, fval);
				break;
			case MYSQL_TYPE_NEWDECIMAL:
			case MYSQL_TYPE_STRING:
			case MYSQL_TYPE_VAR_STRING:
			case MYSQL_TYPE_TINY_BLOB:
			case MYSQL_TYPE_BLOB:
			case MYSQL_TYPE_MEDIUM_BLOB:
			case MYSQL_TYPE_LONG_BLOB:
			case MYSQL_TYPE_BIT:
			case MYSQL_TYPE_TIME:
			case MYSQL_TYPE_DATE:
			case MYSQL_TYPE_DATETIME:
			case MYSQL_TYPE_TIMESTAMP:
				knh_ResultSet_setText(ctx, rs, i, B(row[i]));
				break;
			case MYSQL_TYPE_NULL:
			default:
				KNH_SYSLOG(ctx, LOG_WARNING, "mysql", "mysql_qnext(dbtype)='unknown datatype [%d]'", DP(rs)->column[i].dbtype);
				knh_ResultSet_setNULL(ctx, rs, i);
				break;
			}
		}
		return 1; /* CONTINUE */
	}
	return 0;  /* NOMORE */
}

/* ------------------------------------------------------------------------ */

static
knh_qcur_t *MYSQL_query(Ctx *ctx, knh_qconn_t *hdr, knh_bytes_t sql, knh_ResultSet_t *rs)
{
	MYSQL_RES *res = NULL;
	if (hdr == NULL) {
		/* return NULL */
	}
	else if (rs == NULL) {
		/* Connection.exec */
		int r = mysql_query((MYSQL*)hdr, sql.text);
		if(r > 0) {
			knh_mysql_perror(ctx, (MYSQL*)hdr, r);
		}
	}
	else {
		/* Connection.query */
		int r = mysql_query((MYSQL*)hdr, sql.text);
		if (r > 0) { // QUERY ERROR
			knh_mysql_perror(ctx, (MYSQL*)hdr, r);
		}
		else {
			res = mysql_store_result((MYSQL*)hdr);
			if (res == NULL) { // NULL RESULT
				knh_mysql_perror(ctx, (MYSQL*)hdr, 0);
			}
			else {
				knh_ResultSet_initColumn(ctx, rs, (size_t)mysql_num_fields(res));
				int i = 0;
				MYSQL_FIELD *field = NULL;
				while((field = mysql_fetch_field(res))) {
					DP(rs)->column[i].dbtype = field->type;
					knh_String_t *s = ctx->api->new_String(ctx, field->name);
					knh_ResultSet_setName(ctx, rs, i, s);
					i++;
				}
			}
		}
	}
	return (knh_qcur_t *) res;
}

/* ------------------------------------------------------------------------ */

static
 void MYSQL_qclose(Ctx *ctx, knh_qconn_t *hdr)
{
	mysql_close((MYSQL*)hdr);
}

/* ------------------------------------------------------------------------ */

static
void MYSQL_qfree(knh_qcur_t *qcur)
{
	if (qcur != NULL) {
		MYSQL_RES *res = (MYSQL_RES*)qcur;
		mysql_free_result(res);
	}
}

/* ------------------------------------------------------------------------ */

static knh_QueryDSPI_t DB__mysql = {
	K_DSPI_QUERY,
	"mysql",
	MYSQL_qopen,
	MYSQL_query,
	MYSQL_qclose,
	MYSQL_qnext,
	MYSQL_qfree
};

KNHAPI(int) kcheck(void)
{
	return K_BUILDID;
}

KNHAPI(void) init(Ctx *ctx, knh_PackageLoaderAPI_t *kapi, char *dname, int isOVERRIDE)
{
	if (knh_isSelectedDSPI(dname, "mysql")) {
		kapi->addQueryDSPI(ctx, "mysql", &DB__mysql, isOVERRIDE);
	}
}

#ifdef __cplusplus 
}
#endif
