<?php
/*
  $Id: account_history_info.php,v 1.2 2005/08/19 09:48:11 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  if (!isset($HTTP_GET_VARS['order_id'])) {
    tep_redirect(tep_href_link(FILENAME_HISTORY, '', 'SSL'));
  }
  
  $customer_number_query = tep_db_query("select customers_id from " . TABLE_ORDERS . " where orders_id = '". tep_db_input(tep_db_prepare_input($HTTP_GET_VARS['order_id'])) . "'");
  $customer_number = tep_db_fetch_array($customer_number_query);
  if ($customer_number['customers_id'] != $customer_id) {
    tep_redirect(tep_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_ACCOUNT_HISTORY_INFO);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_3, tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $HTTP_GET_VARS['order_id'], 'SSL'));

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order($HTTP_GET_VARS['order_id']);
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
<link rel="stylesheet" type="text/css" href="general.css">
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_ACCOUNT_HISTORY_INFO, 0, strrpos(FILENAME_ACCOUNT_HISTORY_INFO, '.'));?>.css">
</head>
<body>
<div id="bodyWrapper">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table id="contents">
  <tr>
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
<!-- body_text //-->
    <td id="mainContents">
      <h1 class="pageHeading"><?php echo HEADING_TITLE; ?></h1>
      <table id="accountHistoryInfoStatus">
        <tr>
<?php
  if (KN_CFG_USE_ORDER_HISTORY == 'true') {
?>
          <td class="accountHistoryInfoStatusCol01"><?php echo sprintf(HEADING_ORDER_NUMBER, $HTTP_GET_VARS['order_id']); ?></td>
          <td class="accountHistoryInfoStatusCol02"><?php echo $order->info['orders_status']; ?></td>
<?php
  } else {
?>
          <td colspan="2" class="accountHistoryInfoStatusCol01"><?php echo sprintf(HEADING_ORDER_NUMBER, $HTTP_GET_VARS['order_id']); ?></td>
<?php
  }
?>
        </tr>
        <tr>
          <td class="accountHistoryInfoStatusCol01"><?php echo HEADING_ORDER_DATE . ' ' . tep_date_long($order->info['date_purchased']); ?></td>
          <td class="accountHistoryInfoStatusCol02"><?php echo HEADING_ORDER_TOTAL . ' ' . $order->info['total']; ?></td>
        </tr>
      </table>

      <table id="accountHistoryInfoOrders">
<?php
  if (sizeof($order->info['tax_groups']) > 1) {
?>
      <thead>
        <tr>
          <th class="accountHistoryInfoOrdersProductsCol" colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
          <th class="accountHistoryInfoOrdersTaxCol"><?php echo HEADING_TAX; ?></th>
          <th class="accountHistoryInfoOrdersPriceCol"><?php echo HEADING_TOTAL; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
  } else {
?>
      <thead>
        <tr>
          <th class="accountHistoryInfoOrdersProductsCol" colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
          <th class="accountHistoryInfoOrdersPriceCol"><?php echo HEADING_TOTAL; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
  }

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    echo '        <tr>' . "\n" .
         '          <td class="accountHistoryInfoOrdersQuantityCol">' . $order->products[$i]['qty'] . 'x</td>' . "\n" .
         '          <td class="accountHistoryInfoOrdersProductsCol"><span class="pName">' . $order->products[$i]['name'] . "</span>";
    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        echo '<br><span class="productOptions"> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'] . '</span>';
      }
    }

    echo '</td>' . "\n";
    echo '          <td class="accountHistoryInfoOrdersDescriptionCol">';
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      echo '<span class="pSubtitle">' . $order->products[$i]['subtitle'] . '</span> ';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      echo '<span class="pSeriesTitle">' . $order->products[$i]['series_title'] . '</span> ';
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      echo '<span class="pAuthor">' . $order->products[$i]['author'] . '</span> ';
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      echo '<span class="pPublishers">' . $order->products[$i]['publishers'] . '</span> ';
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      echo '<span class="pVolume">' . $order->products[$i]['volume'] . '</span> ';
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      echo '<span class="pPublished">' . $order->products[$i]['published'] . '</span> ';
    }
    echo '<span class="pDescription">' . $order->products[$i]['description'] . '</span></td>' . "\n";

    if (sizeof($order->info['tax_groups']) > 1) echo '          <td class="accountHistoryInfoOrdersTaxCol">' . tep_display_tax_value($order->products[$i]['tax']) . '%</td>' . "\n";

    echo '          <td class="accountHistoryInfoOrdersPriceCol"><span class="pPrice">' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . '</span></td>' . "\n" .
         '        </tr>' . "\n";
  }

  if (sizeof($order->info['tax_groups']) > 1) {
    echo '        <tr>' . "\n";
    echo '          <td colspan="5"><table id="accountHistoryInfoOrdersTotal">' . "\n";
  } else {
    echo '        <tr>' . "\n";
    echo '          <td colspan="4"><table id="accountHistoryInfoOrdersTotal">' . "\n";
  }
  for ($i=0, $n=sizeof($order->totals); $i<$n; $i++) {
    if (($order->totals[$i]['class'] == 'ot_addition') && ($order->totals[$i]['value'] == 0)) continue;
    if (($order->totals[$i]['class'] == 'ot_discount') && ($order->totals[$i]['value'] == 0)) continue;
    echo '        <tr>' . "\n" .
           '          <td class="accountHistoryInfoOrdersTotalTitle">' . $order->totals[$i]['title'] . '</td>' . "\n" .
           '          <td class="accountHistoryInfoOrdersTotalText">' . $order->totals[$i]['text'] . '</td>' . "\n" .
           '        </tr>' . "\n";
  }
  echo "      </table></td>\n";
  echo '        </tr>' . "\n";
?>
      </tbody>
      </table>
      
      <h3><?php echo HEADING_SHIPPING_AND_PAYMENT_INFORMATION; ?></h3>
      <table id="accountHistoryInfoShippingPayment">
        <tr>
          <td id="accountHistoryInfoShipping"><table>
<?php
  if ($order->delivery != false) {
?>
            <tr><td class="tableHeading"><?php echo HEADING_DELIVERY_ADDRESS; ?></td></tr>
            <tr><td><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br>'); ?></td></tr>
<?php
  }
  if ($order->info['shipping_method']) {
?>
            <tr><td class="tableHeading"><?php echo HEADING_SHIPPING_METHOD; ?></td></tr>
            <tr><td><?php echo $order->info['shipping_method']; ?></td></tr>
<?php
    }
?>
          </table></td>
          <td id="accountHistoryInfoPayment"><table>
            <tr><td class="tableHeading"><?php echo HEADING_BILLING_ADDRESS; ?></td></tr>
            <tr><td><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br>'); ?></td></tr>
<?php
  if ($order->info['payment_method']) {
?>
            <tr><td class="tableHeading"><?php echo HEADING_PAYMENT_METHOD; ?></td></tr>
            <tr><td><?php echo $order->info['payment_method']; ?></td></tr>
<?php
  }
?>
          </table></td>
        </tr>
      </table>

<?php
  if (KN_CFG_USE_ORDER_HISTORY == 'true') {
?>
      <h3><?php echo HEADING_ORDER_HISTORY; ?></h3>
      <table id="accountHistoryInfoOrderHistory">
<?php
    $statuses_query = tep_db_query("select os.orders_status_name, osh.date_added, osh.comments from " . TABLE_ORDERS_STATUS . " os, " . TABLE_ORDERS_STATUS_HISTORY . " osh where osh.orders_id = '" . $HTTP_GET_VARS['order_id'] . "' and osh.orders_status_id = os.orders_status_id and os.language_id = '" . $languages_id . "' order by osh.date_added");
    while ($statuses = tep_db_fetch_array($statuses_query)) {
      echo '        <tr>' . "\n" .
             '          <td class="accountHistoryInfoOrderHistoryCol01">' . tep_date_short($statuses['date_added']) . '</td>' . "\n" .
             '          <td class="accountHistoryInfoOrderHistoryCol02">' . $statuses['orders_status_name'] . '</td>' . "\n" .
             '          <td class="accountHistoryInfoOrderHistoryCol03">' . (empty($statuses['comments']) ? '&nbsp;' : nl2br(htmlspecialchars($statuses['comments']))) . '</td>' . "\n" .
             '        </tr>' . "\n";
    }
?>
      </table>
<?php
  }
?>
<?php
  if (DOWNLOAD_ENABLED == 'true') include(DIR_WS_MODULES . 'downloads.php');
?>
      <table>
        <tr class="buttonLine">
          <td class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ACCOUNT_HISTORY, tep_get_all_get_params(array('order_id')), 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></td>
        </tr>
      </table>
    </td>
<!-- body_text_eof //-->
<!-- right_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- right_navigation_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
