<?php
/*
  $Id: orders.php,v 1.2 2006/03/27 04:49:25 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  include(DIR_WS_CLASSES . 'order.php');

  require(DIR_WS_CLASSES . 'currencies.php');
  $currencies = new currencies();

  $orders_statuses = array();
  $orders_status_array = array();
  $orders_status_query = tep_db_query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . $languages_id . "'");
  while ($orders_status = tep_db_fetch_array($orders_status_query)) {
    $orders_statuses[] = array('id' => $orders_status['orders_status_id'],
                               'text' => $orders_status['orders_status_name']);
    $orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
  }

  switch ($HTTP_GET_VARS['action']) {
    case 'deleteconfirm':
      // ǡ
      $oID = tep_db_prepare_input($HTTP_GET_VARS['oID']);
      tep_remove_order($oID, $HTTP_POST_VARS['restock']);

      tep_redirect(tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action'))));
      break;
    case 'update':
      // ǡ
      $oID = tep_db_prepare_input($HTTP_GET_VARS['oID']);
      $status = tep_db_prepare_input($HTTP_POST_VARS['status']);
      $comments = '';

      $order_updated = false;
      $check_status_query = tep_db_query("select customers_name, customers_email_address, orders_status, date_purchased, currency, currency_value from " . TABLE_ORDERS . " where orders_id = '" . tep_db_input($oID) . "'");
      $check_status = tep_db_fetch_array($check_status_query);
      $orders_currency = $check_status['currency'];
      $orders_currency_value = $check_status['currency_value'];
      $new_subtotal = 0;
      $new_tax = 0;
      $shown_price = 0;
      for ($i = 0; $i < count($HTTP_POST_VARS['opID']); $i++) {
        // orders_productsι
        $opID = $HTTP_POST_VARS['opID'][$i];
        $orders_products_query = tep_db_query("select products_name, final_price, products_tax, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_products_id = '" . tep_db_input($opID) . "'");
        $orders_products = tep_db_fetch_array($orders_products_query);
        $old_products_qty = $orders_products['products_quantity'];
        $products_tax = $orders_products['products_tax'];
        $new_products_qty = tep_db_prepare_input($HTTP_POST_VARS['products_qty'][$i]);
        if (!is_numeric($new_products_qty) || $new_products_qty < 0) {
        	$new_products_qty = $old_products_qty;
        }
        $shown_price = tep_add_tax($orders_products['final_price'], $products_tax) * $new_products_qty;
        if ($shown_price != 0) {
          if (DISPLAY_PRICE_WITH_TAX == 'true') {
            $new_tax += $shown_price - ($shown_price / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));
          } else {
            $new_tax += ($products_tax / 100) * $shown_price;
          }
        }
        $new_subtotal += $shown_price;
        if ($new_products_qty != $old_products_qty) {
         	tep_db_query("update " . TABLE_ORDERS_PRODUCTS . " set products_quantity = '" . tep_db_input($new_products_qty) . "' where orders_products_id = '" . tep_db_input($opID) . "'");
         	$comments .= $orders_products['products_name'] . ' : ' . TABLE_HEADING_QUANTITY . '  ' . $old_products_qty . ' => ' . $new_products_qty . "\n";
          $order_updated = true;
        }
      }
      
      $ot_total_exist = false;
      $ot_total_value = 0;
      for ($i = 0; $i < count($HTTP_POST_VARS['otID']); $i++) {
      	// orders_totalι
       	$otID = $HTTP_POST_VARS['otID'][$i];
        $orders_total_query = tep_db_query("select title, text, value, class from " . TABLE_ORDERS_TOTAL . " where orders_total_id = '" . tep_db_input($otID) . "'");
        $orders_total = tep_db_fetch_array($orders_total_query);
        switch ($HTTP_POST_VARS['totals_class'][$i]) {
        case 'ot_subtotal':
          // 
          if ($new_subtotal != $orders_total['value']) {
        	   $new_subtotal_text = $currencies->format($new_subtotal, true, $orders_currency, $orders_currency_value);
            tep_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . tep_db_input($new_subtotal_text) . "', value = '" . tep_db_input($new_subtotal) .  "' where orders_total_id = '" . tep_db_input($otID) . "'");
            $order_updated = true;
          }
          $ot_total_value += $new_subtotal;
          break;
        case 'ot_tax':
          // Ƕ
          $input_tax = tep_db_prepare_input($HTTP_POST_VARS['totals_value'][$i]);
          if (!is_numeric($input_tax) || $input_tax < 0) {
            $input_tax = $orders_total['value'];
          }
          // Ϥˤѹͥ褹
          $tax_mod = false;
        	 if ($input_tax != $orders_total['value']) {
        	   $new_tax = $input_tax;
        	   $tax_mod = true;
        	 }
          if ($new_tax != $orders_total['value']) {
        	   $new_tax_text = $currencies->format($new_tax, true, $orders_currency, $orders_currency_value);
            tep_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . tep_db_input($new_tax_text) . "', value = '" . tep_db_input($new_tax) .  "' where orders_total_id = '" . tep_db_input($otID) . "'");
            if ($tax_mod) {
              $comments .= strip_tags($orders_total['title']) . '  ' . (int)$orders_total['value'] . ' => ' . (int)$new_tax . "\n";
            }
            $order_updated = true;
        	 }
          if ($new_subtotal == 0) {
            $new_tax = 0;
          }
          $ot_total_value += $new_tax;
          break;
        case 'ot_total':
          //  ʤǤϹ׹Ԥ¸ߥåΤߡ
          $ot_total_exist = true;
          $ot_total_otID = $otID;
          break;
        default:
          // 嵭ʳι׹Թ
          $ot_updated = false;
          $ot_new_title = tep_db_prepare_input($HTTP_POST_VARS['totals_title'][$i]);
          $ot_new_value = tep_db_prepare_input($HTTP_POST_VARS['totals_value'][$i]);
          if (!is_numeric($ot_new_value) || $ot_new_value < 0) {
        	  $ot_new_value = $orders_total['value'];
          }
          if ($new_subtotal == 0) {
            $ot_new_value = 0;
          }
          if ($ot_new_title != $orders_total['title']) {
            $comments .= strip_tags($orders_total['title']) . ' => ' . $ot_new_title . "\n";
        	   $ot_updated = true;
        	   $ot_title = $ot_new_title;
          } else {
            $ot_title = $orders_total['title'];
          }
          if ($ot_new_value != $orders_total['value']) {
        	   $ot_text = $currencies->format($ot_new_value, true, $orders_currency, $orders_currency_value);
            $comments .= strip_tags($ot_title) . '  ' . (int)$orders_total['value'] . ' => ' . (int)$ot_new_value . "\n";
        	   $ot_updated = true;
          } else {
            $ot_text = $currencies->format($orders_total['value'], true, $orders_currency, $orders_currency_value);
            tep_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . tep_db_input($ot_text) . "' where orders_total_id = '" . tep_db_input($otID) . "'");
          }
          if ($ot_updated) {
            tep_db_query("update " . TABLE_ORDERS_TOTAL . " set title = '" . tep_db_input($ot_title) . "', text = '" . tep_db_input($ot_text) . "', value = '" . tep_db_input($ot_new_value) .  "' where orders_total_id = '" . tep_db_input($otID) . "'");
            $order_updated = true;
          }
          if ($HTTP_POST_VARS['totals_class'][$i] == 'ot_discount') {
            $ot_total_value -= $ot_new_value;
            if ($ot_total_value < 0) {
              $ot_total_value = 0;
            }
          } else {
            $ot_total_value += $ot_new_value;
          }
          break;
        }
      }
      if ($ot_total_exist) {
        // ׹Ԥι
        $new_total_text = '<b>' . $currencies->format($ot_total_value, true, $orders_currency, $orders_currency_value) . '</b>';
        tep_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . tep_db_input($new_total_text) . "', value = '" . tep_db_input($ot_total_value) .  "' where orders_total_id = '" . tep_db_input($ot_total_otID) . "'");
      }

      if ($check_status['orders_status'] != $status) {
        // ơι
        tep_db_query("update " . TABLE_ORDERS . " set orders_status = '" . tep_db_input($status) . "' where orders_id = '" . tep_db_input($oID) . "'");
        $comments .= TABLE_HEADING_STATUS . ' : ' . $orders_status_array[$check_status['orders_status']] . ' => ' . $orders_status_array[$status];
        $order_updated = true;
      }
      
      if ($order_updated == true) {
        // ѹι
        tep_db_query("update " . TABLE_ORDERS . " set last_modified = now() where orders_id = '" . tep_db_input($oID) . "'");
        $customer_notified = '0';
        tep_db_query("insert into " . TABLE_ORDERS_STATUS_HISTORY . " (orders_id, orders_status_id, date_added, customer_notified, comments) values ('" . tep_db_input($oID) . "', '" . tep_db_input($status) . "', now(), '" . $customer_notified . "', '" . tep_db_input($comments)  . "')");
      }

      if ($order_updated) {
        $messageStack->add_session(SUCCESS_ORDER_UPDATED, 'success');
      } else {
        $messageStack->add_session(WARNING_ORDER_NOT_UPDATED, 'warning');
      }
      tep_redirect(tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=edit'));
      break;
    case 'email_confirm':
      // ᡼Ƴǧ
      $oID = tep_db_prepare_input($HTTP_GET_VARS['oID']);
      $order = new order($oID);
      $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
      $notify_comments = '';
      switch ($HTTP_POST_VARS['email_type']) {
        case '2':                           // ʧ˥᡼
        case '3':                           // ʸʧ˥᡼
        case '6':			// ˥᡼
        case '7':			// ʥ쥸åȡ˥᡼
          // ߸ˤꥹ
          $reservation_flg = false;
          $reservation_list = EMAIL_TEXT_RESERVATION . "\n" . EMAIL_SEPARATOR . "\n";
          if ($comments) {
            $notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments) . "\n\n";
          }
          for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
            if ($order->products[$i]['qty'] > 0) {
              $reservation_flg = true;
              $reservation_list .= EMAIL_TEXT_PRODUCTS . '  ' . $order->products[$i]['name'];
              if (sizeof($order->products[$i]['attributes']) > 0) {
                for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j++) {
                  $reservation_list .= ' - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
                }
              }
              $reservation_list .= "\n";
              if (KN_CFG_USE_SUBTITLE == 'true') {
                $reservation_list .= EMAIL_TEXT_SUBTITLE . '  ' . $order->products[$i]['subtitle'] . "\n";
              }
              if (KN_CFG_USE_SERIES_TITLE == 'true') {
                $reservation_list .= EMAIL_TEXT_SERIES_TITLE . '  ' . $order->products[$i]['series_title'] . "\n";
              }
              if (KN_CFG_USE_AUTHOR == 'true') {
                $reservation_list .= EMAIL_TEXT_AUTHOR . '  ' . $order->products[$i]['author'] . "\n";
              }
              if (KN_CFG_USE_VOLUME == 'ture') {
                $reservation_list .= EMAIL_TEXT_VOLUME . '  ' . $order->products[$i]['volume'] . "\n";
              }
              if (KN_CFG_USE_ISBN == 'true') {
                $reservation_list .= EMAIL_TEXT_ISBN . '  ' . $order->products[$i]['isbn'] . "\n";
              }
              if (KN_CFG_USE_PUBLISHERS == 'true') {
                $reservation_list .= EMAIL_TEXT_PUBLISHERS . '  ' . $order->products[$i]['publishers'] . "\n";
              }
              if (KN_CFG_USE_PUBLISHED == 'ture') {
                $reservation_list .= EMAIL_TEXT_PUBLISHED . '  ' . $order->products[$i]['published'] . "\n";
              }
              $reservation_list .= EMAIL_TEXT_DESCRIPTION . '   ' . $order->products[$i]['description'] . "\n";
              $reservation_list .= EMAIL_TEXT_MODEL . ' ' . $order->products[$i]['model'] . "\n";
              $reservation_list .= EMAIL_TEXT_QUANTITY . '   ' . $order->products[$i]['qty'] . "\n";
              $reservation_list .= EMAIL_TEXT_PRICE . '   ' . $currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . "\n";
              $reservation_list .= EMAIL_SEPARATOR . "\n";
            }
          }
          // ߸ˤʤꥹ
          $no_stock_flg = false;
          $no_stock_array = array();
          $no_stock_list = EMAIL_TEXT_NO_STOCK . "\n" . EMAIL_SEPARATOR . "\n";
          for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
            if ($order->products[$i]['qty'] <= 0) {
            	$no_stock_flg = true;
              $no_stock_array[] = $order->products[$i]['name'];
              $no_stock_list .= EMAIL_TEXT_PRODUCTS . '  ' . $order->products[$i]['name'];
              if (sizeof($order->products[$i]['attributes']) > 0) {
                for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j++) {
                  $no_stock_list .= ' - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
                }
              }
              $no_stock_list .= "\n";
              if (KN_CFG_USE_SUBTITLE == 'true') {
                $no_stock_list .= EMAIL_TEXT_SUBTITLE . '  ' . $order->products[$i]['subtitle'] . "\n";
              }
              if (KN_CFG_USE_SERIES_TITLE == 'true') {
                $no_stock_list .= EMAIL_TEXT_SERIES_TITLE . '  ' . $order->products[$i]['series_title'] . "\n";
              }
              if (KN_CFG_USE_AUTHOR == 'true') {
                $no_stock_list .= EMAIL_TEXT_AUTHOR . '  ' . $order->products[$i]['author'] . "\n";
              }
              if (KN_CFG_USE_VOLUME == 'true') {
                $no_stock_list .= EMAIL_TEXT_VOLUME . '  ' . $order->products[$i]['volume'] . "\n";
              }
              if (KN_CFG_USE_ISBN == 'true') {
                $no_stock_list .= EMAIL_TEXT_ISBN . '  ' . $order->products[$i]['isbn'] . "\n";
              }
              if (KN_CFG_USE_PUBLISHERS == 'true') {
                $no_stock_list .= EMAIL_TEXT_PUBLISHERS . '  ' . $order->products[$i]['publishers'] . "\n";
              }
              if (KN_CFG_USE_PUBLISHED == 'true') {
                $no_stock_list .= EMAIL_TEXT_PUBLISHED . '  ' . $order->products[$i]['published'] . "\n";
              }
              $no_stock_list .= EMAIL_TEXT_DESCRIPTION . '   ' . $order->products[$i]['description'] . "\n";
              $no_stock_list .= EMAIL_TEXT_MODEL . ' ' . $order->products[$i]['model'] . "\n";
              $no_stock_list .= EMAIL_TEXT_QUANTITY . '   ' . $order->products[$i]['qty'] . "\n";
              $no_stock_list .= EMAIL_TEXT_PRICE . '   ' . $currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . "\n";
              $no_stock_list .= EMAIL_SEPARATOR . "\n";
            }
          }
          
          if ($reservation_flg && $no_stock_flg) {
            $products_list = $reservation_list . "\n" . $no_stock_list . "\n";
            for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
              if (($order->totals[$i]['class'] == 'ot_discount') && ($order->totals[$i]['value'] == 0)) { continue; }
              if (($order->totals[$i]['class'] == 'ot_addition') && ($order->totals[$i]['value'] == 0)) { continue; }
              $products_list .= strip_tags($order->totals[$i]['title']) . ' ' . strip_tags($order->totals[$i]['text']) . "\n";
            }
          } elseif ($reservation_flg) {
            $products_list = $reservation_list . "\n";
            for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
              if (($order->totals[$i]['class'] == 'ot_discount') && ($order->totals[$i]['value'] == 0)) { continue; }
              if (($order->totals[$i]['class'] == 'ot_addition') && ($order->totals[$i]['value'] == 0)) { continue; }
              $products_list .= strip_tags($order->totals[$i]['title']) . ' ' . strip_tags($order->totals[$i]['text']) . "\n";
            }
          } else {
            $products_list = $no_stock_list. "\n";
            $HTTP_POST_VARS['email_type'] = 5;
          }
          switch ($HTTP_POST_VARS['email_type']) {
            case '2':
              // ʧ˥᡼
              $shop_info_key = 'SHOP_INFO_EMAIL_ORDER_RECEIVED_REPLY';
              break;
            case '3':
              // ʸʧ˥᡼
              $shop_info_key = 'SHOP_INFO_EMAIL_SEND_PRODUCTS_REPLY';
              break;
            case '5':
              // ڤ줪ͤӥ᡼
              $shop_info_key = 'SHOP_INFO_EMAIL_SOLD_OUT_REPLY';
              break;
            case '6':
              // ˥᡼
              $shop_info_key = 'SHOP_INFO_EMAIL_CODT_PAYMENT_REPLY';
              break;
            case '7':
              // ʥ쥸åȡ˥᡼
              $shop_info_key = 'SHOP_INFO_EMAIL_CC_PAYMENT_REPLY';
              break;
          }
          $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, shop_info_value2, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = '" . $shop_info_key . "'");
          $shop_info = tep_db_fetch_array($shop_info_query);
          $email_subject = $shop_info['shop_info_title'];
          $email_text1 = $shop_info['shop_info_value'];
          $email_text2 = $shop_info['shop_info_value2'];
          $shop_info_query = tep_db_query("select shop_info_value from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_EMAIL_SIGNATURE'");
          $shop_info = tep_db_fetch_array($shop_info_query);
          $email_signature = $shop_info['shop_info_value'];

          $email_contents = $order->customer['name'] . $email_text1 . "\n\n" . $products_list . "\n" . $notify_comments . "\n" . $email_text2 . "\n" . $email_signature;
          $email_subject = $email_subject;
          $customer_notified = $HTTP_POST_VARS['email_type'];
          break;
      	case '4':                           // ߸˳ǧ᡼
          if ($HTTP_POST_VARS['notify_comments'] == 'on') {
            if ($comments) {
              $notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments) . "\n\n";
            }
          }
          $pending_list = EMAIL_SEPARATOR . "\n";
          for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
            $pending_list .= EMAIL_TEXT_PRODUCTS . '  ' . $order->products[$i]['name'];
            if (sizeof($order->products[$i]['attributes']) > 0) {
              for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j++) {
                $pending_list .= ' - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
              }
            }
            $pending_list .= "\n";
            if (KN_CFG_USE_SUBTITLE == 'true') {
              $pending_list .= EMAIL_TEXT_SUBTITLE . '  ' . $order->products[$i]['subtitle'] . "\n";
            }
            if (KN_CFG_USE_SERIES_TITLE == 'true') {
              $pending_list .= EMAIL_TEXT_SERIES_TITLE . '  ' . $order->products[$i]['series_title'] . "\n";
            }
            if (KN_CFG_USE_AUTHOR == 'true') {
              $pending_list .= EMAIL_TEXT_AUTHOR . '  ' . $order->products[$i]['author'] . "\n";
            }
            if (KN_CFG_USE_VOLUME == 'true') {
              $pending_list .= EMAIL_TEXT_VOLUME . '  ' . $order->products[$i]['volume'] . "\n";
            }
            if (KN_CFG_USE_ISBN == 'true') {
              $pending_list .= EMAIL_TEXT_ISBN . '  ' . $order->products[$i]['isbn'] . "\n";
            }
            if (KN_CFG_USE_PUBLISHERS == 'true') {
              $pending_list .= EMAIL_TEXT_PUBLISHERS . '  ' . $order->products[$i]['publishers'] . "\n";
            }
            if (KN_CFG_USE_PUBLISHED == 'true') {
              $pending_list .= EMAIL_TEXT_PUBLISHED . '  ' . $order->products[$i]['published'] . "\n";
            }
            $pending_list .= EMAIL_TEXT_DESCRIPTION . '   ' . $order->products[$i]['description'] . "\n";
            $pending_list .= EMAIL_TEXT_MODEL . ' ' . $order->products[$i]['model'] . "\n";
            $pending_list .= EMAIL_TEXT_QUANTITY . '   ' . $order->products[$i]['qty'] . "\n";
            $pending_list .= EMAIL_TEXT_PRICE . '   ' . $currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . "\n";
            $pending_list .= EMAIL_SEPARATOR . "\n";
          }
          $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, shop_info_value2, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_EMAIL_PENDING_REPLY'");
          $shop_info = tep_db_fetch_array($shop_info_query);
          $email_subject = $shop_info['shop_info_title'];
          $email_text1 = $shop_info['shop_info_value'];
          $email_text2 = $shop_info['shop_info_value2'];
          $shop_info_query = tep_db_query("select shop_info_value from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_EMAIL_SIGNATURE'");
          $shop_info = tep_db_fetch_array($shop_info_query);
          $email_signature = $shop_info['shop_info_value'];

          $email_contents = $order->customer['name'] . $email_text1 . "\n\n" . $pending_list . "\n" . $notify_comments . "\n" . $email_text2 . "\n" . $email_signature;
          $email_subject = $email_subject;
          $customer_notified = '4';
          break;
      }
      break;
    case 'send_email':
      $oID = tep_db_prepare_input($HTTP_GET_VARS['oID']);
      $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
      $customer_name = tep_db_prepare_input($HTTP_POST_VARS['customer_name']) . EMAIL_HONORIFIC;
      $email_address = tep_db_prepare_input($HTTP_POST_VARS['email_address']);
      $email_subject = tep_db_prepare_input($HTTP_POST_VARS['email_subject']);
      $email_contents = tep_db_prepare_input($HTTP_POST_VARS['email_contents']);
      $customer_notified = tep_db_prepare_input($HTTP_POST_VARS['customer_notified']);

      tep_mail($customer_name, $email_address, $email_subject, nl2br($email_contents), STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);

      tep_db_query("insert into " . TABLE_ORDERS_STATUS_HISTORY . " (orders_id, orders_status_id, date_added, customer_notified, comments) values ('" . tep_db_input($oID) . "', '" . tep_db_input($status) . "', now(), '" . $customer_notified . "', '" . tep_db_input($comments)  . "')");

      tep_redirect(tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=edit'));
      break;
  }

  if ( ($HTTP_GET_VARS['action'] == 'edit') && ($HTTP_GET_VARS['oID']) ) {
    $oID = tep_db_prepare_input($HTTP_GET_VARS['oID']);

    $orders_query = tep_db_query("select orders_id from " . TABLE_ORDERS . " where orders_id = '" . tep_db_input($oID) . "'");
    $order_exists = true;
    if (!tep_db_num_rows($orders_query)) {
      $order_exists = false;
      $messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
    }
  }

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/kn_stylesheet.css">
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php
  require(DIR_WS_INCLUDES . 'header.php');
?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo BOX_WIDTH; ?>" valign="top"><table width="<?php echo BOX_WIDTH; ?>" class="knMenuBar">
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
    </table></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
  if ( ($HTTP_GET_VARS['action'] == 'edit') && ($order_exists) ) {
    $order = new order($oID);
?>
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
            <td class="pageHeading" align="right"><?php echo '<a href="' . tep_href_link(FILENAME_ORDERS_INVOICE, 'oID=' . $HTTP_GET_VARS['oID']) . '" TARGET="_blank">' . tep_image_button('button_invoice.gif', IMAGE_ORDERS_INVOICE) . '</a> <a href="' . tep_href_link(FILENAME_ORDERS_PACKINGSLIP, 'oID=' . $HTTP_GET_VARS['oID']) . '" TARGET="_blank">' . tep_image_button('button_packingslip.gif', IMAGE_ORDERS_PACKINGSLIP) . '</a> <a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('action'))) . '">' . tep_image_button('button_back.gif', IMAGE_BACK) . '</a>'; ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table width="100%" border="0" cellspacing="0" cellpadding="2">
          <tr>
            <td colspan="3"><?php echo tep_draw_separator(); ?></td>
          </tr>
          <tr>
            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr>
                <td class="main" valign="top"><b><?php echo ENTRY_CUSTOMER; ?></b></td>
<?php // 2003-06-06 add_telephone ?>
                <td class="main"><?php echo tep_address_format($order->customer['format_id'], $order->customer, 1, '&nbsp;', '<br>', FALSE); ?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo tep_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
              </tr>
              <tr>
                <td class="main"><b><?php echo ENTRY_TELEPHONE; ?></b></td>
                <td class="main"><?php echo $order->customer['telephone']; ?></td>
              </tr>
              <tr>
                <td class="main"><b><?php echo ENTRY_EMAIL_ADDRESS; ?></b></td>
                <td class="main"><?php echo '<a href="mailto:' . $order->customer['email_address'] . '"><u>' . $order->customer['email_address'] . '</u></a>'; ?></td>
              </tr>
            </table></td>
            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr>
                <td class="main" valign="top"><b><?php echo ENTRY_SHIPPING_ADDRESS; ?></b></td>
                <td class="main"><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, '&nbsp;', '<br>'); ?></td>
              </tr>
            </table></td>
            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr>
                <td class="main" valign="top"><b><?php echo ENTRY_BILLING_ADDRESS; ?></b></td>
                <td class="main"><?php echo tep_address_format($order->billing['format_id'], $order->billing, 1, '&nbsp;', '<br>'); ?></td>
              </tr>
            </table></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td><table border="0" cellspacing="0" cellpadding="2">
          <tr>
            <td class="main"><b><?php echo ENTRY_PAYMENT_METHOD; ?></b></td>
            <td class="main"><?php echo $order->info['payment_method']; ?></td>
          </tr>
<?php
    if ( (($order->info['cc_type']) || ($order->info['cc_owner']) || ($order->info['cc_number'])) ) {
?>
          <tr>
            <td colspan="2"><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
          </tr>
          <tr>
            <td class="main"><?php echo ENTRY_CREDIT_CARD_TYPE; ?></td>
            <td class="main"><?php echo $order->info['cc_type']; ?></td>
          </tr>
          <tr>
            <td class="main"><?php echo ENTRY_CREDIT_CARD_OWNER; ?></td>
            <td class="main"><?php echo $order->info['cc_owner']; ?></td>
          </tr>
          <tr>
            <td class="main"><?php echo ENTRY_CREDIT_CARD_NUMBER; ?></td>
            <td class="main"><?php echo $order->info['cc_number']; ?></td>
          </tr>
          <tr>
            <td class="main"><?php echo ENTRY_CREDIT_CARD_EXPIRES; ?></td>
            <td class="main"><?php echo $order->info['cc_expires']; ?></td>
          </tr>
<?php
    }
?>
        </table></td>
      </tr>
      <tr><?php echo tep_draw_form('email', FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=update'); ?>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr class="dataTableHeadingRow">
            <td class="dataTableHeadingContent" colspan="2"><?php echo TABLE_HEADING_PRODUCTS; ?></td>
            <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_PRODUCTS_MODEL; ?></td>
            <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_TAX; ?></td>
            <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_PRICE_EXCLUDING_TAX; ?></td>
            <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_PRICE_INCLUDING_TAX; ?></td>
            <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_TOTAL_EXCLUDING_TAX; ?></td>
            <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_TOTAL_INCLUDING_TAX; ?></td>
          </tr>
<?php
    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
      echo '          <tr class="dataTableRow">' . "\n" .
           '            <td class="dataTableContent" valign="top">' . tep_draw_input_field("products_qty[$i]", $order->products[$i]['qty'], 'size="2"') . tep_draw_hidden_field("opID[$i]", $order->products[$i]['opID']) . '</td>' . "\n" .
           '            <td class="dataTableContent" valign="top">' . $order->products[$i]['name'];

      if (sizeof($order->products[$i]['attributes']) > 0) {
        for ($j = 0, $k = sizeof($order->products[$i]['attributes']); $j < $k; $j++) {
          echo '<br><nobr><small>&nbsp;<i> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
          if ($order->products[$i]['attributes'][$j]['price'] != '0') echo ' (' . $order->products[$i]['attributes'][$j]['prefix'] . $currencies->format($order->products[$i]['attributes'][$j]['price'] * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . ')';
          echo '</i></small></nobr>';
        }
      }

      if ( DISPLAY_PRICE_WITH_TAX == 'true' ) {
          $price_with_tax = $currencies->format(
              tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']),
              true,
              $order->info['currency'], $order->info['currency_value']);
          $tprice_with_tax = $currencies->format(
              tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']) * $order->products[$i]['qty'],
              true,
              $order->info['currency'],
              $order->info['currency_value']);
      } else {
          $price_with_tax = $tprice_with_tax = '---';
      }

      echo '            </td>' . "\n" .
           '            <td class="dataTableContent" valign="top">' . $order->products[$i]['model'] . '</td>' . "\n" .
           '            <td class="dataTableContent" align="right" valign="top">' . tep_display_tax_value($order->products[$i]['tax']) . '%</td>' . "\n" .
           '            <td class="dataTableContent" align="right" valign="top"><b>' . $currencies->format($order->products[$i]['final_price'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
           '            <td class="dataTableContent" align="right" valign="top"><b>' . $price_with_tax . '</b></td>' . "\n" .
           '            <td class="dataTableContent" align="right" valign="top"><b>' . $currencies->format($order->products[$i]['final_price'] * $order->products[$i]['qty'],true,$order->info['currency'],$order->info['currency_value']) . '</b></td>' . "\n" .
           '            <td class="dataTableContent" align="right" valign="top"><b>' . $tprice_with_tax . '</b></td>' . "\n";
      echo '          </tr>' . "\n";
    }
?>
          <tr>
            <td align="right" colspan="8"><table border="0" cellspacing="0" cellpadding="2">
<?php
    for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
      switch ($order->totals[$i]['class']) {
        case 'ot_subtotal':
        case 'ot_total':
          echo '              <tr>' . "\n" .
                 '                <td align="right" class="smallText">' . $order->totals[$i]['title'] . '</td>' . "\n";
          echo '                <td align="right" class="smallText">' . tep_draw_hidden_field("otID[$i]", $order->totals[$i]['otID']) . tep_draw_hidden_field("totals_class[$i]", $order->totals[$i]['class']) . tep_draw_hidden_field("totals_value[$i]", $order->totals[$i]['value']) . $order->totals[$i]['text'] . '</td>' . "\n";
          echo '              </tr>' . "\n";
          break;
        default:
          echo '              <tr>' . "\n" .
                 '                <td align="right" class="smallText">' . tep_draw_input_field("totals_title[$i]", strip_tags($order->totals[$i]['title']), 'size="30"') . '</td>' . "\n";
          echo '                <td align="right" class="smallText">' . tep_draw_hidden_field("otID[$i]", $order->totals[$i]['otID']) . tep_draw_hidden_field("totals_class[$i]", $order->totals[$i]['class']) . $currencies->currencies[$order->info['currency']]['symbol_left'] . tep_draw_input_field("totals_value[$i]", number_format($order->totals[$i]['value'],$currencies->currencies[$order->info['currency']]['decimal_places'],'.',''), 'size="6"') . $currencies->currencies[$order->info['currency']]['symbol_right'] . '</td>' . "\n";
          echo '              </tr>' . "\n";
      }
    }
?>
            </table></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="main"><b><?php echo ENTRY_STATUS; ?></b> <?php echo tep_draw_pull_down_menu('status', $orders_statuses, $order->info['orders_status']); ?></td>
      </tr>
      <tr>
        <td valign="top"><?php echo tep_image_submit('button_update.gif', IMAGE_UPDATE); ?></td>
      </form></tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr><?php echo tep_draw_form('email', FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=email_confirm'); ?>
        <td class="main"><br><b><?php echo ENTRY_NOTIFY_CUSTOMER; ?></b></td>
      </tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
      </tr>
      <tr>
        <td class="main"><b><?php echo ENTRY_NOTIFY_COMMENTS; ?></b> <?php echo tep_draw_checkbox_field('notify_comments', '', true); ?></td>
      </tr>
      <tr>
        <td class="main"><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5'); ?></td>
      </tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
      </tr>
      <tr>
        <td class="main"><?php echo tep_draw_radio_field('email_type', '2', true) . '&nbsp;' . ENTRY_EMAIL_ORDER_RECEIVED_REPLY . '&nbsp;&nbsp;' . tep_draw_radio_field('email_type', '3') . '&nbsp;' . ENTRY_EMAIL_SEND_PRODUCTS_REPLY . '&nbsp;&nbsp;' . tep_draw_radio_field('email_type', '6') . '&nbsp;' . ENTRY_EMAIL_CODT_PAYMENT_REPLY . '&nbsp;&nbsp;' . tep_draw_radio_field('email_type', '7') . '&nbsp;' . ENTRY_EMAIL_CC_PAYMENT_REPLY . '&nbsp;&nbsp;' . tep_draw_radio_field('email_type', '4') . '&nbsp;' . ENTRY_EMAIL_PENDING_REPLY; ?></td>
      </tr>
      <tr>
        <td valign="top"><?php echo tep_image_submit('button_send_mail.gif', IMAGE_SEND_EMAIL); ?></td>
      </form></tr>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="main"><table border="1" cellspacing="0" cellpadding="5">
          <tr>
            <td class="smallText" align="center"><b><?php echo TABLE_HEADING_DATE_ADDED; ?></b></td>
            <td class="smallText" align="center"><b><?php echo TABLE_HEADING_CUSTOMER_NOTIFIED; ?></b></td>
            <td class="smallText" align="center"><b><?php echo TABLE_HEADING_COMMENTS; ?></b></td>
          </tr>
<?php
    $orders_history_query = tep_db_query("select orders_status_id, date_added, customer_notified, comments from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . tep_db_input($oID) . "' order by date_added");
    if (tep_db_num_rows($orders_history_query)) {
      while ($orders_history = tep_db_fetch_array($orders_history_query)) {
        echo '          <tr>' . "\n" .
             '            <td class="smallText" align="center">' . tep_datetime_short($orders_history['date_added']) . '</td>' . "\n" .
             '            <td class="smallText" align="center">';
        switch ($orders_history['customer_notified']) {
        	case '1':
            echo ENTRY_EMAIL_ORDER_AUTO_REPLY . "</td>\n";
            break;
        	case '2':
            echo ENTRY_EMAIL_ORDER_RECEIVED_REPLY . "</td>\n";
            break;
        	case '3':
            echo ENTRY_EMAIL_SEND_PRODUCTS_REPLY . "</td>\n";
            break;
        	case '4':
            echo ENTRY_EMAIL_PENDING_REPLY . "</td>\n";
            break;
        	case '5':
            echo ENTRY_EMAIL_SOLD_OUT_REPLY . "</td>\n";
            break;
        	case '6':
            echo ENTRY_EMAIL_CODT_PAYMENT_REPLY . "</td>\n";
            break;
        	case '7':
            echo ENTRY_EMAIL_CC_PAYMENT_REPLY . "</td>\n";
            break;
         default:
            echo "---</td>\n";
            break;
        }
        echo '            <td class="smallText">' . nl2br(tep_db_output($orders_history['comments'])) . '&nbsp;</td>' . "\n" .
             '          </tr>' . "\n";
      }
    } else {
        echo '          <tr>' . "\n" .
             '            <td class="smallText" colspan="5">' . TEXT_NO_ORDER_HISTORY . '</td>' . "\n" .
             '          </tr>' . "\n";
    }
?>
        </table></td>
      </tr>
<?php
  } elseif ($HTTP_GET_VARS['action'] == 'email_confirm') {
    // ᡼ۿǧ
    $order = new order($oID);
?>
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
             <td class="pageHeading" align="right"><?php echo '<a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=edit') . '">' . tep_image_button('button_back.gif', IMAGE_BACK) . '</a>'; ?></td>
          </tr>
        </table></td>
      </tr>
      <tr><?php echo tep_draw_form('send', FILENAME_ORDERS, tep_get_all_get_params(array('action')) . 'action=send_email'); ?><?php echo tep_draw_hidden_field('status', $status) . tep_draw_hidden_field('comments', $comments) . tep_draw_hidden_field('customer_name', $order->customer['name']) . tep_draw_hidden_field('email_address', $order->customer['email_address']) . tep_draw_hidden_field('email_subject', $email_subject) . tep_draw_hidden_field('email_contents', $email_contents) . tep_draw_hidden_field('customer_notified', $customer_notified); ?>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="main"><b><?php echo TEXT_INFO_EMAIL_SEND; ?></b>&nbsp;&nbsp;<?php echo tep_image_submit('button_send.gif', IMAGE_SEND); ?></td>
      </tr>
      <tr>
        <td><table border="0" cellspacing="0" cellpadding="2">
          <tr class="dataTableRow">
            <td class="dataTableContent"><?php echo $email_subject; ?></td>
          </tr>
          <tr class="dataTableRow">
            <td class="dataTableContent"><?php echo tep_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
          </tr>
          <tr class="dataTableRow">
            <td class="dataTableContent"><?php echo nl2br($email_contents); ?></td>
          </tr>
        </table></td>
      </form></tr>
<?php
  } else {
    // 
?>
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
            <td align="right"><table border="0" width="100%" cellspacing="0" cellpadding="0">
              <tr><?php echo tep_draw_form('orders', FILENAME_ORDERS, '', 'get'); ?>
                <td class="smallText" align="right"><?php echo HEADING_TITLE_SEARCH . ' ' . tep_draw_input_field('oID', '', 'size="12"') . tep_draw_hidden_field('action', 'edit'); ?></td>
              </form></tr>
              <tr><?php echo tep_draw_form('status', FILENAME_ORDERS, '', 'get'); ?>
                <td class="smallText" align="right"><?php echo HEADING_TITLE_STATUS . ' ' . tep_draw_pull_down_menu('status', tep_array_merge(array(array('id' => '', 'text' => TEXT_ALL_ORDERS)), $orders_statuses), '', 'onChange="this.form.submit();"'); ?></td>
              </form></tr>            
            </table></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
              <tr class="dataTableHeadingRow">
                <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_CUSTOMERS; ?></td>
                <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_ORDER_TOTAL; ?></td>
                <td class="dataTableHeadingContent" align="center"><?php echo TABLE_HEADING_DATE_PURCHASED; ?></td>
                <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_STATUS; ?></td>
                <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_ACTION; ?>&nbsp;</td>
              </tr>
<?php
    if ($HTTP_GET_VARS['cID']) {
      $cID = tep_db_prepare_input($HTTP_GET_VARS['cID']);
      $orders_query_raw = "select o.orders_id, o.customers_name, o.customers_id, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . TABLE_ORDERS_STATUS . " s where o.customers_id = '" . tep_db_input($cID) . "' and o.orders_status = s.orders_status_id and s.language_id = '" . $languages_id . "' and ot.class = 'ot_total' order by orders_id DESC";
    } elseif ($HTTP_GET_VARS['status']) {
      $status = tep_db_prepare_input($HTTP_GET_VARS['status']);
      $orders_query_raw = "select o.orders_id, o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . TABLE_ORDERS_STATUS . " s where o.orders_status = s.orders_status_id and s.language_id = '" . $languages_id . "' and s.orders_status_id = '" . tep_db_input($status) . "' and ot.class = 'ot_total' order by o.orders_id DESC";
    } else {
      $orders_query_raw = "select o.orders_id, o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . TABLE_ORDERS_STATUS . " s where o.orders_status = s.orders_status_id and s.language_id = '" . $languages_id . "' and ot.class = 'ot_total' order by o.orders_id DESC";
    }
    $orders_split = new splitPageResults($HTTP_GET_VARS['page'], MAX_DISPLAY_SEARCH_RESULTS, $orders_query_raw, $orders_query_numrows);
    $orders_query = tep_db_query($orders_query_raw);
    while ($orders = tep_db_fetch_array($orders_query)) {
      if (((!$HTTP_GET_VARS['oID']) || ($HTTP_GET_VARS['oID'] == $orders['orders_id'])) && (!$oInfo)) {
        $oInfo = new objectInfo($orders);
      }

      if ( (is_object($oInfo)) && ($orders['orders_id'] == $oInfo->orders_id) ) {
        echo '              <tr class="dataTableRowSelected" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=edit') . '\'">' . "\n";
      } else {
        echo '              <tr class="dataTableRow" onmouseover="this.className=\'dataTableRowOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'dataTableRow\'" onclick="document.location.href=\'' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID')) . 'oID=' . $orders['orders_id']) . '\'">' . "\n";
      }
?>
                <td class="dataTableContent"><?php echo '<a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $orders['orders_id'] . '&action=edit') . '">' . tep_image(DIR_WS_ICONS . 'preview.gif', ICON_PREVIEW) . '</a>&nbsp;' . $orders['customers_name']; ?></td>
                <td class="dataTableContent" align="right"><?php echo strip_tags($orders['order_total']); ?></td>
                <td class="dataTableContent" align="center"><?php echo tep_datetime_short($orders['date_purchased']); ?></td>
                <td class="dataTableContent" align="right"><?php echo $orders['orders_status_name']; ?></td>
                <td class="dataTableContent" align="right"><?php if ( (is_object($oInfo)) && ($orders['orders_id'] == $oInfo->orders_id) ) { echo tep_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID')) . 'oID=' . $orders['orders_id']) . '">' . tep_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
?>
              <tr>
                <td colspan="5"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td class="smallText" valign="top"><?php echo $orders_split->display_count($orders_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $HTTP_GET_VARS['page'], TEXT_DISPLAY_NUMBER_OF_ORDERS); ?></td>
                    <td class="smallText" align="right"><?php echo $orders_split->display_links($orders_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $HTTP_GET_VARS['page'], tep_get_all_get_params(array('page', 'oID', 'action'))); ?></td>
                  </tr>
                </table></td>
              </tr>
            </table></td>
<?php
  $heading = array();
  $contents = array();
  switch ($HTTP_GET_VARS['action']) {
    case 'delete':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_ORDER . '</b>');

      $contents = array('form' => tep_draw_form('orders', FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=deleteconfirm'));
      $contents[] = array('text' => TEXT_INFO_DELETE_INTRO . '<br><br><b>' . tep_get_fullname($cInfo->customers_firstname, $cInfo->customers_lastname) . '</b>');
      $contents[] = array('text' => '<br>' . tep_draw_checkbox_field('restock') . ' ' . TEXT_INFO_RESTOCK_PRODUCT_QUANTITY);
      $contents[] = array('align' => 'center', 'text' => '<br>' . tep_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id) . '">' . tep_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
      break;
    default:
      if (is_object($oInfo)) {
        $heading[] = array('text' => '<b>[' . $oInfo->orders_id . ']&nbsp;&nbsp;' . tep_datetime_short($oInfo->date_purchased) . '</b>');

        $contents[] = array('align' => 'center', 'text' => '<a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=edit') . '">' . tep_image_button('button_edit.gif', IMAGE_EDIT) . '</a> <a href="' . tep_href_link(FILENAME_ORDERS, tep_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=delete') . '">' . tep_image_button('button_delete.gif', IMAGE_DELETE) . '</a>');
        $contents[] = array('align' => 'center', 'text' => '<a href="' . tep_href_link(FILENAME_ORDERS_INVOICE, 'oID=' . $oInfo->orders_id) . '" TARGET="_blank">' . tep_image_button('button_invoice.gif', IMAGE_ORDERS_INVOICE) . '</a> <a href="' . tep_href_link(FILENAME_ORDERS_PACKINGSLIP, 'oID=' . $oInfo->orders_id) . '" TARGET="_blank">' . tep_image_button('button_packingslip.gif', IMAGE_ORDERS_PACKINGSLIP) . '</a>');
        $contents[] = array('text' => '<br>' . TEXT_DATE_ORDER_CREATED . ' ' . tep_date_short($oInfo->date_purchased));
        if (tep_not_null($oInfo->last_modified)) $contents[] = array('text' => TEXT_DATE_ORDER_LAST_MODIFIED . ' ' . tep_date_short($oInfo->last_modified));
        $contents[] = array('text' => '<br>' . TEXT_INFO_PAYMENT_METHOD . ' '  . $oInfo->payment_method);
      }
      break;
  }

  if ( (tep_not_null($heading)) && (tep_not_null($contents)) ) {
    echo '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table></td>
      </tr>
<?php
  }
?>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->

<!-- footer //-->
<?php
    require(DIR_WS_INCLUDES . 'footer.php');
?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
